/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.callback.Callback;
import org.jruby.util.ByteList;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static Provider provider = null;

    public static void createDigest(Ruby ruby) {
        try {
            provider = (Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RubyModule rubyModule = ruby.defineModule("Digest");
        RubyClass rubyClass = rubyModule.defineClassUnder("Base", ruby.getObject(), Base.BASE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(Base.class);
    }

    private static MessageDigest createMessageDigest(Ruby ruby, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return MessageDigest.getInstance(string, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(string);
    }

    public static void createDigestMD5(Ruby ruby) {
        ruby.getLoadService().require("digest.so");
        RubyModule rubyModule = ruby.fastGetModule("Digest");
        RubyClass rubyClass = rubyModule.fastGetClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("MD5", rubyClass, rubyClass.getAllocator());
        rubyClass2.defineFastMethod("block_length", new Callback(){

            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                return RubyFixnum.newFixnum(iRubyObject.getRuntime(), 64L);
            }
        });
        rubyClass2.setInternalModuleVariable("metadata", ruby.newString("MD5"));
    }

    public static void createDigestRMD160(Ruby ruby) {
        ruby.getLoadService().require("digest.so");
        if (provider == null) {
            throw ruby.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule rubyModule = ruby.fastGetModule("Digest");
        RubyClass rubyClass = rubyModule.fastGetClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("RMD160", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalModuleVariable("metadata", ruby.newString("RIPEMD160"));
    }

    public static void createDigestSHA1(Ruby ruby) {
        ruby.getLoadService().require("digest.so");
        RubyModule rubyModule = ruby.fastGetModule("Digest");
        RubyClass rubyClass = rubyModule.fastGetClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("SHA1", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalModuleVariable("metadata", ruby.newString("SHA1"));
    }

    public static void createDigestSHA2(Ruby ruby) {
        ruby.getLoadService().require("digest.so");
        try {
            RubyDigest.createMessageDigest(ruby, "SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ruby.newLoadError("SHA2 not supported");
        }
        RubyModule rubyModule = ruby.fastGetModule("Digest");
        RubyClass rubyClass = rubyModule.fastGetClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("SHA256", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalModuleVariable("metadata", ruby.newString("SHA-256"));
        RubyClass rubyClass3 = rubyModule.defineClassUnder("SHA384", rubyClass, rubyClass.getAllocator());
        rubyClass3.setInternalModuleVariable("metadata", ruby.newString("SHA-384"));
        RubyClass rubyClass4 = rubyModule.defineClassUnder("SHA512", rubyClass, rubyClass.getAllocator());
        rubyClass4.setInternalModuleVariable("metadata", ruby.newString("SHA-512"));
    }

    @JRubyClass(name={"Digest::Base"})
    public static class Base
    extends RubyObject {
        protected static final ObjectAllocator BASE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Base(ruby, rubyClass);
            }
        };
        private MessageDigest algo;
        private StringBuffer data = new StringBuffer();

        @JRubyMethod(name={"digest"}, required=1, meta=true)
        public static IRubyObject s_digest(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = iRubyObject.getRuntime();
            String string = ((RubyClass)iRubyObject).searchInternalModuleVariable("metadata").toString();
            try {
                MessageDigest messageDigest = RubyDigest.createMessageDigest(ruby, string);
                return RubyString.newString(ruby, messageDigest.digest(iRubyObject2.convertToString().getBytes()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw iRubyObject.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + string + ")");
            }
        }

        @JRubyMethod(name={"hexdigest"}, required=1, meta=true)
        public static IRubyObject s_hexdigest(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = iRubyObject.getRuntime();
            String string = ((RubyClass)iRubyObject).searchInternalModuleVariable("metadata").toString();
            try {
                MessageDigest messageDigest = RubyDigest.createMessageDigest(ruby, string);
                return RubyString.newString(ruby, ByteList.plain((CharSequence)Base.toHex(messageDigest.digest(iRubyObject2.convertToString().getBytes()))));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw iRubyObject.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + string + ")");
            }
        }

        public Base(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
            if (rubyClass == ruby.fastGetModule("Digest").fastGetClass("Base")) {
                throw ruby.newNotImplementedError("Digest::Base is an abstract class");
            }
            if (!rubyClass.hasInternalModuleVariable("metadata")) {
                throw ruby.newNotImplementedError("the " + rubyClass + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(rubyClass.searchInternalModuleVariable("metadata"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw ruby.newNotImplementedError("the " + rubyClass + "() function is unimplemented on this machine");
            }
        }

        @JRubyMethod(name={"initialize"}, optional=1, frame=true)
        public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil()) {
                this.update(iRubyObjectArray[0]);
            }
            return this;
        }

        @JRubyMethod(name={"initialize_copy"}, required=1)
        public IRubyObject initialize_copy(IRubyObject iRubyObject) {
            if (this == iRubyObject) {
                return this;
            }
            ((RubyObject)iRubyObject).checkFrozen();
            this.data = new StringBuffer(((Base)iRubyObject).data.toString());
            String string = ((Base)iRubyObject).algo.getAlgorithm();
            try {
                this.algo = RubyDigest.createMessageDigest(this.getRuntime(), string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw this.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + string + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject iRubyObject) {
            this.data.append(iRubyObject);
            return this;
        }

        @JRubyMethod(name={"digest"}, optional=1)
        public IRubyObject digest(IRubyObject[] iRubyObjectArray) {
            if (iRubyObjectArray.length == 1) {
                this.reset();
                this.data.append(iRubyObjectArray[0]);
            }
            IRubyObject iRubyObject = this.getDigest();
            if (iRubyObjectArray.length == 1) {
                this.reset();
            }
            return iRubyObject;
        }

        private IRubyObject getDigest() {
            this.algo.reset();
            return RubyString.newString(this.getRuntime(), this.algo.digest(ByteList.plain((CharSequence)this.data)));
        }

        @JRubyMethod(name={"digest!"})
        public IRubyObject digest_bang() {
            this.algo.reset();
            byte[] byArray = this.algo.digest(ByteList.plain((CharSequence)this.data));
            this.reset();
            return RubyString.newString(this.getRuntime(), byArray);
        }

        @JRubyMethod(name={"hexdigest"}, optional=1)
        public IRubyObject hexdigest(IRubyObject[] iRubyObjectArray) {
            this.algo.reset();
            if (iRubyObjectArray.length == 1) {
                this.reset();
                this.data.append(iRubyObjectArray[0]);
            }
            byte[] byArray = ByteList.plain((CharSequence)Base.toHex(this.algo.digest(ByteList.plain((CharSequence)this.data))));
            if (iRubyObjectArray.length == 1) {
                this.reset();
            }
            return RubyString.newString(this.getRuntime(), byArray);
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s() {
            this.algo.reset();
            return RubyString.newString(this.getRuntime(), ByteList.plain((CharSequence)Base.toHex(this.algo.digest(ByteList.plain((CharSequence)this.data)))));
        }

        @JRubyMethod(name={"hexdigest!"})
        public IRubyObject hexdigest_bang() {
            this.algo.reset();
            byte[] byArray = ByteList.plain((CharSequence)Base.toHex(this.algo.digest(ByteList.plain((CharSequence)this.data))));
            this.reset();
            return RubyString.newString(this.getRuntime(), byArray);
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            this.algo.reset();
            return RubyString.newString(this.getRuntime(), ByteList.plain((CharSequence)("#<" + this.getMetaClass().getRealClass().getName() + ": " + Base.toHex(this.algo.digest(ByteList.plain((CharSequence)this.data))) + ">")));
        }

        @JRubyMethod(name={"=="}, required=1)
        public IRubyObject op_equal(IRubyObject iRubyObject) {
            boolean bl;
            boolean bl2 = bl = this == iRubyObject;
            if (!bl) {
                if (iRubyObject instanceof Base) {
                    Base base = (Base)iRubyObject;
                    bl = this.algo.getAlgorithm().equals(base.algo.getAlgorithm()) && this.getDigest().equals(base.getDigest());
                } else {
                    RubyString rubyString = iRubyObject.convertToString();
                    bl = this.to_s().equals(rubyString);
                }
            }
            return bl ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"length", "size", "digest_length"})
        public IRubyObject length() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
        }

        @JRubyMethod(name={"block_length"})
        public IRubyObject block_length() {
            throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
        }

        @JRubyMethod(name={"reset"})
        public IRubyObject reset() {
            this.algo.reset();
            this.data = new StringBuffer();
            return this.getRuntime().getNil();
        }

        private void setAlgorithm(IRubyObject iRubyObject) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(this.getRuntime(), iRubyObject.toString());
        }

        private static String toHex(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String string = Integer.toString((char)byArray[i] & 0xFF, 16);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }
}

