/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ObjectMarshal;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.runtime.component.VariableEntry;
import org.jruby.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.nb.util.SafePropertyAccessor;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    private StackTraceElement[] backtraceFrames;
    private StackTraceElement[] javaStackTrace;
    private IRubyObject backtrace;
    public IRubyObject message;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    private static ObjectAllocator EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyException rubyException = new RubyException(ruby, rubyClass);
            rubyException.setMetaClass(rubyClass);
            return rubyException;
        }
    };
    private static final ObjectMarshal EXCEPTION_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
            RubyException rubyException = (RubyException)object;
            marshalStream.registerLinkTarget(rubyException);
            List<Variable<IRubyObject>> list = rubyException.getVariableList();
            list.add(new VariableEntry<IRubyObject>("mesg", rubyException.message == null ? ruby.getNil() : rubyException.message));
            list.add(new VariableEntry<IRubyObject>("bt", rubyException.getBacktrace()));
            marshalStream.dumpVariables(list);
        }

        public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
            RubyException rubyException = (RubyException)rubyClass.allocate();
            unmarshalStream.registerLinkTarget(rubyException);
            unmarshalStream.defaultVariablesUnmarshal(rubyException);
            rubyException.message = rubyException.removeInternalVariable("mesg");
            rubyException.set_backtrace(rubyException.removeInternalVariable("bt"));
            return rubyException;
        }
    };
    public static final int RAW = 0;
    public static final int RAW_FILTERED = 1;
    public static final int RUBY_FRAMED = 2;
    public static final int RUBY_COMPILED = 3;
    public static final int RUBY_HYBRID = 4;
    public static final int TRACE_TYPE;

    protected RubyException(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, null);
    }

    public RubyException(Ruby ruby, RubyClass rubyClass, String string) {
        super(ruby, rubyClass);
        this.message = string == null ? ruby.getNil() : ruby.newString(string);
    }

    public static RubyClass createExceptionClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Exception", ruby.getObject(), EXCEPTION_ALLOCATOR);
        ruby.setException(rubyClass);
        rubyClass.setMarshal(EXCEPTION_MARSHAL);
        rubyClass.defineAnnotatedMethods(RubyException.class);
        return rubyClass;
    }

    public static RubyException newException(Ruby ruby, RubyClass rubyClass, String string) {
        return new RubyException(ruby, rubyClass, string);
    }

    public void setBacktraceFrames(StackTraceElement[] stackTraceElementArray) {
        this.backtraceFrames = stackTraceElementArray;
        if (TRACE_TYPE == 0 || TRACE_TYPE == 1 || TRACE_TYPE == 3 || TRACE_TYPE == 4) {
            this.javaStackTrace = Thread.currentThread().getStackTrace();
        }
    }

    public IRubyObject getBacktrace() {
        if (this.backtrace == null) {
            this.initBacktrace();
        }
        return this.backtrace;
    }

    public void initBacktrace() {
        switch (TRACE_TYPE) {
            case 0: {
                this.backtrace = ThreadContext.createRawBacktrace(this.getRuntime(), this.javaStackTrace, false);
                break;
            }
            case 1: {
                this.backtrace = ThreadContext.createRawBacktrace(this.getRuntime(), this.javaStackTrace, true);
                break;
            }
            case 2: {
                this.backtrace = this.backtraceFrames == null ? this.getRuntime().getNil() : ThreadContext.createBacktraceFromFrames(this.getRuntime(), this.backtraceFrames);
                break;
            }
            case 3: {
                this.backtrace = ThreadContext.createRubyCompiledBacktrace(this.getRuntime(), this.javaStackTrace);
                break;
            }
            case 4: {
                this.backtrace = ThreadContext.createRubyHybridBacktrace(this.getRuntime(), this.backtraceFrames, this.javaStackTrace, this.getRuntime().getDebug().isTrue());
            }
        }
    }

    @JRubyMethod(optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length == 1) {
            this.message = iRubyObjectArray[0];
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            this.backtrace = null;
        } else {
            if (!this.isArrayOfStrings(iRubyObject)) {
                throw this.getRuntime().newTypeError("backtrace must be Array of String");
            }
            this.backtrace = (RubyArray)iRubyObject;
        }
        return this.backtrace();
    }

    @JRubyMethod(name={"exception"}, optional=1, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return ((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (iRubyObjectArray[0] == this) {
                    return this;
                }
                RubyException rubyException = (RubyException)this.rbClone();
                rubyException.initialize(iRubyObjectArray, Block.NULL_BLOCK);
                return rubyException;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @JRubyMethod
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.getMetaClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return this.message;
    }

    @JRubyMethod(name={"to_str", "message"})
    public IRubyObject to_str(ThreadContext threadContext) {
        return this.callMethod(threadContext, MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext threadContext) {
        RubyClass rubyClass = this.getMetaClass();
        RubyString rubyString = RubyString.objAsString(threadContext, this);
        if (rubyString.getByteList().realSize == 0) {
            return this.getRuntime().newString(rubyClass.getName());
        }
        StringBuilder stringBuilder = new StringBuilder("#<");
        stringBuilder.append(rubyClass.getName()).append(": ").append((CharSequence)rubyString.getByteList()).append(">");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    public void printBacktrace(PrintStream printStream) {
        IRubyObject iRubyObject = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        boolean bl = this.getRuntime().getDebug().isTrue();
        if (!iRubyObject.isNil() && iRubyObject instanceof RubyArray) {
            IRubyObject[] iRubyObjectArray = iRubyObject.convertToArray().toJavaArray();
            for (int i = 1; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject2 = iRubyObjectArray[i];
                if (iRubyObject2 instanceof RubyString) {
                    this.printStackTraceLine(printStream, iRubyObject2);
                }
                if (bl || i != 8 || iRubyObjectArray.length <= 18) continue;
                int n = iRubyObjectArray.length - 8 - 4;
                printStream.print("\t ... " + n + " levels...\n");
                i = iRubyObjectArray.length - 4;
            }
        }
    }

    private void printStackTraceLine(PrintStream printStream, IRubyObject iRubyObject) {
        printStream.print("\tfrom " + iRubyObject + '\n');
    }

    private boolean isArrayOfStrings(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray)) {
            return false;
        }
        IRubyObject[] iRubyObjectArray = ((RubyArray)iRubyObject).toJavaArray();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i] instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    static {
        String string = SafePropertyAccessor.getProperty("jruby.backtrace.style", "ruby_framed").toLowerCase();
        TRACE_TYPE = string.equals("raw") ? 0 : (string.equals("raw_filtered") ? 1 : (string.equals("ruby_framed") ? 2 : (string.equals("ruby_compiled") ? 3 : (string.equals("ruby_hybrid") ? 4 : 2))));
    }
}

