/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.CompatVersion;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyInteger;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyRational;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.java.MiniJava;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.nb.util.Convert;
import org.jruby.nb.nb.util.Numeric;
import org.jruby.nb.nb.util.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Fixnum"}, parent="Integer", include={"Precision"})
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    private static final int CACHE_OFFSET = 128;
    private static final Map<Class, TypeCoercer> JAVA_COERCERS = new HashMap<Class, TypeCoercer>();

    public static RubyClass createFixnumClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Fixnum", ruby.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setFixnum(rubyClass);
        rubyClass.index = 1;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyFixnum;
            }
        };
        rubyClass.includeModule(ruby.getPrecision());
        rubyClass.defineAnnotatedMethods(RubyFixnum.class);
        for (int i = 0; i < ruby.fixnumCache.length; ++i) {
            ruby.fixnumCache[i] = new RubyFixnum(ruby, rubyClass, i - 128);
        }
        return rubyClass;
    }

    private static IRubyObject fixCoerce(IRubyObject iRubyObject) {
        while (!((iRubyObject = iRubyObject.convertToInteger()) instanceof RubyFixnum) && !(iRubyObject instanceof RubyBignum)) {
        }
        return iRubyObject;
    }

    public RubyFixnum(Ruby ruby) {
        this(ruby, 0L);
    }

    public RubyFixnum(Ruby ruby, long l) {
        super(ruby, ruby.getFixnum(), false);
        this.value = l;
    }

    private RubyFixnum(Ruby ruby, RubyClass rubyClass, long l) {
        super(ruby, rubyClass, false);
        this.value = l;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    @Override
    public final boolean eql(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubyFixnum && this.value == ((RubyFixnum)iRubyObject).value;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum newFixnum(Ruby ruby, long l) {
        if (RubyFixnum.isInCacheRange(l)) {
            return ruby.fixnumCache[(int)l + 128];
        }
        return new RubyFixnum(ruby, l);
    }

    private static boolean isInCacheRange(long l) {
        return l <= 127L && l >= -128L;
    }

    public RubyFixnum newFixnum(long l) {
        return RubyFixnum.newFixnum(this.getRuntime(), l);
    }

    public static RubyFixnum zero(Ruby ruby) {
        return ruby.fixnumCache[128];
    }

    public static RubyFixnum one(Ruby ruby) {
        return ruby.fixnumCache[129];
    }

    public static RubyFixnum two(Ruby ruby) {
        return ruby.fixnumCache[130];
    }

    public static RubyFixnum three(Ruby ruby) {
        return ruby.fixnumCache[131];
    }

    public static RubyFixnum four(Ruby ruby) {
        return ruby.fixnumCache[132];
    }

    public static RubyFixnum five(Ruby ruby) {
        return ruby.fixnumCache[133];
    }

    public static RubyFixnum minus_one(Ruby ruby) {
        return ruby.fixnumCache[127];
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)object;
            if (rubyFixnum.value == this.value) {
                return true;
            }
        }
        return false;
    }

    public RubyString to_s(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(iRubyObjectArray[0]);
            }
        }
        throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
    }

    @Override
    @JRubyMethod
    public RubyString to_s() {
        int n = 10;
        return this.getRuntime().newString(Convert.longToByteList(this.value, n));
    }

    @JRubyMethod
    public RubyString to_s(IRubyObject iRubyObject) {
        int n = RubyFixnum.num2int(iRubyObject);
        if (n < 2 || n > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + n);
        }
        return this.getRuntime().newString(Convert.longToByteList(this.value, n));
    }

    @JRubyMethod
    public IRubyObject id2name() {
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (rubySymbol != null) {
            return this.getRuntime().newString(rubySymbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject to_sym() {
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return rubySymbol != null ? rubySymbol : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.addFixnum(threadContext, (RubyFixnum)iRubyObject);
        }
        return this.addOther(threadContext, iRubyObject);
    }

    private IRubyObject addFixnum(ThreadContext threadContext, RubyFixnum rubyFixnum) {
        long l = rubyFixnum.value;
        long l2 = this.value + l;
        if (RubyFixnum.additionOverflowed(this.value, l, l2)) {
            return this.addAsBignum(threadContext, rubyFixnum);
        }
        return RubyFixnum.newFixnum(threadContext.getRuntime(), l2);
    }

    private static boolean additionOverflowed(long l, long l2, long l3) {
        return ((l ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) & (l ^ l3) & Long.MIN_VALUE) != 0L;
    }

    private static boolean subtractionOverflowed(long l, long l2, long l3) {
        return ((l ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (l ^ l3) & Long.MIN_VALUE) != 0L;
    }

    private IRubyObject addAsBignum(ThreadContext threadContext, RubyFixnum rubyFixnum) {
        return RubyBignum.newBignum(threadContext.getRuntime(), this.value).op_plus(threadContext, rubyFixnum);
    }

    private IRubyObject addOther(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_plus(threadContext, this);
        }
        if (iRubyObject instanceof RubyFloat) {
            return threadContext.getRuntime().newFloat((double)this.value + ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.subtractFixnum(threadContext, (RubyFixnum)iRubyObject);
        }
        return this.subtractOther(threadContext, iRubyObject);
    }

    private IRubyObject subtractFixnum(ThreadContext threadContext, RubyFixnum rubyFixnum) {
        long l = rubyFixnum.value;
        long l2 = this.value - l;
        if (RubyFixnum.subtractionOverflowed(this.value, l, l2)) {
            return this.subtractAsBignum(threadContext, rubyFixnum);
        }
        return RubyFixnum.newFixnum(threadContext.getRuntime(), l2);
    }

    private IRubyObject subtractAsBignum(ThreadContext threadContext, RubyFixnum rubyFixnum) {
        return RubyBignum.newBignum(threadContext.getRuntime(), this.value).op_minus(threadContext, rubyFixnum);
    }

    private IRubyObject subtractOther(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyBignum) {
            return RubyBignum.newBignum(threadContext.getRuntime(), this.value).op_minus(threadContext, iRubyObject);
        }
        if (iRubyObject instanceof RubyFloat) {
            return threadContext.getRuntime().newFloat((double)this.value - ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            if (this.value == 0L) {
                return RubyFixnum.zero(ruby);
            }
            long l2 = this.value * l;
            if (l2 / this.value != l) {
                return RubyBignum.newBignum(ruby, this.value).op_mul(threadContext, iRubyObject);
            }
            return RubyFixnum.newFixnum(ruby, l2);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).op_mul(threadContext, this);
        }
        if (iRubyObject instanceof RubyFloat) {
            return ruby.newFloat((double)this.value * ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.idiv(threadContext, iRubyObject, "div");
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.idiv(threadContext, iRubyObject, "/");
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p() {
        if (this.value % 2L != 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p() {
        if (this.value % 2L == 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject pred() {
        return this.getRuntime().newFixnum(this.value - 1L);
    }

    public IRubyObject idiv(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            if (l2 == 0L) {
                throw threadContext.getRuntime().newZeroDivisionError();
            }
            long l3 = l / l2;
            long l4 = l % l2;
            if (l4 < 0L && l2 > 0L || l4 > 0L && l2 < 0L) {
                --l3;
            }
            return threadContext.getRuntime().newFixnum(l3);
        }
        return this.coerceBin(threadContext, string, iRubyObject);
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            if (l2 == 0L) {
                throw threadContext.getRuntime().newZeroDivisionError();
            }
            long l3 = l % l2;
            if (l3 < 0L && l2 > 0L || l3 > 0L && l2 < 0L) {
                l3 += l2;
            }
            return threadContext.getRuntime().newFixnum(l3);
        }
        return this.coerceBin(threadContext, "%", iRubyObject);
    }

    @Override
    @JRubyMethod
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = this.value;
            long l2 = ((RubyFixnum)iRubyObject).value;
            Ruby ruby = threadContext.getRuntime();
            if (l2 == 0L) {
                throw ruby.newZeroDivisionError();
            }
            long l3 = l / l2;
            long l4 = l % l2;
            if (l4 < 0L && l2 > 0L || l4 > 0L && l2 < 0L) {
                --l3;
                l4 += l2;
            }
            RubyFixnum rubyFixnum = RubyFixnum.newFixnum(ruby, l3);
            RubyFixnum rubyFixnum2 = RubyFixnum.newFixnum(ruby, l4);
            return RubyArray.newArray(ruby, rubyFixnum, rubyFixnum2);
        }
        return this.coerceBin(threadContext, "divmod", iRubyObject);
    }

    @Override
    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyFloat.newFloat(threadContext.getRuntime(), (double)this.value / (double)((RubyFixnum)iRubyObject).value);
        }
        return this.coerceBin(threadContext, "quo", iRubyObject);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).value;
            if (l == 0L) {
                return RubyFixnum.one(threadContext.getRuntime());
            }
            if (l == 1L) {
                return this;
            }
            if (l > 0L) {
                return RubyBignum.newBignum(threadContext.getRuntime(), this.value).op_pow(threadContext, iRubyObject);
            }
            return RubyFloat.newFloat(threadContext.getRuntime(), Math.pow(this.value, l));
        }
        if (iRubyObject instanceof RubyFloat) {
            return RubyFloat.newFloat(threadContext.getRuntime(), Math.pow(this.value, ((RubyFloat)iRubyObject).getDoubleValue()));
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @JRubyMethod(name={"**"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow_19(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        long l = this.value;
        if (iRubyObject instanceof RubyFixnum) {
            long l2 = ((RubyFixnum)iRubyObject).value;
            if (l2 < 0L) {
                return RubyRational.newRationalRaw(threadContext.getRuntime(), this).callMethod(threadContext, "**", iRubyObject);
            }
            if (l2 == 0L) {
                return RubyFixnum.one(ruby);
            }
            if (l2 == 1L) {
                return this;
            }
            if (l == 0L) {
                return l2 > 0L ? RubyFixnum.zero(ruby) : RubyNumeric.dbl2num(ruby, Double.POSITIVE_INFINITY);
            }
            if (l == 1L) {
                return RubyFixnum.one(ruby);
            }
            if (l == -1L) {
                return l2 % 2L == 0L ? RubyFixnum.one(ruby) : RubyFixnum.minus_one(ruby);
            }
            return Numeric.int_pow(threadContext, l, l2);
        }
        if (iRubyObject instanceof RubyBignum) {
            if (iRubyObject.callMethod(threadContext, "<", RubyFixnum.zero(ruby)).isTrue()) {
                return RubyRational.newRationalRaw(ruby, this).callMethod(threadContext, "**", iRubyObject);
            }
            if (l == 0L) {
                return RubyFixnum.zero(ruby);
            }
            if (l == 1L) {
                return RubyFixnum.one(ruby);
            }
            if (l == -1L) {
                return RubyInteger.even_p(threadContext, iRubyObject).isTrue() ? RubyFixnum.one(ruby) : RubyFixnum.minus_one(ruby);
            }
            RubyBignum.newBignum(ruby, RubyBignum.fix2big(this)).op_pow(threadContext, iRubyObject);
        } else if (iRubyObject instanceof RubyFloat) {
            return RubyFloat.newFloat(threadContext.getRuntime(), Math.pow(l, ((RubyFloat)iRubyObject).getDoubleValue()));
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @JRubyMethod
    public IRubyObject abs() {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(threadContext.getRuntime(), this.value == ((RubyFixnum)iRubyObject).value);
        }
        return super.op_num_equal(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.compareFixnum(threadContext, (RubyFixnum)iRubyObject);
        }
        return this.coerceCmp(threadContext, "<=>", iRubyObject);
    }

    private IRubyObject compareFixnum(ThreadContext threadContext, RubyFixnum rubyFixnum) {
        long l = rubyFixnum.value;
        if (this.value == l) {
            return RubyFixnum.zero(threadContext.getRuntime());
        }
        if (this.value > l) {
            return RubyFixnum.one(threadContext.getRuntime());
        }
        return RubyFixnum.minus_one(threadContext.getRuntime());
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(threadContext.getRuntime(), this.value > ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, ">", iRubyObject);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(threadContext.getRuntime(), this.value >= ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, ">=", iRubyObject);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(threadContext.getRuntime(), this.value < ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, "<", iRubyObject);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(threadContext.getRuntime(), this.value <= ((RubyFixnum)iRubyObject).value);
        }
        return this.coerceRelOp(threadContext, "<=", iRubyObject);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum || (iRubyObject = RubyFixnum.fixCoerce(iRubyObject)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(threadContext.getRuntime(), this.value & ((RubyFixnum)iRubyObject).value);
        }
        return ((RubyBignum)iRubyObject).op_and(threadContext, this);
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum || (iRubyObject = RubyFixnum.fixCoerce(iRubyObject)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(threadContext.getRuntime(), this.value | ((RubyFixnum)iRubyObject).value);
        }
        return ((RubyBignum)iRubyObject).op_or(threadContext, this);
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum || (iRubyObject = RubyFixnum.fixCoerce(iRubyObject)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(threadContext.getRuntime(), this.value ^ ((RubyFixnum)iRubyObject).value);
        }
        return ((RubyBignum)iRubyObject).op_xor(threadContext, this);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject iRubyObject) {
        long l;
        if (!(iRubyObject instanceof RubyFixnum) && !((iRubyObject = RubyFixnum.fixCoerce(iRubyObject)) instanceof RubyFixnum)) {
            RubyBignum rubyBignum = (RubyBignum)iRubyObject;
            RubyInteger rubyInteger = RubyBignum.bignorm(this.getRuntime(), rubyBignum.getValue());
            if (!(rubyInteger instanceof RubyFixnum)) {
                return rubyBignum.getValue().signum() == 0 || this.value >= 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
            }
        }
        if ((l = RubyFixnum.fix2long(iRubyObject)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < l) {
            return this.value < 0L ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)l) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_lshift(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(iRubyObject);
        }
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        return l < 0L ? this.rshift(-l) : this.lshift(l);
    }

    private IRubyObject lshift(long l) {
        if (l > 63L || (-1L << (int)(64L - l - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(RubyFixnum.newFixnum(this.getRuntime(), l));
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value << (int)l);
    }

    @JRubyMethod(name={">>"})
    public IRubyObject op_rshift(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_rshift(iRubyObject);
        }
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l == 0L) {
            return this;
        }
        return l < 0L ? this.lshift(-l) : this.rshift(l);
    }

    private IRubyObject rshift(long l) {
        if (l >= 63L) {
            return this.value < 0L ? RubyFixnum.minus_one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value >> (int)l);
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint(ThreadContext threadContext) {
        return this;
    }

    @Override
    public IRubyObject freeze(ThreadContext threadContext) {
        return this;
    }

    @Override
    public String asJavaString() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "do not use Fixnums as Symbols", new Object[0]);
        RubySymbol rubySymbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (rubySymbol == null) {
            throw this.getRuntime().newArgumentError("" + this.value + " is not a symbol");
        }
        return rubySymbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        return unmarshalStream.getRuntime().newFixnum(unmarshalStream.unmarshalInt());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNumeric.num2fix(iRubyObject2);
    }

    @Override
    public IRubyObject to_java() {
        return MiniJava.javaToRuby(this.getRuntime(), this.value);
    }

    @Override
    public IRubyObject as(Class clazz) {
        return MiniJava.javaToRuby(this.getRuntime(), RubyFixnum.coerceToJavaType(this.getRuntime(), this, clazz));
    }

    private static Object coerceToJavaType(Ruby ruby, RubyFixnum rubyFixnum, Class clazz) {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw ruby.newTypeError(clazz.getCanonicalName() + " is not a numeric type");
        }
        TypeCoercer typeCoercer = JAVA_COERCERS.get(clazz);
        if (typeCoercer == null) {
            throw ruby.newTypeError("Cannot coerce Fixnum to " + clazz.getCanonicalName());
        }
        return typeCoercer.coerce(rubyFixnum);
    }

    static {
        TypeCoercer typeCoercer = new TypeCoercer(){

            public Object coerce(IRubyObject iRubyObject) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                if (rubyFixnum.value > Integer.MAX_VALUE) {
                    throw iRubyObject.getRuntime().newRangeError("Fixnum " + rubyFixnum.value + " is too large for Java int");
                }
                return (int)rubyFixnum.value;
            }
        };
        JAVA_COERCERS.put(Integer.TYPE, typeCoercer);
        JAVA_COERCERS.put(Integer.class, typeCoercer);
    }
}

