/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.util.ArrayList;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyIO;
import org.jruby.nb.nb.RubyKernel;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.FrameField;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.TypeConverter;
import org.jruby.nb.nb.util.io.InvalidValueException;
import org.jruby.nb.nb.util.io.ModeFlags;
import org.jruby.nb.nb.util.io.Stream;
import org.jruby.util.ByteList;

@JRubyClass(name={"StringIO"})
public class RubyStringIO
extends RubyObject {
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyStringIO(ruby, rubyClass);
        }
    };
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private RubyString internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;
    ModeFlags modes;
    public static final ByteList NEWLINE = ByteList.create((CharSequence)"\n");

    public static RubyClass createStringIOClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("StringIO", ruby.fastGetClass("Data"), STRINGIO_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyStringIO.class);
        rubyClass.includeModule(ruby.getEnumerable());
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyStringIO rubyStringIO;
        IRubyObject iRubyObject2 = rubyStringIO = (RubyStringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                iRubyObject2 = block.yield(threadContext, rubyStringIO);
                Object var7_6 = null;
                rubyStringIO.doFinalize();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                rubyStringIO.doFinalize();
                throw throwable;
            }
        }
        return iRubyObject2;
    }

    protected RubyStringIO(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    private void initializeModes(Object object) {
        try {
            this.modes = object == null ? new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), "r+")) : (object instanceof Long ? new ModeFlags((Long)object) : new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), (String)object)));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.setupModes();
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        Object object = null;
        switch (iRubyObjectArray.length) {
            case 0: {
                this.internal = RubyString.newEmptyString(this.getRuntime());
                object = "r+";
                break;
            }
            case 1: {
                this.internal = iRubyObjectArray[0].convertToString();
                object = this.internal.isFrozen() ? "r" : "r+";
                break;
            }
            case 2: {
                this.internal = iRubyObjectArray[0].convertToString();
                object = iRubyObjectArray[1] instanceof RubyFixnum ? Long.valueOf(RubyFixnum.fix2long(iRubyObjectArray[1])) : iRubyObjectArray[1].convertToString().toString();
            }
        }
        this.initializeModes(object);
        if (this.modes.isWritable() && this.internal.isFrozen()) {
            throw this.getRuntime().newErrnoEACCESError("Permission denied");
        }
        if (this.modes.isTruncate()) {
            this.internal.modifyCheck();
            this.internal.empty();
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        RubyStringIO rubyStringIO = (RubyStringIO)TypeConverter.convertToType(iRubyObject, this.getRuntime().fastGetClass("StringIO"), MethodIndex.getIndex("to_strio"), "to_strio");
        if (this == rubyStringIO) {
            return this;
        }
        this.pos = rubyStringIO.pos;
        this.lineno = rubyStringIO.lineno;
        this.eof = rubyStringIO.eof;
        this.closedRead = rubyStringIO.closedRead;
        this.closedWrite = rubyStringIO.closedWrite;
        this.internal = rubyStringIO.internal;
        this.modes = rubyStringIO.modes;
        if (rubyStringIO.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.writeInternal(threadContext, iRubyObject);
        return this;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod(name={"close"}, frame=true)
    public IRubyObject close() {
        this.checkInitialized();
        this.checkOpen();
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    private void doFinalize() {
        this.closedRead = true;
        this.closedWrite = true;
        this.internal = null;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedRead && this.closedWrite);
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() {
        this.checkReadable();
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedRead);
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() {
        this.checkWritable();
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedWrite);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject = this.gets(threadContext, iRubyObjectArray);
        while (!iRubyObject.isNil()) {
            block.yield(threadContext, iRubyObject);
            iRubyObject = this.gets(threadContext, iRubyObjectArray);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext threadContext, Block block) {
        this.checkReadable();
        Ruby ruby = threadContext.getRuntime();
        ByteList byteList = this.internal.getByteList();
        while (this.pos < (long)byteList.length()) {
            block.yield(threadContext, ruby.newFixnum(byteList.get((int)this.pos++) & 0xFF));
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.each(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof() {
        return this.getRuntime().newBoolean(this.isEOF());
    }

    private boolean isEOF() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof;
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        this.checkReadable();
        if (this.pos >= (long)this.internal.getByteList().length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.internal.getByteList().get((int)this.pos++) & 0xFF);
    }

    private IRubyObject internalGets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (this.pos < (long)this.internal.getByteList().realSize && !this.eof) {
            ByteList byteList;
            int n;
            ByteList byteList2;
            boolean bl = false;
            if (iRubyObjectArray.length > 0) {
                if (iRubyObjectArray[0].isNil()) {
                    ByteList byteList3 = this.internal.getByteList().makeShared((int)this.pos, this.internal.getByteList().realSize - (int)this.pos);
                    this.pos += (long)byteList3.realSize;
                    return RubyString.newString(ruby, byteList3);
                }
                byteList2 = iRubyObjectArray[0].convertToString().getByteList();
                if (byteList2.realSize == 0) {
                    bl = true;
                    byteList2 = Stream.PARAGRAPH_SEPARATOR;
                }
            } else {
                byteList2 = ((RubyString)ruby.getGlobalVariables().get("$/")).getByteList();
            }
            ByteList byteList4 = this.internal.getByteList();
            if (bl) {
                this.swallowLF(byteList4);
                if (this.pos == (long)byteList4.realSize) {
                    return ruby.getNil();
                }
            }
            if (-1 == (n = byteList4.indexOf(byteList2, (int)this.pos))) {
                n = this.internal.getByteList().realSize;
                byteList = new ByteList(new byte[0], false);
            } else {
                byteList = bl ? NEWLINE : byteList2;
            }
            ByteList byteList5 = this.internal.getByteList().makeShared((int)this.pos, n - (int)this.pos);
            byteList5.unshare();
            byteList5.append(byteList);
            byteList5.invalidate();
            this.pos = n + byteList.realSize;
            ++this.lineno;
            return RubyString.newString(ruby, byteList5);
        }
        return ruby.getNil();
    }

    private void swallowLF(ByteList byteList) {
        while (this.pos < (long)byteList.realSize && byteList.get((int)this.pos) == 10) {
            ++this.pos;
        }
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkReadable();
        IRubyObject iRubyObject = this.internalGets(threadContext, iRubyObjectArray);
        threadContext.getCurrentFrame().setLastLine(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject iRubyObject) {
        this.lineno = RubyNumeric.fix2int(iRubyObject);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.pos = RubyNumeric.fix2int(iRubyObject);
        if (this.pos < 0L) {
            throw this.getRuntime().newErrnoEINVALError("Invalid argument");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length != 0) {
            int n = iRubyObjectArray.length;
            for (int i = 0; i < n; ++i) {
                this.append(threadContext, iRubyObjectArray[i]);
            }
        } else {
            IRubyObject iRubyObject = ruby.getGlobalVariables().get("$_");
            this.append(threadContext, iRubyObject.isNil() ? ruby.newString("nil") : iRubyObject);
        }
        IRubyObject iRubyObject = ruby.getGlobalVariables().get("$\\");
        if (!iRubyObject.isNil()) {
            this.append(threadContext, iRubyObject);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.append(threadContext, RubyKernel.sprintf(threadContext, this, iRubyObjectArray));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject iRubyObject) {
        this.checkWritable();
        byte by = RubyNumeric.num2chr(iRubyObject);
        this.checkFrozen();
        this.internal.modify();
        ByteList byteList = this.internal.getByteList();
        if (this.modes.isAppendable()) {
            this.pos = byteList.length();
            byteList.append(by);
        } else {
            if (this.pos >= (long)byteList.length()) {
                byteList.length((int)this.pos + 1);
            }
            byteList.set((int)this.pos, (int)by);
            ++this.pos;
        }
        return iRubyObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkWritable();
        if (iRubyObjectArray.length == 0) {
            this.callMethod(threadContext, "write", RubyString.newStringShared(this.getRuntime(), NEWLINE));
            return this.getRuntime().getNil();
        }
        int n = 0;
        while (true) {
            block8: {
                String string;
                block5: {
                    block6: {
                        RubyArray rubyArray;
                        block7: {
                            block4: {
                                if (n >= iRubyObjectArray.length) {
                                    return this.getRuntime().getNil();
                                }
                                if (!iRubyObjectArray[n].isNil()) break block4;
                                string = "nil";
                                break block5;
                            }
                            IRubyObject iRubyObject = iRubyObjectArray[n].checkArrayType();
                            if (iRubyObject.isNil()) break block6;
                            rubyArray = (RubyArray)iRubyObject;
                            if (!this.getRuntime().isInspecting(rubyArray)) break block7;
                            string = "[...]";
                            break block5;
                        }
                        this.inspectPuts(threadContext, rubyArray);
                        break block8;
                    }
                    string = iRubyObjectArray[n].toString();
                }
                this.callMethod(threadContext, "write", this.getRuntime().newString(string));
                if (!string.endsWith("\n")) {
                    this.callMethod(threadContext, "write", RubyString.newStringShared(this.getRuntime(), NEWLINE));
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext threadContext, RubyArray rubyArray) {
        try {
            this.getRuntime().registerInspecting(rubyArray);
            IRubyObject iRubyObject = this.puts(threadContext, rubyArray.toJavaArray());
            Object var5_4 = null;
            this.getRuntime().unregisterInspecting(rubyArray);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuntime().unregisterInspecting(rubyArray);
            throw throwable;
        }
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] iRubyObjectArray) {
        this.checkReadable();
        ByteList byteList = null;
        int n = 0;
        int n2 = 0;
        RubyString rubyString = null;
        switch (iRubyObjectArray.length) {
            case 2: {
                rubyString = iRubyObjectArray[1].convertToString();
                rubyString.modify();
                byteList = rubyString.getByteList();
            }
            case 1: {
                if (!iRubyObjectArray[0].isNil()) {
                    n2 = n = RubyNumeric.fix2int(iRubyObjectArray[0]);
                    if (n < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + n + " given");
                    }
                    if (n > 0 && this.pos >= (long)this.internal.getByteList().length()) {
                        this.eof = true;
                        if (byteList != null) {
                            byteList.realSize = 0;
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.eof) break;
                    if (byteList != null) {
                        byteList.realSize = 0;
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                n2 = -1;
                n = this.internal.getByteList().length();
                if ((long)n <= this.pos) {
                    this.eof = true;
                    if (byteList == null) {
                        byteList = new ByteList();
                    } else {
                        byteList.realSize = 0;
                    }
                    return this.getRuntime().newString(byteList);
                }
                n = (int)((long)n - this.pos);
                break;
            }
            default: {
                this.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
        }
        if (byteList == null) {
            int n3 = this.internal.getByteList().length();
            if (n3 > 0) {
                if ((long)n3 >= this.pos + (long)n) {
                    byteList = new ByteList(this.internal.getByteList(), (int)this.pos, n);
                } else {
                    int n4 = (int)((long)this.internal.getByteList().length() - this.pos);
                    if (n > n4) {
                        n = n4;
                    }
                    byteList = new ByteList(this.internal.getByteList(), (int)this.pos, n);
                }
            }
        } else {
            int n5 = (int)((long)this.internal.getByteList().length() - this.pos);
            if (n > n5) {
                n = n5;
            }
            byteList.realSize = n;
            byteList.replace(0, n, this.internal.getByteList().bytes, (int)this.pos, n);
        }
        if (byteList == null) {
            if (!this.eof) {
                byteList = new ByteList();
            }
            n = 0;
        } else {
            n = byteList.length();
            this.pos += (long)n;
        }
        if (n2 < 0 || n2 > n) {
            this.eof = true;
        }
        return rubyString != null ? rubyString : this.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject iRubyObject = this.getc();
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = this.gets(threadContext, iRubyObjectArray);
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        this.checkReadable();
        ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
        while (!this.isEOF() && !(iRubyObject = this.internalGets(threadContext, iRubyObjectArray)).isNil()) {
            arrayList.add(iRubyObject);
        }
        return this.getRuntime().newArray(arrayList);
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1 && !(iRubyObjectArray[0] instanceof RubyString)) {
            return this.initialize_copy(iRubyObjectArray[0]);
        }
        this.doRewind();
        this.closedRead = false;
        this.closedWrite = false;
        return this.initialize(iRubyObjectArray, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.doRewind();
        return RubyFixnum.zero(this.getRuntime());
    }

    private void doRewind() {
        this.pos = 0L;
        this.eof = false;
        this.lineno = 0;
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1, frame=true)
    public IRubyObject seek(IRubyObject[] iRubyObjectArray) {
        this.checkFinalized();
        long l = RubyNumeric.num2long(iRubyObjectArray[0]);
        int n = 0;
        long l2 = this.pos;
        if (iRubyObjectArray.length > 1 && !iRubyObjectArray[0].isNil()) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1]);
        }
        l2 = n == 1 ? (l2 += l) : (n == 2 ? (long)this.internal.getByteList().length() + l : l);
        if (l2 < 0L) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.pos = l2;
        this.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject iRubyObject) {
        return this.reopen(new IRubyObject[]{iRubyObject.convertToString()});
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject iRubyObject) {
        return iRubyObject;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        if (this.internal == null) {
            return this.getRuntime().getNil();
        }
        return this.internal;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, optional=2)
    public IRubyObject sysread(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = this.read(iRubyObjectArray);
        if (this.isEOF() && (iRubyObject.isNil() || ((RubyString)iRubyObject).getByteList().length() == 0)) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject iRubyObject) {
        this.checkWritable();
        int n = RubyFixnum.fix2int(iRubyObject);
        if (n < 0) {
            throw this.getRuntime().newErrnoEINVALError("negative legnth");
        }
        this.internal.modify();
        this.internal.getByteList().length(n);
        return iRubyObject;
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject iRubyObject) {
        this.checkReadable();
        int n = RubyNumeric.num2int(iRubyObject);
        if (this.pos == 0L) {
            return this.getRuntime().getNil();
        }
        this.internal.modify();
        --this.pos;
        ByteList byteList = this.internal.getByteList();
        if ((long)byteList.length() <= this.pos) {
            byteList.length((int)this.pos + 1);
        }
        byteList.set((int)this.pos, n);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"write", "syswrite"}, required=1)
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().newFixnum(this.writeInternal(threadContext, iRubyObject));
    }

    private int writeInternal(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkWritable();
        this.checkFrozen();
        RubyString rubyString = iRubyObject.asString();
        this.internal.modify();
        if (this.modes.isAppendable()) {
            this.internal.getByteList().append(rubyString.getByteList());
            this.pos = this.internal.getByteList().length();
        } else {
            int n = this.internal.getByteList().length() - (int)this.pos;
            this.internal.getByteList().replace((int)this.pos, Math.min(rubyString.getByteList().length(), n), rubyString.getByteList());
            this.pos += (long)rubyString.getByteList().length();
        }
        if (rubyString.isTaint()) {
            this.internal.setTaint(true);
        }
        return rubyString.getByteList().length();
    }

    protected void checkFrozen() {
        this.checkInitialized();
        if (this.internal.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkReadable() {
        this.checkInitialized();
        if (this.closedRead || !this.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (this.closedWrite || !this.modes.isWritable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkInitialized() {
        if (this.modes == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.internal == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closedRead && this.closedWrite) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void setupModes() {
        this.closedWrite = false;
        this.closedRead = false;
        if (this.modes.isReadOnly()) {
            this.closedWrite = true;
        }
        if (!this.modes.isReadable()) {
            this.closedRead = true;
        }
    }
}

