/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyException;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;
    private static ObjectAllocator SYSTEMEXIT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubySystemExit(ruby, rubyClass);
        }
    };

    public static RubyClass createSystemExitClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = ruby.defineClass("SystemExit", rubyClass, SYSTEMEXIT_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(RubySystemExit.class);
        return rubyClass2;
    }

    public static RubySystemExit newInstance(Ruby ruby, int n) {
        RubyClass rubyClass = ruby.getSystemExit();
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newFixnum(n), ruby.newString("exit")};
        return (RubySystemExit)rubyClass.newInstance(ruby.getCurrentContext(), iRubyObjectArray, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.status = ruby.getNil();
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        this.status = RubyFixnum.zero(this.getRuntime());
        if (iRubyObjectArray.length > 0 && iRubyObjectArray[0] instanceof RubyFixnum) {
            this.status = iRubyObjectArray[0];
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length - 1];
            System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray2.length);
            iRubyObjectArray = iRubyObjectArray2;
        }
        super.initialize(iRubyObjectArray, block);
        return this;
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        if (this.status.isNil()) {
            return this.getRuntime().getTrue();
        }
        if (this.status.equals(RubyFixnum.zero(this.getRuntime()))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }
}

