/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.math.BigInteger;
import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BignumNode
extends Node
implements ILiteralNode {
    private BigInteger value;

    public BignumNode(ISourcePosition iSourcePosition, BigInteger bigInteger) {
        super(iSourcePosition, NodeType.BIGNUMNODE);
        this.value = bigInteger;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitBignumNode(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setValue(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyBignum.newBignum(ruby, this.value);
    }
}

