/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.ast.AssignableNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarAsgnNode
extends AssignableNode
implements INameNode {
    private String name;

    public ClassVarAsgnNode(ISourcePosition iSourcePosition, String string, Node node) {
        super(iSourcePosition, NodeType.CLASSVARASGNNODE, node);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitClassVarAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return ClassVarAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        return rubyModule.fastSetClassVar(this.name, this.getValueNode().interpret(ruby, threadContext, iRubyObject, block));
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        ASTInterpreter.getClassVariableBase(threadContext, ruby).fastSetClassVar(this.name, iRubyObject2);
        return ruby.getNil();
    }
}

