/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.AssignableNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.compiler.ASTInspector;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private final int location;

    public LocalAsgnNode(ISourcePosition iSourcePosition, String string, int n, Node node) {
        super(iSourcePosition, NodeType.LOCALASGNNODE, node);
        this.name = string;
        this.location = n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return LocalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (ASTInspector.PRAGMAS.contains(this.name)) {
            return ruby.getNil();
        }
        return threadContext.getCurrentScope().setValue(this.getIndex(), this.getValueNode().interpret(ruby, threadContext, iRubyObject, block), this.getDepth());
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        threadContext.getCurrentScope().setValue(this.getIndex(), iRubyObject2, this.getDepth());
        return ruby.getNil();
    }
}

