/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyException;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.RescueBodyNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition iSourcePosition, Node node, RescueBodyNode rescueBodyNode, Node node2) {
        super(iSourcePosition, NodeType.RESCUENODE);
        this.bodyNode = node;
        this.rescueNode = rescueBodyNode;
        this.elseNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (ruby.getJavaSupport().isActive() && UnsafeFactory.getUnsafe() != null) {
            return this.interpretWithJavaExceptions(ruby, threadContext, iRubyObject, block);
        }
        return this.interpretWithoutJavaExceptions(ruby, threadContext, iRubyObject, block);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject interpretWithoutJavaExceptions(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        while (true) {
            Object var10_13;
            IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$!");
            boolean bl = false;
            try {
                IRubyObject iRubyObject3;
                try {
                    iRubyObject3 = this.executeBody(ruby, threadContext, iRubyObject, block);
                    var10_13 = null;
                    if (bl) return iRubyObject3;
                }
                catch (RaiseException raiseException) {
                    block10: {
                        IRubyObject iRubyObject4;
                        try {
                            iRubyObject4 = this.handleException(ruby, threadContext, iRubyObject, block, raiseException);
                        }
                        catch (JumpException.RetryJump retryJump) {
                            break block10;
                        }
                        catch (RaiseException raiseException2) {
                            bl = true;
                            throw raiseException2;
                        }
                        var10_13 = null;
                        if (bl) return iRubyObject4;
                        ruby.getGlobalVariables().set("$!", iRubyObject2);
                        return iRubyObject4;
                    }
                    var10_13 = null;
                    if (bl) continue;
                    ruby.getGlobalVariables().set("$!", iRubyObject2);
                    continue;
                }
                catch (JumpException.FlowControlException flowControlException) {
                    throw flowControlException;
                }
                ruby.getGlobalVariables().set("$!", iRubyObject2);
                return iRubyObject3;
            }
            catch (Throwable throwable) {
                var10_13 = null;
                if (!bl) {
                    ruby.getGlobalVariables().set("$!", iRubyObject2);
                }
                throw throwable;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject interpretWithJavaExceptions(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        while (true) {
            Object var10_16;
            IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$!");
            boolean bl = false;
            try {
                IRubyObject iRubyObject3;
                IRubyObject iRubyObject4;
                try {
                    iRubyObject4 = this.executeBody(ruby, threadContext, iRubyObject, block);
                    var10_16 = null;
                    if (bl) return iRubyObject4;
                }
                catch (RaiseException raiseException) {
                    block14: {
                        try {
                            iRubyObject3 = this.handleException(ruby, threadContext, iRubyObject, block, raiseException);
                        }
                        catch (JumpException.RetryJump retryJump) {
                            break block14;
                        }
                        catch (RaiseException raiseException2) {
                            bl = true;
                            throw raiseException2;
                        }
                        var10_16 = null;
                        if (bl) return iRubyObject3;
                        ruby.getGlobalVariables().set("$!", iRubyObject2);
                        return iRubyObject3;
                    }
                    var10_16 = null;
                    if (bl) continue;
                    ruby.getGlobalVariables().set("$!", iRubyObject2);
                    continue;
                }
                catch (JumpException.FlowControlException flowControlException) {
                    throw flowControlException;
                }
                catch (Exception exception) {
                    block15: {
                        try {
                            iRubyObject3 = this.handleJavaException(ruby, threadContext, iRubyObject, block, exception);
                        }
                        catch (JumpException.RetryJump retryJump) {
                            break block15;
                        }
                        catch (RaiseException raiseException) {
                            bl = true;
                            throw raiseException;
                        }
                        var10_16 = null;
                        if (bl) return iRubyObject3;
                        ruby.getGlobalVariables().set("$!", iRubyObject2);
                        return iRubyObject3;
                    }
                    var10_16 = null;
                    if (bl) continue;
                    ruby.getGlobalVariables().set("$!", iRubyObject2);
                    continue;
                }
                ruby.getGlobalVariables().set("$!", iRubyObject2);
                return iRubyObject4;
            }
            catch (Throwable throwable) {
                var10_16 = null;
                if (!bl) {
                    ruby.getGlobalVariables().set("$!", iRubyObject2);
                }
                throw throwable;
            }
        }
    }

    private IRubyObject handleException(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block, RaiseException raiseException) {
        RubyException rubyException = raiseException.getException();
        ruby.getGlobalVariables().set("$!", rubyException);
        for (RescueBodyNode rescueBodyNode = this.rescueNode; rescueBodyNode != null; rescueBodyNode = rescueBodyNode.getOptRescueNode()) {
            IRubyObject[] iRubyObjectArray = this.getExceptions(rescueBodyNode, ruby, threadContext, iRubyObject, block);
            if (!RuntimeHelpers.isExceptionHandled(rubyException, iRubyObjectArray, ruby, threadContext, iRubyObject).isTrue()) continue;
            return rescueBodyNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        throw raiseException;
    }

    private IRubyObject handleJavaException(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block, Exception exception) {
        for (RescueBodyNode rescueBodyNode = this.rescueNode; rescueBodyNode != null; rescueBodyNode = rescueBodyNode.getOptRescueNode()) {
            IRubyObject[] iRubyObjectArray = this.getExceptions(rescueBodyNode, ruby, threadContext, iRubyObject, block);
            if (!RuntimeHelpers.isJavaExceptionHandled(exception, iRubyObjectArray, ruby, threadContext, iRubyObject).isTrue()) continue;
            ruby.getGlobalVariables().set("$!", JavaUtil.convertJavaToUsableRubyObject(ruby, exception));
            return rescueBodyNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        UnsafeFactory.getUnsafe().throwException(exception);
        throw new RuntimeException("Unsafe.throwException failed");
    }

    private IRubyObject executeBody(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.bodyNode == null) {
            return ruby.getNil();
        }
        IRubyObject iRubyObject2 = this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
        if (this.elseNode != null) {
            if (this.rescueNode == null) {
                ruby.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless", new Object[0]);
            }
            iRubyObject2 = this.elseNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        return iRubyObject2;
    }

    private IRubyObject[] getExceptions(RescueBodyNode rescueBodyNode, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Node node = rescueBodyNode.getExceptionNodes();
        IRubyObject[] iRubyObjectArray = node == null ? new IRubyObject[]{ruby.getStandardError()} : ASTInterpreter.setupArgs(ruby, threadContext, node, iRubyObject, block);
        return iRubyObjectArray;
    }
}

