/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnNode
extends Node {
    private final Node valueNode;
    private Object target;

    public ReturnNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.RETURNNODE);
        assert (node != null) : "valueNode is not null";
        this.valueNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitReturnNode(this);
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    @Override
    public List<Node> childNodes() {
        return ReturnNode.createList(this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        throw threadContext.returnJump(this.valueNode.interpret(ruby, threadContext, iRubyObject, block));
    }
}

