/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrNode
extends Node
implements ILiteralNode {
    private final ByteList value;

    public StrNode(ISourcePosition iSourcePosition, ByteList byteList) {
        super(iSourcePosition, NodeType.STRNODE);
        this.value = byteList;
    }

    public StrNode(ISourcePosition iSourcePosition, StrNode strNode, StrNode strNode2) {
        super(iSourcePosition, NodeType.STRNODE);
        this.value = strNode.getValue();
        this.value.append(strNode2.getValue());
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitStrNode(this);
    }

    public ByteList getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyString.newStringShared(ruby, this.value);
    }
}

