/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.demo.TextAreaReadline;
import org.jruby.nb.nb.internal.runtime.ValueAccessor;

public class IRBConsole
extends JFrame {
    private static final long serialVersionUID = 3746242973444417387L;

    public IRBConsole(String string) {
        super(string);
    }

    public static void main(final String[] stringArray) {
        final IRBConsole iRBConsole = new IRBConsole("JRuby IRB Console");
        iRBConsole.getContentPane().setLayout(new BorderLayout());
        iRBConsole.setSize(700, 600);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setMargin(new Insets(8, 8, 8, 8));
        jTextPane.setCaretColor(new Color(164, 0, 0));
        jTextPane.setBackground(new Color(242, 242, 242));
        jTextPane.setForeground(new Color(164, 0, 0));
        Font font = iRBConsole.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
        jTextPane.setFont(font);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jTextPane);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        iRBConsole.getContentPane().add(jScrollPane);
        iRBConsole.validate();
        final TextAreaReadline textAreaReadline = new TextAreaReadline(jTextPane, " Welcome to the JRuby IRB Console \n\n");
        iRBConsole.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                textAreaReadline.shutdown();
            }
        });
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig(){
            {
                this.setInput(textAreaReadline.getInputStream());
                this.setOutput(new PrintStream(textAreaReadline.getOutputStream()));
                this.setError(new PrintStream(textAreaReadline.getOutputStream()));
                this.setObjectSpaceEnabled(true);
                this.setArgv(stringArray);
            }
        };
        final Ruby ruby = Ruby.newInstance(rubyInstanceConfig);
        ruby.getGlobalVariables().defineReadonly("$$", new ValueAccessor(ruby.newFixnum(System.identityHashCode(ruby))));
        ruby.getLoadService().init(new ArrayList());
        textAreaReadline.hookIntoRuntime(ruby);
        Thread thread = new Thread(){

            public void run() {
                iRBConsole.setVisible(true);
                ruby.evalScriptlet("require 'irb'; require 'irb/completion'; IRB.start");
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private Font findFont(String string, int n, int n2, String[] stringArray) {
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(objectArray);
        Font font = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Arrays.binarySearch(objectArray, stringArray[i]) < 0) continue;
            font = new Font(stringArray[i], n, n2);
            break;
        }
        if (font == null) {
            font = new Font(string, n, n2);
        }
        return font;
    }
}

