/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.ext.ffi.AbstractBuffer;
import org.jruby.nb.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.ext.ffi.Invoker;
import org.jruby.nb.nb.ext.ffi.NativeType;
import org.jruby.nb.nb.ext.ffi.Platform;
import org.jruby.nb.nb.ext.ffi.StructLayout;
import org.jruby.nb.nb.ext.ffi.StructLayoutBuilder;
import org.jruby.nb.nb.ext.ffi.io.FileDescriptorIO;
import org.jruby.nb.nb.runtime.load.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby ruby, RubyModule rubyModule) {
        RubyModule rubyModule2 = rubyModule;
        synchronized (rubyModule2) {
            if (rubyModule.fastGetClass("Provider") == null) {
                FFIProvider.createProviderClass(ruby);
            }
            if (rubyModule.fastGetClass("Invoker") == null) {
                Invoker.createInvokerClass(ruby);
            }
            if (rubyModule.fastGetClass("AbstractMemory") == null) {
                AbstractMemory.createAbstractMemoryClass(ruby);
            }
            if (rubyModule.fastGetClass("AbstractMemoryPointer") == null) {
                AbstractMemoryPointer.createMemoryPointerClass(ruby);
            }
            if (rubyModule.fastGetClass("AbstractBuffer") == null) {
                AbstractBuffer.createBufferClass(ruby);
            }
            if (rubyModule.fastGetClass("StructLayout") == null) {
                StructLayout.createStructLayoutClass(ruby);
            }
            if (rubyModule.fastGetClass("StructLayoutBuilder") == null) {
                StructLayoutBuilder.createStructLayoutBuilderClass(ruby);
            }
            if (rubyModule.fastGetClass("FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(ruby);
            }
            FFIProvider fFIProvider = this.newProvider(ruby);
            rubyModule.defineConstant("InvokerFactory", fFIProvider);
            rubyModule.defineConstant("LastError", fFIProvider);
            RubyModule rubyModule3 = rubyModule.defineModuleUnder("NativeType");
            for (NativeType nativeType : NativeType.values()) {
                rubyModule3.defineConstant(nativeType.name(), ruby.newFixnum(nativeType.ordinal()));
            }
            Platform.getPlatform().init(ruby, rubyModule);
        }
    }

    protected abstract FFIProvider newProvider(Ruby var1);

    public abstract <T> T loadLibrary(String var1, Class<T> var2);

    public abstract Platform getPlatform();

    public abstract ByteChannel newByteChannel(int var1);

    public static class Service
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            RubyModule rubyModule = ruby.defineModuleUnder("FFI", ruby.defineModule("JRuby"));
            Factory factory = Factory.getInstance();
            factory.init(ruby, rubyModule);
        }
    }

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            boolean bl = Boolean.getBoolean("ffi.usejna");
            String string = FFIProvider.class.getPackage().getName();
            Factory factory = null;
            if (!bl) {
                try {
                    factory = (Factory)Class.forName(string + ".jffi.JFFIFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (factory == null) {
                try {
                    factory = (Factory)Class.forName(string + ".jna.JNAFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Could not load FFI provider", throwable);
                }
            }
            return factory;
        }
    }
}

