/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.nb.nb.ext.ffi.MemoryIO;
import org.jruby.nb.nb.ext.ffi.Platform;
import org.jruby.util.ByteList;

public abstract class JNAMemoryIO
implements MemoryIO {
    final Object memory;
    static final JNAMemoryIO NULL = new PointerIO(Pointer.NULL, 0L);

    static final JNAMemoryIO allocate(int n) {
        return new BufferIO(n);
    }

    static final JNAMemoryIO allocateDirect(int n) {
        return new PointerIO(n);
    }

    JNAMemoryIO(Object object) {
        this.memory = object;
    }

    Object getMemory() {
        return this.memory;
    }

    static final JNAMemoryIO wrap(Pointer pointer) {
        return pointer != null ? new PointerIO(pointer, 0L) : NULL;
    }

    static JNAMemoryIO wrap(ByteList byteList) {
        return new BufferIO(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length()));
    }

    public abstract Pointer getAddress();

    public abstract Pointer getPointer(long var1);

    public abstract void putPointer(long var1, Pointer var3);

    public abstract JNAMemoryIO slice(long var1);

    public boolean equals(Object object) {
        return object instanceof JNAMemoryIO && ((JNAMemoryIO)object).memory.equals(this.memory);
    }

    public int hashCode() {
        return this.memory.hashCode();
    }

    public JNAMemoryIO getMemoryIO(long l) {
        return JNAMemoryIO.wrap(this.getPointer(l));
    }

    public void putMemoryIO(long l, MemoryIO memoryIO) {
        this.putPointer(l, ((JNAMemoryIO)memoryIO).getAddress());
    }

    private static class BufferIO
    extends JNAMemoryIO {
        final ByteBuffer buffer;

        BufferIO(int n) {
            this(ByteBuffer.allocate(n).order(ByteOrder.nativeOrder()));
        }

        BufferIO(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.buffer = byteBuffer;
            throw new RuntimeException("Not implemented");
        }

        public Pointer getAddress() {
            return Pointer.NULL;
        }

        public boolean isNull() {
            return false;
        }

        static ByteBuffer slice(ByteBuffer byteBuffer, int n, int n2) {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byteBuffer2.position(n).limit(n + n2);
            return byteBuffer2.slice();
        }

        public Pointer getPointer(long l) {
            if (Platform.getPlatform().longSize() == 32) {
                IntByReference intByReference = new IntByReference(this.getInt(l));
                return intByReference.getPointer().getPointer(0L);
            }
            LongByReference longByReference = new LongByReference(this.getLong(l));
            return longByReference.getPointer().getPointer(0L);
        }

        public void putPointer(long l, Pointer pointer) {
            PointerByReference pointerByReference = new PointerByReference(pointer);
            if (Platform.getPlatform().longSize() == 32) {
                this.putInt(l, pointerByReference.getPointer().getInt(0L));
            } else {
                this.putLong(l, pointerByReference.getPointer().getLong(0L));
            }
        }

        public byte getByte(long l) {
            return this.buffer.get((int)l);
        }

        public short getShort(long l) {
            return this.buffer.getShort((int)l);
        }

        public int getInt(long l) {
            return this.buffer.getInt((int)l);
        }

        public long getLong(long l) {
            return this.buffer.getLong((int)l);
        }

        public long getNativeLong(long l) {
            return NativeLong.SIZE == 4 ? (long)this.buffer.getInt((int)l) : this.buffer.getLong((int)l);
        }

        public float getFloat(long l) {
            return this.buffer.getFloat((int)l);
        }

        public double getDouble(long l) {
            return this.buffer.getDouble((int)l);
        }

        public void putByte(long l, byte by) {
            this.buffer.put((int)l, by);
        }

        public void putShort(long l, short s) {
            this.buffer.putShort((int)l, s);
        }

        public void putInt(long l, int n) {
            this.buffer.putInt((int)l, n);
        }

        public void putLong(long l, long l2) {
            this.buffer.putLong((int)l, l2);
        }

        public void putNativeLong(long l, long l2) {
            if (NativeLong.SIZE == 4) {
                this.putInt(l, (int)l2);
            } else {
                this.putLong(l, l2);
            }
        }

        public void putFloat(long l, float f) {
            this.buffer.putFloat((int)l, f);
        }

        public void putDouble(long l, double d) {
            this.buffer.putDouble((int)l, d);
        }

        public void get(long l, byte[] byArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2).get(byArray, n, n2);
        }

        public void put(long l, byte[] byArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2).put(byArray, n, n2);
        }

        public void get(long l, short[] sArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 2).asShortBuffer().get(sArray, n, n2);
        }

        public void put(long l, short[] sArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 2).asShortBuffer().put(sArray, n, n2);
        }

        public void get(long l, int[] nArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 4).asIntBuffer().get(nArray, n, n2);
        }

        public void put(long l, int[] nArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 4).asIntBuffer().put(nArray, n, n2);
        }

        public void get(long l, long[] lArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 8).asLongBuffer().get(lArray, n, n2);
        }

        public void put(long l, long[] lArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 8).asLongBuffer().put(lArray, n, n2);
        }

        public void get(long l, float[] fArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 4).asFloatBuffer().get(fArray, n, n2);
        }

        public void put(long l, float[] fArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 4).asFloatBuffer().put(fArray, n, n2);
        }

        public void get(long l, double[] dArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 8).asDoubleBuffer().get(dArray, n, n2);
        }

        public void put(long l, double[] dArray, int n, int n2) {
            BufferIO.slice(this.buffer, (int)l, n2 * 8).asDoubleBuffer().put(dArray, n, n2);
        }

        public int indexOf(long l, byte by) {
            return this.indexOf(l, by, Integer.MAX_VALUE);
        }

        public int indexOf(long l, byte by, int n) {
            while (l > -1L) {
                if (this.buffer.get((int)l) == by) {
                    return (int)l;
                }
                ++l;
            }
            return -1;
        }

        public void setMemory(long l, long l2, byte by) {
            int n = 0;
            while ((long)n < l2) {
                this.buffer.put(n, by);
                ++n;
            }
        }

        public void clear() {
            this.setMemory(0L, this.buffer.capacity(), (byte)0);
        }

        public JNAMemoryIO slice(long l) {
            return l == 0L ? this : new BufferIO(BufferIO.slice(this.buffer, (int)l, this.buffer.capacity() - (int)l));
        }
    }

    static final class PointerIO
    extends JNAMemoryIO {
        final Pointer ptr;
        final long size;

        private PointerIO() {
            this(Pointer.NULL, 0L);
        }

        private PointerIO(long l) {
            this((Pointer)new Memory(l), l);
        }

        private PointerIO(Pointer pointer, long l) {
            super(pointer);
            this.ptr = pointer;
            this.size = l;
        }

        public Pointer getAddress() {
            return this.ptr;
        }

        public boolean isNull() {
            return this.ptr == null;
        }

        public byte getByte(long l) {
            return this.ptr.getByte(l);
        }

        public short getShort(long l) {
            return this.ptr.getShort(l);
        }

        public int getInt(long l) {
            return this.ptr.getInt(l);
        }

        public long getLong(long l) {
            return this.ptr.getLong(l);
        }

        public long getNativeLong(long l) {
            return this.ptr.getNativeLong(l).longValue();
        }

        public float getFloat(long l) {
            return this.ptr.getFloat(l);
        }

        public double getDouble(long l) {
            return this.ptr.getDouble(l);
        }

        public Pointer getPointer(long l) {
            return this.ptr.getPointer(l);
        }

        public void putByte(long l, byte by) {
            this.ptr.setByte(l, by);
        }

        public void putShort(long l, short s) {
            this.ptr.setShort(l, s);
        }

        public void putInt(long l, int n) {
            this.ptr.setInt(l, n);
        }

        public void putLong(long l, long l2) {
            this.ptr.setLong(l, l2);
        }

        public void putNativeLong(long l, long l2) {
            this.ptr.setNativeLong(l, new NativeLong(l2));
        }

        public void putFloat(long l, float f) {
            this.ptr.setFloat(l, f);
        }

        public void putDouble(long l, double d) {
            this.ptr.setDouble(l, d);
        }

        public void putPointer(long l, Pointer pointer) {
            this.ptr.setPointer(l, pointer);
        }

        public void get(long l, byte[] byArray, int n, int n2) {
            this.ptr.read(l, byArray, n, n2);
        }

        public void put(long l, byte[] byArray, int n, int n2) {
            this.ptr.write(l, byArray, n, n2);
        }

        public void get(long l, short[] sArray, int n, int n2) {
            this.ptr.read(l, sArray, n, n2);
        }

        public void put(long l, short[] sArray, int n, int n2) {
            this.ptr.write(l, sArray, n, n2);
        }

        public void get(long l, int[] nArray, int n, int n2) {
            this.ptr.read(l, nArray, n, n2);
        }

        public void put(long l, int[] nArray, int n, int n2) {
            this.ptr.write(l, nArray, n, n2);
        }

        public void get(long l, long[] lArray, int n, int n2) {
            this.ptr.read(l, lArray, n, n2);
        }

        public void put(long l, long[] lArray, int n, int n2) {
            this.ptr.write(l, lArray, n, n2);
        }

        public void get(long l, float[] fArray, int n, int n2) {
            this.ptr.read(l, fArray, n, n2);
        }

        public void put(long l, float[] fArray, int n, int n2) {
            this.ptr.write(l, fArray, n, n2);
        }

        public void get(long l, double[] dArray, int n, int n2) {
            this.ptr.read(l, dArray, n, n2);
        }

        public void put(long l, double[] dArray, int n, int n2) {
            this.ptr.write(l, dArray, n, n2);
        }

        public int indexOf(long l, byte by) {
            return (int)this.ptr.indexOf(l, by);
        }

        public int indexOf(long l, byte by, int n) {
            return (int)this.ptr.indexOf(l, by);
        }

        public void setMemory(long l, long l2, byte by) {
            this.ptr.setMemory(l, l2, by);
        }

        public void clear() {
            this.setMemory(0L, this.size, (byte)0);
        }

        public JNAMemoryIO slice(long l) {
            return l == 0L ? this : new PointerIO(this.ptr.share(l), this.size - l);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PointerIO pointerIO = (PointerIO)object;
            return this.ptr == pointerIO.ptr || this.ptr != null && this.ptr.equals((Object)pointerIO.ptr);
        }

        public int hashCode() {
            return this.ptr == null ? 0 : this.ptr.hashCode();
        }
    }
}

