/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.lexer.yacc;

import java.io.IOException;
import org.jruby.nb.nb.ast.StrNode;
import org.jruby.nb.nb.lexer.yacc.LexerSource;
import org.jruby.nb.nb.lexer.yacc.RubyYaccLexer;
import org.jruby.nb.nb.lexer.yacc.StrTerm;
import org.jruby.nb.nb.lexer.yacc.StringTerm;
import org.jruby.nb.nb.lexer.yacc.SyntaxException;
import org.jruby.nb.nb.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList marker;
    private final int flags;
    private final ByteList lastLine;

    public HeredocTerm(ByteList byteList, int n, ByteList byteList2) {
        this.marker = byteList;
        this.flags = n;
        this.lastLine = byteList2;
    }

    public int parseString(RubyYaccLexer rubyYaccLexer, LexerSource lexerSource) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = (this.flags & 0x20) != 0;
        if (lexerSource.peek(-1)) {
            this.syntaxError(lexerSource);
        }
        if (rubyYaccLexer.getPreserveSpaces() && (bl = lexerSource.matchMarker(this.marker, bl2, true))) {
            rubyYaccLexer.yaccValue = new StrNode(rubyYaccLexer.getPosition(), new ByteList());
            rubyYaccLexer.setStrTerm(new StringTerm(-1, 0, 0));
            lexerSource.setIsANewLine(true);
            return 374;
        }
        if (lexerSource.lastWasBeginOfLine() && lexerSource.matchMarker(this.marker, bl2, true)) {
            if (this.lastLine != null) {
                lexerSource.unreadMany((CharSequence)this.lastLine);
            }
            rubyYaccLexer.yaccValue = new Token(this.marker, rubyYaccLexer.getPosition());
            return 374;
        }
        ByteList byteList = new ByteList();
        if ((this.flags & 2) == 0) {
            do {
                byteList.append(lexerSource.readLineBytes());
                byteList.append(10);
                if (!lexerSource.peek(-1)) continue;
                this.syntaxError(lexerSource);
            } while (!lexerSource.matchMarker(this.marker, bl2, true));
        } else {
            int n = lexerSource.read();
            if (n == 35) {
                n = lexerSource.read();
                switch (n) {
                    case 36: 
                    case 64: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 3;
                        }
                        lexerSource.unread(n);
                        rubyYaccLexer.setValue(new Token("#" + n, rubyYaccLexer.getPosition()));
                        return 373;
                    }
                    case 123: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 2;
                        }
                        rubyYaccLexer.setValue(new Token("#" + n, rubyYaccLexer.getPosition()));
                        return 372;
                    }
                }
                byteList.append(35);
            }
            lexerSource.unread(n);
            do {
                StringTerm stringTerm = new StringTerm(this.flags, 0, 10);
                stringTerm.processingEmbedded = this.processingEmbedded;
                n = stringTerm.parseStringIntoBuffer(rubyYaccLexer, lexerSource, byteList);
                if (n == -1) {
                    this.syntaxError(lexerSource);
                }
                if (this.processingEmbedded == 3 || this.processingEmbedded == 2) {
                    this.processingEmbedded = 1;
                }
                if (n != 10) {
                    rubyYaccLexer.yaccValue = new StrNode(rubyYaccLexer.getPosition(), byteList);
                    return 312;
                }
                byteList.append(lexerSource.read());
                if (!lexerSource.peek(-1)) continue;
                this.syntaxError(lexerSource);
            } while (!lexerSource.matchMarker(this.marker, bl2, true));
        }
        if (this.processingEmbedded == 3) {
            this.processingEmbedded = 1;
        }
        if (this.lastLine != null) {
            lexerSource.unreadMany((CharSequence)this.lastLine);
        }
        if (this.lastLine == null) {
            lexerSource.unreadMany(this.marker + "\n");
        } else {
            rubyYaccLexer.setStrTerm(new StringTerm(-1, 0, 0));
        }
        rubyYaccLexer.yaccValue = new StrNode(rubyYaccLexer.getPosition(), byteList);
        return 312;
    }

    private void syntaxError(LexerSource lexerSource) {
        throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, lexerSource.getPosition(), "can't find string \"" + this.marker + "\" anywhere before EOF", this.marker);
    }

    public boolean isSubstituting() {
        return (this.flags & 2) != 0;
    }

    public Object getMutableState() {
        return new MutableTermState(this.processingEmbedded);
    }

    public void setMutableState(Object object) {
        MutableTermState mutableTermState = (MutableTermState)object;
        if (mutableTermState != null) {
            this.processingEmbedded = mutableTermState.processingEmbedded;
        }
    }

    public void splitEmbeddedTokens() {
        if (this.processingEmbedded == 0) {
            this.processingEmbedded = 1;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HeredocTerm heredocTerm = (HeredocTerm)object;
        if (!(this.marker == heredocTerm.marker || this.marker != null && this.marker.equals((Object)heredocTerm.marker))) {
            return false;
        }
        if (this.flags != heredocTerm.flags) {
            return false;
        }
        return this.lastLine == heredocTerm.lastLine || this.lastLine != null && this.lastLine.equals((Object)heredocTerm.lastLine);
    }

    public int hashCode() {
        int n = 7;
        n = 83 * n + (this.marker != null ? this.marker.hashCode() : 0);
        n = 83 * n + this.flags;
        n = 83 * n + (this.lastLine != null ? this.lastLine.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "HeredocTerm[" + this.flags + "," + this.marker + "," + this.lastLine + "," + this.processingEmbedded + "]";
    }

    private class MutableTermState {
        private int processingEmbedded;

        private MutableTermState(int n) {
            this.processingEmbedded = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MutableTermState mutableTermState = (MutableTermState)object;
            return this.processingEmbedded == mutableTermState.processingEmbedded;
        }

        public int hashCode() {
            int n = 7;
            n = 83 * n + this.processingEmbedded;
            return n;
        }

        public String toString() {
            return "HeredocTermState[" + this.processingEmbedded + "]";
        }
    }
}

