/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.runtime.Binding;
import org.jruby.nb.nb.nb.runtime.Frame;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyBinding rubyBinding = new RubyBinding(ruby, rubyClass);
            return rubyBinding;
        }
    };

    public RubyBinding(Ruby ruby, RubyClass rubyClass, Binding binding) {
        super(ruby, rubyClass);
        this.binding = binding;
    }

    private RubyBinding(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createBindingClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Binding", ruby.getObject(), BINDING_ALLOCATOR);
        ruby.setBinding(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyBinding.class);
        return rubyClass;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby ruby, Binding binding) {
        return new RubyBinding(ruby, ruby.getBinding(), binding);
    }

    public static RubyBinding newBinding(Ruby ruby) {
        ThreadContext threadContext = ruby.getCurrentContext();
        Frame frame = threadContext.getCurrentFrame();
        Binding binding = new Binding(frame, threadContext.getBindingRubyClass(), threadContext.getCurrentScope());
        return new RubyBinding(ruby, ruby.getBinding(), binding);
    }

    public static RubyBinding newBindingForEval(ThreadContext threadContext) {
        Frame frame = threadContext.getPreviousFrame();
        Frame frame2 = threadContext.getCurrentFrame();
        frame2.setKlazz(frame.getKlazz());
        Binding binding = new Binding(frame, threadContext.getBindingRubyClass(), threadContext.getCurrentScope());
        Ruby ruby = threadContext.getRuntime();
        return new RubyBinding(ruby, ruby.getBinding(), binding);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext) {
        Frame frame = threadContext.getCurrentFrame();
        this.binding = new Binding(frame, threadContext.getBindingRubyClass(), threadContext.getCurrentScope());
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        RubyBinding rubyBinding = (RubyBinding)iRubyObject;
        this.binding = rubyBinding.binding;
        return this;
    }
}

