/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyComplex;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyMatchData;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyRegexp;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Frame;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Rational"}, parent="Numeric", include={"Precision"})
public class RubyRational
extends RubyNumeric {
    private static ObjectAllocator RATIONAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyRational(ruby, rubyClass, RubyFixnum.zero(ruby), RubyFixnum.one(ruby));
        }
    };
    private IRubyObject num;
    private IRubyObject den;
    private static long ML = (long)(Math.log(Double.MAX_VALUE) / Math.log(2.0) - 1.0);

    public static RubyClass createRationalClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Rational", ruby.getNumeric(), RATIONAL_ALLOCATOR);
        ruby.setRational(rubyClass);
        rubyClass.index = 21;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyRational;
            }
        };
        ThreadContext threadContext = ruby.getCurrentContext();
        rubyClass.callMethod(threadContext, "private_class_method", ruby.newSymbol("allocate"));
        rubyClass.defineAnnotatedMethods(RubyRational.class);
        return rubyClass;
    }

    private RubyRational(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        super(ruby, (RubyClass)iRubyObject);
        this.num = iRubyObject2;
        this.den = iRubyObject3;
    }

    static RubyRational newRationalRaw(Ruby ruby, IRubyObject iRubyObject, RubyObject rubyObject) {
        return new RubyRational(ruby, ruby.getRational(), iRubyObject, rubyObject);
    }

    static RubyRational newRationalRaw(Ruby ruby, IRubyObject iRubyObject) {
        return new RubyRational(ruby, ruby.getRational(), iRubyObject, RubyFixnum.one(ruby));
    }

    static IRubyObject newRationalCanonicalize(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyRational.newRationalCanonicalize(threadContext, iRubyObject, RubyFixnum.one(threadContext.getRuntime()));
    }

    private static IRubyObject newRationalCanonicalize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyRational.canonicalizeInternal(threadContext, threadContext.getRuntime().getRational(), iRubyObject, iRubyObject2);
    }

    private static IRubyObject newRational(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (iRubyObject2 instanceof RubyRational && iRubyObject3 instanceof RubyRational);
        return RubyRational.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject newRational(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        assert (iRubyObject2 instanceof RubyRational);
        return RubyRational.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, RubyFixnum.one(threadContext.getRuntime()));
    }

    private static IRubyObject newRationalNoReduce(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (iRubyObject2 instanceof RubyRational && iRubyObject3 instanceof RubyRational);
        return RubyRational.canonicalizeInternalNoReduce(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject newRationalNoReduce(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        assert (iRubyObject2 instanceof RubyRational);
        return RubyRational.canonicalizeInternalNoReduce(threadContext, iRubyObject, iRubyObject2, RubyFixnum.one(threadContext.getRuntime()));
    }

    private static RubyRational newRationalBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (!Numeric.f_negative_p(threadContext, iRubyObject3) && !Numeric.f_zero_p(threadContext, iRubyObject3));
        return new RubyRational(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static RubyRational newRationalBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyRational.newRationalBang(threadContext, iRubyObject, iRubyObject2, RubyFixnum.one(threadContext.getRuntime()));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return RubyRational.newInstanceBang(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyRational.newInstanceBang(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyRational.newInstanceBang(threadContext, iRubyObject, iRubyObject2, RubyFixnum.one(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby;
        IRubyObject iRubyObject4;
        if (!(iRubyObject2 instanceof RubyInteger)) {
            iRubyObject2 = Numeric.f_to_i(threadContext, iRubyObject2);
        }
        if (!(iRubyObject3 instanceof RubyInteger)) {
            iRubyObject3 = Numeric.f_to_i(threadContext, iRubyObject3);
        }
        if ((iRubyObject4 = Numeric.f_cmp(threadContext, iRubyObject3, RubyFixnum.zero(ruby = threadContext.getRuntime()))) == RubyFixnum.minus_one(ruby)) {
            iRubyObject2 = Numeric.f_negate(threadContext, iRubyObject2);
            iRubyObject3 = Numeric.f_negate(threadContext, iRubyObject3);
        } else if (iRubyObject4 == RubyFixnum.zero(ruby)) {
            throw ruby.newZeroDivisionError();
        }
        return new RubyRational(ruby, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static void intCheck(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum) && !(iRubyObject instanceof RubyBignum)) {
            throw iRubyObject.getRuntime().newArgumentError("not an integer");
        }
    }

    private static IRubyObject canonicalizeInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject4 = Numeric.f_cmp(threadContext, iRubyObject3, RubyFixnum.zero(ruby));
        if (iRubyObject4 == RubyFixnum.minus_one(ruby)) {
            iRubyObject2 = Numeric.f_negate(threadContext, iRubyObject2);
            iRubyObject3 = Numeric.f_negate(threadContext, iRubyObject3);
        } else if (iRubyObject4 == RubyFixnum.zero(ruby)) {
            throw ruby.newZeroDivisionError();
        }
        IRubyObject iRubyObject5 = Numeric.f_gcd(threadContext, iRubyObject2, iRubyObject3);
        iRubyObject2 = Numeric.f_idiv(threadContext, iRubyObject2, iRubyObject5);
        iRubyObject3 = Numeric.f_idiv(threadContext, iRubyObject3, iRubyObject5);
        if (Numeric.f_one_p(threadContext, iRubyObject3) && ((RubyModule)iRubyObject).fastHasConstant("Unify")) {
            return iRubyObject2;
        }
        return new RubyRational(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject canonicalizeInternalNoReduce(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject4 = Numeric.f_cmp(threadContext, iRubyObject3, RubyFixnum.zero(ruby));
        if (iRubyObject4 == RubyFixnum.minus_one(ruby)) {
            iRubyObject2 = Numeric.f_negate(threadContext, iRubyObject2);
            iRubyObject3 = Numeric.f_negate(threadContext, iRubyObject3);
        } else if (iRubyObject4 == RubyFixnum.zero(ruby)) {
            throw ruby.newZeroDivisionError();
        }
        if (Numeric.f_equal_p(threadContext, iRubyObject3, RubyFixnum.one(ruby)) && ((RubyModule)iRubyObject).fastHasConstant("Unify")) {
            return iRubyObject2;
        }
        return new RubyRational(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return RubyRational.newInstance(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyRational.newInstance(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyRational.intCheck(iRubyObject2);
        return RubyRational.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, RubyFixnum.one(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyRational.intCheck(iRubyObject2);
        RubyRational.intCheck(iRubyObject3);
        return RubyRational.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    public static IRubyObject newRationalConvert(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyRational.newRationalConvert(threadContext, iRubyObject, RubyFixnum.one(threadContext.getRuntime()));
    }

    public static IRubyObject newRationalConvert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyRational.convert(threadContext, threadContext.getRuntime().getRational(), iRubyObject, iRubyObject2);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return RubyRational.convert(threadContext, iRubyObject);
            }
            case 1: {
                return RubyRational.convert(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyRational.convert(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = threadContext.getRuntime().getNil();
        return RubyRational.convertCommon(threadContext, iRubyObject, iRubyObject2, iRubyObject2);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyRational.convertCommon(threadContext, iRubyObject, iRubyObject2, threadContext.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RubyRational.convertCommon(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject convertCommon(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4;
        Object object;
        if (iRubyObject2 instanceof RubyComplex) {
            object = (RubyComplex)iRubyObject2;
            if (((RubyComplex)object).getImage() instanceof RubyFloat || !Numeric.f_zero_p(threadContext, ((RubyComplex)object).getImage())) {
                IRubyObject iRubyObject5 = Numeric.f_to_s(threadContext, iRubyObject2);
                throw threadContext.getRuntime().newArgumentError("can't accept " + iRubyObject5.convertToString());
            }
            iRubyObject2 = ((RubyComplex)object).getReal();
        }
        if (iRubyObject3 instanceof RubyComplex) {
            object = (RubyComplex)iRubyObject3;
            if (((RubyComplex)object).getImage() instanceof RubyFloat || !Numeric.f_zero_p(threadContext, ((RubyComplex)object).getImage())) {
                IRubyObject iRubyObject6 = Numeric.f_to_s(threadContext, iRubyObject3);
                throw threadContext.getRuntime().newArgumentError("can't accept " + iRubyObject6.convertToString());
            }
            iRubyObject3 = ((RubyComplex)object).getReal();
        }
        if ((iRubyObject4 = ((Frame)(object = threadContext.getCurrentFrame())).getBackRef()) != null && iRubyObject4 instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject4).use();
        }
        if (iRubyObject2 instanceof RubyFloat) {
            iRubyObject2 = Numeric.f_to_r(threadContext, iRubyObject2);
        } else if (iRubyObject2 instanceof RubyString) {
            iRubyObject2 = RubyRational.str_to_r_strict(threadContext, iRubyObject2);
        }
        if (iRubyObject3 instanceof RubyFloat) {
            iRubyObject3 = Numeric.f_to_r(threadContext, iRubyObject3);
        } else if (iRubyObject3 instanceof RubyString) {
            iRubyObject3 = RubyRational.str_to_r_strict(threadContext, iRubyObject3);
        }
        ((Frame)object).setBackRef(iRubyObject4);
        if (iRubyObject2 instanceof RubyRational) {
            if (iRubyObject3.isNil() || Numeric.f_zero_p(threadContext, iRubyObject3)) {
                return iRubyObject2;
            }
            return Numeric.f_div(threadContext, iRubyObject2, iRubyObject3);
        }
        if (iRubyObject3 instanceof RubyRational) {
            return Numeric.f_div(threadContext, iRubyObject2, iRubyObject3);
        }
        return iRubyObject3.isNil() ? RubyRational.newInstance(threadContext, iRubyObject, iRubyObject2) : RubyRational.newInstance(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    @JRubyMethod(name={"induced_from"}, meta=true)
    public static IRubyObject induced_from(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Numeric.f_to_r(threadContext, iRubyObject2);
    }

    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext threadContext) {
        return this.num;
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext threadContext) {
        return this.den;
    }

    private static IRubyObject f_imul(ThreadContext threadContext, long l, long l2) {
        Ruby ruby = threadContext.getRuntime();
        if (l == 0L || l2 == 0L) {
            return RubyFixnum.zero(ruby);
        }
        if (l == 1L) {
            return RubyFixnum.newFixnum(ruby, l2);
        }
        if (l2 == 1L) {
            return RubyFixnum.newFixnum(ruby, l);
        }
        long l3 = l * l2;
        if (l3 / l != l2) {
            return RubyBignum.newBignum(ruby, l).op_mul(threadContext, RubyBignum.newBignum(ruby, l2));
        }
        return RubyFixnum.newFixnum(ruby, l3);
    }

    private IRubyObject f_addsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, boolean bl) {
        IRubyObject iRubyObject5;
        IRubyObject iRubyObject6;
        IRubyObject iRubyObject7;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum && iRubyObject3 instanceof RubyFixnum && iRubyObject4 instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).getLongValue();
            long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
            long l3 = ((RubyFixnum)iRubyObject3).getLongValue();
            long l4 = ((RubyFixnum)iRubyObject4).getLongValue();
            long l5 = Numeric.i_gcd(l2, l4);
            iRubyObject7 = RubyFixnum.newFixnum(ruby, l5);
            iRubyObject6 = RubyRational.f_imul(threadContext, l, l4 / l5);
            iRubyObject5 = RubyRational.f_imul(threadContext, l3, l2 / l5);
        } else {
            iRubyObject7 = Numeric.f_gcd(threadContext, iRubyObject2, iRubyObject4);
            iRubyObject6 = Numeric.f_mul(threadContext, iRubyObject, Numeric.f_idiv(threadContext, iRubyObject4, iRubyObject7));
            iRubyObject5 = Numeric.f_mul(threadContext, iRubyObject3, Numeric.f_idiv(threadContext, iRubyObject2, iRubyObject7));
        }
        IRubyObject iRubyObject8 = bl ? Numeric.f_add(threadContext, iRubyObject6, iRubyObject5) : Numeric.f_sub(threadContext, iRubyObject6, iRubyObject5);
        iRubyObject5 = Numeric.f_idiv(threadContext, iRubyObject2, iRubyObject7);
        iRubyObject7 = Numeric.f_gcd(threadContext, iRubyObject8, iRubyObject7);
        IRubyObject iRubyObject9 = Numeric.f_idiv(threadContext, iRubyObject8, iRubyObject7);
        iRubyObject6 = Numeric.f_idiv(threadContext, iRubyObject4, iRubyObject7);
        IRubyObject iRubyObject10 = Numeric.f_mul(threadContext, iRubyObject6, iRubyObject5);
        return RubyRational.newRationalNoReduce(threadContext, this.getMetaClass(), iRubyObject9, iRubyObject10);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_addsub(threadContext, this.num, this.den, iRubyObject, RubyFixnum.one(threadContext.getRuntime()), true);
            }
            case 11: {
                return Numeric.f_add(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
            }
            case 21: {
                RubyRational rubyRational = (RubyRational)iRubyObject;
                return this.f_addsub(threadContext, this.num, this.den, rubyRational.num, rubyRational.den, true);
            }
        }
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_addsub(threadContext, this.num, this.den, iRubyObject, RubyFixnum.one(threadContext.getRuntime()), false);
            }
            case 11: {
                return Numeric.f_sub(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
            }
            case 21: {
                RubyRational rubyRational = (RubyRational)iRubyObject;
                return this.f_addsub(threadContext, this.num, this.den, rubyRational.num, rubyRational.den, false);
            }
        }
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    private IRubyObject f_muldiv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, boolean bl) {
        IRubyObject iRubyObject5;
        IRubyObject iRubyObject6;
        if (!bl) {
            if (Numeric.f_negative_p(threadContext, iRubyObject3)) {
                iRubyObject = Numeric.f_negate(threadContext, iRubyObject);
                iRubyObject3 = Numeric.f_negate(threadContext, iRubyObject3);
            }
            iRubyObject6 = iRubyObject3;
            iRubyObject3 = iRubyObject4;
            iRubyObject4 = iRubyObject6;
        }
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum && iRubyObject3 instanceof RubyFixnum && iRubyObject4 instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).getLongValue();
            long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
            long l3 = ((RubyFixnum)iRubyObject3).getLongValue();
            long l4 = ((RubyFixnum)iRubyObject4).getLongValue();
            long l5 = Numeric.i_gcd(l, l4);
            long l6 = Numeric.i_gcd(l2, l3);
            iRubyObject6 = RubyRational.f_imul(threadContext, l / l5, l3 / l6);
            iRubyObject5 = RubyRational.f_imul(threadContext, l2 / l6, l4 / l5);
        } else {
            IRubyObject iRubyObject7 = Numeric.f_gcd(threadContext, iRubyObject, iRubyObject4);
            IRubyObject iRubyObject8 = Numeric.f_gcd(threadContext, iRubyObject2, iRubyObject3);
            iRubyObject6 = Numeric.f_mul(threadContext, Numeric.f_idiv(threadContext, iRubyObject, iRubyObject7), Numeric.f_idiv(threadContext, iRubyObject3, iRubyObject8));
            iRubyObject5 = Numeric.f_mul(threadContext, Numeric.f_idiv(threadContext, iRubyObject2, iRubyObject8), Numeric.f_idiv(threadContext, iRubyObject4, iRubyObject7));
        }
        return RubyRational.newRationalNoReduce(threadContext, this.getMetaClass(), iRubyObject6, iRubyObject5);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_muldiv(threadContext, this.num, this.den, iRubyObject, RubyFixnum.one(threadContext.getRuntime()), true);
            }
            case 11: {
                return Numeric.f_mul(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
            }
            case 21: {
                RubyRational rubyRational = (RubyRational)iRubyObject;
                return this.f_muldiv(threadContext, this.num, this.den, rubyRational.num, rubyRational.den, true);
            }
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                if (Numeric.f_zero_p(threadContext, iRubyObject)) {
                    throw threadContext.getRuntime().newZeroDivisionError();
                }
                return this.f_muldiv(threadContext, this.num, this.den, iRubyObject, RubyFixnum.one(threadContext.getRuntime()), false);
            }
            case 11: {
                return Numeric.f_to_f(threadContext, this).callMethod(threadContext, "/", iRubyObject);
            }
            case 21: {
                if (Numeric.f_zero_p(threadContext, iRubyObject)) {
                    throw threadContext.getRuntime().newZeroDivisionError();
                }
                RubyRational rubyRational = (RubyRational)iRubyObject;
                return this.f_muldiv(threadContext, this.num, this.den, rubyRational.num, rubyRational.den, false);
            }
        }
        return this.coerceBin(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"fdiv"})
    public IRubyObject op_fdiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Numeric.f_div(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        Ruby ruby = threadContext.getRuntime();
        if (Numeric.f_zero_p(threadContext, iRubyObject)) {
            return RubyRational.newRationalBang(threadContext, this.getMetaClass(), RubyFixnum.one(ruby));
        }
        if (iRubyObject instanceof RubyRational) {
            iRubyObject2 = (RubyRational)iRubyObject;
            if (Numeric.f_one_p(threadContext, iRubyObject2.den)) {
                iRubyObject = iRubyObject2.num;
            }
        }
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                IRubyObject iRubyObject3;
                IRubyObject iRubyObject4 = Numeric.f_cmp(threadContext, iRubyObject, RubyFixnum.zero(ruby));
                if (iRubyObject4 == RubyFixnum.one(ruby)) {
                    iRubyObject2 = Numeric.f_expt(threadContext, this.num, iRubyObject);
                    iRubyObject3 = Numeric.f_expt(threadContext, this.den, iRubyObject);
                } else if (iRubyObject4 == RubyFixnum.minus_one(ruby)) {
                    iRubyObject2 = Numeric.f_expt(threadContext, this.den, Numeric.f_negate(threadContext, iRubyObject));
                    iRubyObject3 = Numeric.f_expt(threadContext, this.num, Numeric.f_negate(threadContext, iRubyObject));
                } else {
                    iRubyObject3 = RubyFixnum.one(ruby);
                    iRubyObject2 = iRubyObject3;
                }
                return RubyRational.newRational(threadContext, this.getMetaClass(), iRubyObject2, iRubyObject3);
            }
            case 11: 
            case 21: {
                return Numeric.f_expt(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
            }
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                if (this.den instanceof RubyFixnum && ((RubyFixnum)this.den).getLongValue() == 1L) {
                    return Numeric.f_cmp(threadContext, this.num, iRubyObject);
                }
                return Numeric.f_cmp(threadContext, this, RubyRational.newRationalBang(threadContext, this.getMetaClass(), iRubyObject));
            }
            case 11: {
                return Numeric.f_cmp(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject);
            }
            case 21: {
                IRubyObject iRubyObject2;
                IRubyObject iRubyObject3;
                RubyRational rubyRational = (RubyRational)iRubyObject;
                if (this.num instanceof RubyFixnum && this.den instanceof RubyFixnum && rubyRational.num instanceof RubyFixnum && rubyRational.den instanceof RubyFixnum) {
                    iRubyObject3 = RubyRational.f_imul(threadContext, ((RubyFixnum)this.num).getLongValue(), ((RubyFixnum)rubyRational.den).getLongValue());
                    iRubyObject2 = RubyRational.f_imul(threadContext, ((RubyFixnum)rubyRational.num).getLongValue(), ((RubyFixnum)this.den).getLongValue());
                } else {
                    iRubyObject3 = Numeric.f_mul(threadContext, this.num, rubyRational.den);
                    iRubyObject2 = Numeric.f_mul(threadContext, rubyRational.num, this.den);
                }
                return Numeric.f_cmp(threadContext, Numeric.f_sub(threadContext, iRubyObject3, iRubyObject2), RubyFixnum.zero(threadContext.getRuntime()));
            }
        }
        return this.coerceBin(threadContext, "<=>", iRubyObject);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                if (Numeric.f_zero_p(threadContext, this.num) && Numeric.f_zero_p(threadContext, this.den)) {
                    return ruby.getTrue();
                }
                if (!(this.den instanceof RubyFixnum) || ((RubyFixnum)this.den).getLongValue() != 1L) {
                    return ruby.getFalse();
                }
                if (Numeric.f_equal_p(threadContext, this.num, iRubyObject)) {
                    return ruby.getTrue();
                }
                return ruby.getFalse();
            }
            case 11: {
                return Numeric.f_equal_p(threadContext, Numeric.f_to_f(threadContext, this), iRubyObject) ? ruby.getTrue() : ruby.getFalse();
            }
            case 21: {
                RubyRational rubyRational = (RubyRational)iRubyObject;
                if (Numeric.f_zero_p(threadContext, this.num) && Numeric.f_zero_p(threadContext, rubyRational.num)) {
                    return ruby.getTrue();
                }
                if (Numeric.f_equal_p(threadContext, this.num, rubyRational.num) && Numeric.f_equal_p(threadContext, this.den, rubyRational.den)) {
                    return ruby.getTrue();
                }
                return ruby.getFalse();
            }
        }
        return Numeric.f_equal_p(threadContext, iRubyObject, this) ? ruby.getTrue() : ruby.getFalse();
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject op_coerce(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: {
                return ruby.newArray(RubyRational.newRationalBang(threadContext, this.getMetaClass(), iRubyObject), this);
            }
            case 11: {
                return ruby.newArray(iRubyObject, Numeric.f_to_f(threadContext, this));
            }
        }
        throw ruby.newTypeError(iRubyObject.getMetaClass() + " can't be coerced into " + this.getMetaClass());
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_idiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Numeric.f_floor(threadContext, Numeric.f_div(threadContext, this, iRubyObject));
    }

    @JRubyMethod(name={"modulo", "%"})
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = Numeric.f_floor(threadContext, Numeric.f_div(threadContext, this, iRubyObject));
        return Numeric.f_sub(threadContext, this, Numeric.f_mul(threadContext, iRubyObject, iRubyObject2));
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject op_divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = Numeric.f_floor(threadContext, Numeric.f_div(threadContext, this, iRubyObject));
        return threadContext.getRuntime().newArray(iRubyObject2, Numeric.f_sub(threadContext, this, Numeric.f_mul(threadContext, iRubyObject, iRubyObject2)));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject op_rem(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = Numeric.f_truncate(threadContext, Numeric.f_div(threadContext, this, iRubyObject));
        return Numeric.f_sub(threadContext, this, Numeric.f_mul(threadContext, iRubyObject, iRubyObject2));
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject op_abs(ThreadContext threadContext) {
        if (!Numeric.f_negative_p(threadContext, this)) {
            return this;
        }
        return Numeric.f_negate(threadContext, this);
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject op_floor(ThreadContext threadContext) {
        return Numeric.f_idiv(threadContext, this.num, this.den);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject op_ceil(ThreadContext threadContext) {
        return Numeric.f_negate(threadContext, Numeric.f_idiv(threadContext, Numeric.f_negate(threadContext, this.num), this.den));
    }

    @JRubyMethod(name={"truncate", "to_i"})
    public IRubyObject op_truncate(ThreadContext threadContext) {
        if (Numeric.f_negative_p(threadContext, this.num)) {
            return Numeric.f_negate(threadContext, Numeric.f_idiv(threadContext, Numeric.f_negate(threadContext, this.num), this.den));
        }
        return Numeric.f_idiv(threadContext, this.num, this.den);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject op_round(ThreadContext threadContext) {
        RubyFixnum rubyFixnum = RubyFixnum.two(threadContext.getRuntime());
        if (Numeric.f_negative_p(threadContext, this.num)) {
            IRubyObject iRubyObject = Numeric.f_negate(threadContext, this.num);
            iRubyObject = Numeric.f_add(threadContext, Numeric.f_mul(threadContext, iRubyObject, rubyFixnum), this.den);
            IRubyObject iRubyObject2 = Numeric.f_mul(threadContext, this.den, rubyFixnum);
            return Numeric.f_negate(threadContext, Numeric.f_idiv(threadContext, iRubyObject, iRubyObject2));
        }
        IRubyObject iRubyObject = Numeric.f_add(threadContext, Numeric.f_mul(threadContext, this.num, rubyFixnum), this.den);
        IRubyObject iRubyObject3 = Numeric.f_mul(threadContext, this.den, rubyFixnum);
        return Numeric.f_idiv(threadContext, iRubyObject, iRubyObject3);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext threadContext) {
        long l;
        Ruby ruby = threadContext.getRuntime();
        if (Numeric.f_zero_p(threadContext, this.num)) {
            return ruby.newFloat(0.0);
        }
        IRubyObject iRubyObject = this.num;
        IRubyObject iRubyObject2 = this.den;
        boolean bl = false;
        if (Numeric.f_negative_p(threadContext, iRubyObject)) {
            iRubyObject = Numeric.f_negate(threadContext, iRubyObject);
            bl = true;
        }
        long l2 = Numeric.i_ilog2(threadContext, iRubyObject);
        long l3 = Numeric.i_ilog2(threadContext, iRubyObject2);
        long l4 = 0L;
        if (l2 > ML) {
            l4 = l2 - ML;
            iRubyObject = Numeric.f_rshift(threadContext, iRubyObject, RubyFixnum.newFixnum(ruby, l4));
        }
        long l5 = 0L;
        if (l3 > ML) {
            l5 = l3 - ML;
            iRubyObject2 = Numeric.f_rshift(threadContext, iRubyObject2, RubyFixnum.newFixnum(ruby, l5));
        }
        if ((l = l4 - l5) > 1023L || l < -1022L) {
            ruby.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
            return ruby.newFloat(l > 0L ? Double.MAX_VALUE : 0.0);
        }
        double d = RubyNumeric.num2dbl(iRubyObject) / RubyNumeric.num2dbl(iRubyObject2);
        if (bl) {
            d = -d;
            d = Numeric.ldexp(d, l);
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            ruby.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
        }
        return ruby.newFloat(d);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext threadContext) {
        return Numeric.f_xor(threadContext, this.num, this.den);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext threadContext) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getKernel(), "format", (IRubyObject)threadContext.getRuntime().newString("%d/%d"), this.num, this.den);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getKernel(), "format", (IRubyObject)threadContext.getRuntime().newString("(%d/%d)"), this.num, this.den);
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext threadContext) {
        return threadContext.getRuntime().newArray(this.num, this.den);
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        this.num = rubyArray.size() > 0 ? rubyArray.eltInternal(0) : threadContext.getRuntime().getNil();
        IRubyObject iRubyObject2 = this.den = rubyArray.size() > 1 ? rubyArray.eltInternal(1) : threadContext.getRuntime().getNil();
        if (Numeric.f_zero_p(threadContext, this.den)) {
            throw threadContext.getRuntime().newZeroDivisionError();
        }
        return this;
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject gcd(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyRational.intCheck(iRubyObject);
        return Numeric.f_gcd(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"lcm"})
    public IRubyObject lcm(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyRational.intCheck(iRubyObject);
        return Numeric.f_lcm(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"gcdlcm"})
    public IRubyObject gcdlcm(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyRational.intCheck(iRubyObject);
        return threadContext.getRuntime().newArray(Numeric.f_gcd(threadContext, this, iRubyObject), Numeric.f_lcm(threadContext, this, iRubyObject));
    }

    static RubyArray str_to_r_internal(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.callMethod(threadContext, "strip").convertToString();
        ByteList byteList = rubyString.getByteList();
        Ruby ruby = threadContext.getRuntime();
        if (byteList.realSize == 0) {
            return ruby.newArray(ruby.getNil(), iRubyObject);
        }
        IRubyObject iRubyObject2 = RubyRegexp.newRegexp(ruby, Numeric.RationalPatterns.rat_pat).callMethod(threadContext, "match", rubyString);
        if (!iRubyObject2.isNil()) {
            IRubyObject iRubyObject3 = iRubyObject2.callMethod(threadContext, "[]", RubyFixnum.one(ruby));
            IRubyObject iRubyObject4 = iRubyObject2.callMethod(threadContext, "[]", RubyFixnum.two(ruby));
            IRubyObject iRubyObject5 = iRubyObject2.callMethod(threadContext, "[]", RubyFixnum.three(ruby));
            IRubyObject iRubyObject6 = iRubyObject2.callMethod(threadContext, "post_match");
            RubyArray rubyArray = iRubyObject4.callMethod(threadContext, "split", RubyRegexp.newRegexp(ruby, Numeric.RationalPatterns.an_e_pat)).convertToArray();
            IRubyObject iRubyObject7 = rubyArray.eltInternal(0);
            IRubyObject iRubyObject8 = rubyArray.size() != 2 ? ruby.getNil() : rubyArray.eltInternal(1);
            rubyArray = iRubyObject7.callMethod(threadContext, "split", RubyRegexp.newRegexp(ruby, Numeric.RationalPatterns.a_dot_pat)).convertToArray();
            IRubyObject iRubyObject9 = rubyArray.eltInternal(0);
            IRubyObject iRubyObject10 = rubyArray.size() != 2 ? ruby.getNil() : rubyArray.eltInternal(1);
            IRubyObject iRubyObject11 = RubyRational.newRationalCanonicalize(threadContext, Numeric.f_to_i(threadContext, iRubyObject9));
            if (!iRubyObject10.isNil()) {
                byteList = iRubyObject10.convertToString().getByteList();
                int n = 0;
                byte[] byArray = byteList.bytes;
                int n2 = byteList.begin;
                int n3 = n2 + byteList.realSize;
                while (n2 < n3) {
                    if (!ASCIIEncoding.INSTANCE.isDigit((int)byArray[n2++])) continue;
                    ++n;
                }
                IRubyObject iRubyObject12 = Numeric.f_expt(threadContext, RubyFixnum.newFixnum(ruby, 10L), RubyFixnum.newFixnum(ruby, n));
                iRubyObject11 = Numeric.f_mul(threadContext, iRubyObject11, iRubyObject12);
                iRubyObject11 = Numeric.f_add(threadContext, iRubyObject11, Numeric.f_to_i(threadContext, iRubyObject10));
                iRubyObject11 = Numeric.f_div(threadContext, iRubyObject11, iRubyObject12);
            }
            if (!iRubyObject8.isNil()) {
                iRubyObject11 = Numeric.f_mul(threadContext, iRubyObject11, Numeric.f_expt(threadContext, RubyFixnum.newFixnum(ruby, 10L), Numeric.f_to_i(threadContext, iRubyObject8)));
            }
            if (!iRubyObject3.isNil() && (byteList = iRubyObject3.convertToString().getByteList()).length() > 0 && byteList.get(0) == 45) {
                iRubyObject11 = Numeric.f_negate(threadContext, iRubyObject11);
            }
            if (!iRubyObject5.isNil()) {
                iRubyObject11 = Numeric.f_div(threadContext, iRubyObject11, Numeric.f_to_i(threadContext, iRubyObject5));
            }
            return ruby.newArray(iRubyObject11, iRubyObject6);
        }
        return ruby.newArray(ruby.getNil(), iRubyObject);
    }

    private static IRubyObject str_to_r_strict(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = RubyRational.str_to_r_internal(threadContext, iRubyObject);
        if (rubyArray.eltInternal(0).isNil() || rubyArray.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "inspect");
            throw threadContext.getRuntime().newArgumentError("invalid value for Rational: " + iRubyObject2.convertToString());
        }
        return rubyArray.eltInternal(0);
    }
}

