/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.nb.nb.nb.CompatVersion;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyComparable;
import org.jruby.nb.nb.nb.RubyComplex;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyMatchData;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyRange;
import org.jruby.nb.nb.nb.RubyRational;
import org.jruby.nb.nb.nb.RubyRegexp;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.anno.FrameField;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.java.MiniJava;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.Frame;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.nb.nb.util.Numeric;
import org.jruby.nb.nb.nb.util.Pack;
import org.jruby.nb.nb.nb.util.Sprintf;
import org.jruby.nb.nb.nb.util.string.JavaCrypt;
import org.jruby.util.ByteList;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return RubyString.newEmptyString(ruby, rubyClass);
        }
    };
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain((CharSequence)" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("String", ruby.getObject(), STRING_ALLOCATOR);
        ruby.setString(rubyClass);
        rubyClass.index = 4;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyString;
            }
        };
        rubyClass.includeModule(ruby.getComparable());
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyString.class);
        return rubyClass;
    }

    public final boolean eql(IRubyObject iRubyObject) {
        if (iRubyObject.getMetaClass() == this.getRuntime().getString()) {
            return this.value.equal(((RubyString)iRubyObject).value);
        }
        return super.eql(iRubyObject);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, CharSequence charSequence) {
        super(ruby, rubyClass);
        assert (charSequence != null);
        this.value = new ByteList(ByteList.plain((CharSequence)charSequence), false);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, byte[] byArray) {
        super(ruby, rubyClass);
        assert (byArray != null);
        this.value = new ByteList(byArray);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, ByteList byteList) {
        super(ruby, rubyClass);
        assert (byteList != null);
        this.value = byteList;
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, ByteList byteList, boolean bl) {
        super(ruby, rubyClass, bl);
        assert (byteList != null);
        this.value = byteList;
    }

    public RubyString newString(CharSequence charSequence) {
        return new RubyString(this.getRuntime(), this.getType(), charSequence);
    }

    public RubyString newString(ByteList byteList) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), byteList);
    }

    public static RubyString newString(Ruby ruby, CharSequence charSequence) {
        return new RubyString(ruby, ruby.getString(), charSequence);
    }

    public static RubyString newEmptyString(Ruby ruby) {
        return RubyString.newEmptyString(ruby, ruby.getString());
    }

    public static RubyString newEmptyString(Ruby ruby, RubyClass rubyClass) {
        RubyString rubyString = new RubyString(ruby, rubyClass, ByteList.EMPTY_BYTELIST);
        rubyString.shareLevel = 2;
        return rubyString;
    }

    public static RubyString newUnicodeString(Ruby ruby, String string) {
        try {
            return new RubyString(ruby, ruby.getString(), new ByteList(string.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new RubyString(ruby, ruby.getString(), string);
        }
    }

    @Deprecated
    public static RubyString newString(Ruby ruby, RubyClass rubyClass, CharSequence charSequence) {
        return new RubyString(ruby, rubyClass, charSequence);
    }

    public static RubyString newString(Ruby ruby, byte[] byArray) {
        return new RubyString(ruby, ruby.getString(), byArray);
    }

    public static RubyString newString(Ruby ruby, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new RubyString(ruby, ruby.getString(), new ByteList(byArray2, false));
    }

    public static RubyString newString(Ruby ruby, ByteList byteList) {
        return new RubyString(ruby, ruby.getString(), byteList);
    }

    public static RubyString newStringLight(Ruby ruby, ByteList byteList) {
        return new RubyString(ruby, ruby.getString(), byteList, false);
    }

    public static RubyString newStringShared(Ruby ruby, RubyString rubyString) {
        rubyString.shareLevel = 2;
        RubyString rubyString2 = new RubyString(ruby, ruby.getString(), rubyString.value);
        rubyString2.shareLevel = 2;
        return rubyString2;
    }

    public static RubyString newStringShared(Ruby ruby, ByteList byteList) {
        return RubyString.newStringShared(ruby, ruby.getString(), byteList);
    }

    public static RubyString newStringShared(Ruby ruby, RubyClass rubyClass, ByteList byteList) {
        RubyString rubyString = new RubyString(ruby, rubyClass, byteList);
        rubyString.shareLevel = 2;
        return rubyString;
    }

    public static RubyString newStringShared(Ruby ruby, byte[] byArray, int n, int n2) {
        RubyString rubyString = new RubyString(ruby, ruby.getString(), new ByteList(byArray, n, n2, false));
        rubyString.shareLevel = 1;
        return rubyString;
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public RubyString convertToString() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    @Deprecated
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    public final RubyString strDup(Ruby ruby) {
        return this.strDup(ruby, this.getMetaClass());
    }

    @Deprecated
    final RubyString strDup(RubyClass rubyClass) {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    final RubyString strDup(Ruby ruby, RubyClass rubyClass) {
        this.shareLevel = 2;
        RubyString rubyString = new RubyString(ruby, rubyClass, this.value);
        rubyString.shareLevel = 2;
        rubyString.infectBy(this);
        return rubyString;
    }

    public final RubyString makeShared(Ruby ruby, int n, int n2) {
        if (n2 == 0) {
            RubyString rubyString = RubyString.newEmptyString(ruby, this.getMetaClass());
            rubyString.infectBy(this);
            return rubyString;
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
        RubyString rubyString = new RubyString(ruby, this.getMetaClass(), this.value.makeShared(n, n2));
        rubyString.shareLevel = 1;
        rubyString.infectBy(this);
        return rubyString;
    }

    final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string");
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] byArray, int n) {
        if (this.value.bytes != byArray || this.value.realSize != n) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify(int n) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(n);
            } else {
                this.value.unshare(n);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(n);
        }
        this.value.invalidate();
    }

    private final void view(ByteList byteList) {
        this.modifyCheck();
        this.value = byteList;
        this.shareLevel = 0;
    }

    private final void view(byte[] byArray) {
        this.modifyCheck();
        this.value.replace(byArray);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int n, int n2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(n, n2);
                this.shareLevel = 1;
            } else {
                this.value.view(n, n2);
            }
        } else {
            this.value.view(n, n2);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        return new String(ByteList.plain((byte[])byArray, (int)n, (int)n2));
    }

    public static String byteListToString(ByteList byteList) {
        return RubyString.bytesToString(byteList.unsafeBytes(), byteList.begin(), byteList.length());
    }

    public static String bytesToString(byte[] byArray) {
        return RubyString.bytesToString(byArray, 0, byArray.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain((CharSequence)string);
    }

    public static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    public static boolean isUpper(int n) {
        return n >= 65 && n <= 90;
    }

    public static boolean isLower(int n) {
        return n >= 97 && n <= 122;
    }

    public static boolean isLetter(int n) {
        return RubyString.isUpper(n) || RubyString.isLower(n);
    }

    public static boolean isAlnum(int n) {
        return RubyString.isUpper(n) || RubyString.isLower(n) || RubyString.isDigit(n);
    }

    public static boolean isPrint(int n) {
        return n >= 32 && n <= 126;
    }

    public RubyString asString() {
        return this;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        Ruby ruby = this.getRuntime();
        if (this.getMetaClass().getRealClass() != ruby.getString()) {
            return this.strDup(ruby, ruby.getString());
        }
        return this;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        if (iRubyObject instanceof RubyString) {
            return threadContext.getRuntime().newFixnum(this.op_cmp((RubyString)iRubyObject));
        }
        if (iRubyObject.respondsTo("to_str") && iRubyObject.respondsTo("<=>") && (iRubyObject2 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", this)) instanceof RubyNumeric) {
            return ((RubyNumeric)iRubyObject2).op_uminus(threadContext);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (this == iRubyObject) {
            return ruby.getTrue();
        }
        if (!(iRubyObject instanceof RubyString)) {
            if (!iRubyObject.respondsTo("to_str")) {
                return ruby.getFalse();
            }
            return iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this).isTrue() ? ruby.getTrue() : ruby.getFalse();
        }
        return this.value.equal(((RubyString)iRubyObject).value) ? ruby.getTrue() : ruby.getFalse();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.convertToString();
        ByteList byteList = new ByteList(this.value.realSize + rubyString.value.realSize);
        byteList.realSize = this.value.realSize + rubyString.value.realSize;
        System.arraycopy(this.value.bytes, this.value.begin, byteList.bytes, 0, this.value.realSize);
        System.arraycopy(rubyString.value.bytes, rubyString.value.begin, byteList.bytes, this.value.realSize, rubyString.value.realSize);
        RubyString rubyString2 = RubyString.newString(threadContext.getRuntime(), byteList);
        if (this.isTaint() || rubyString.isTaint()) {
            rubyString2.setTaint(true);
        }
        return rubyString2;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyInteger rubyInteger = iRubyObject.convertToInteger();
        long l = rubyInteger.getLongValue();
        if (l < 0L) {
            throw threadContext.getRuntime().newArgumentError("negative argument");
        }
        if (l > 0L && Integer.MAX_VALUE / l < (long)this.value.length()) {
            throw threadContext.getRuntime().newArgumentError("argument too big");
        }
        ByteList byteList = new ByteList(this.value.length() * (int)l);
        int n = 0;
        while ((long)n < l) {
            byteList.append(this.value);
            ++n;
        }
        RubyString rubyString = new RubyString(threadContext.getRuntime(), this.getMetaClass(), byteList);
        rubyString.setTaint(this.isTaint());
        return rubyString;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject.checkArrayType();
        if (iRubyObject2.isNil()) {
            iRubyObject2 = iRubyObject;
        }
        RubyString rubyString = Sprintf.sprintf(threadContext.getRuntime(), Locale.US, (CharSequence)this.value, iRubyObject2);
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RubyString) {
            RubyString rubyString = (RubyString)object;
            if (rubyString.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return (RubyString)iRubyObject;
        }
        IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s");
        if (!(iRubyObject2 instanceof RubyString)) {
            return (RubyString)iRubyObject.anyToString();
        }
        if (iRubyObject.isTaint()) {
            iRubyObject2.setTaint(true);
        }
        return (RubyString)iRubyObject2;
    }

    public int op_cmp(RubyString rubyString) {
        return this.value.cmp(rubyString.value);
    }

    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] byArray) {
        this.modify(this.value.realSize + byArray.length);
        System.arraycopy(byArray, 0, this.value.bytes, this.value.begin + this.value.realSize, byArray.length);
        this.value.realSize += byArray.length;
        return this;
    }

    public RubyString cat(byte[] byArray, int n, int n2) {
        this.modify(this.value.realSize + n2);
        System.arraycopy(byArray, n, this.value.bytes, this.value.begin + this.value.realSize, n2);
        this.value.realSize += n2;
        return this;
    }

    public RubyString cat(ByteList byteList) {
        this.modify(this.value.realSize + byteList.realSize);
        System.arraycopy(byteList.bytes, byteList.begin, this.value.bytes, this.value.begin + this.value.realSize, byteList.realSize);
        this.value.realSize += byteList.realSize;
        return this;
    }

    public RubyString cat(byte by) {
        this.modify(this.value.realSize + 1);
        this.value.bytes[this.value.begin + this.value.realSize] = by;
        ++this.value.realSize;
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1)
    public RubyString replace(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        this.modifyCheck();
        RubyString rubyString = RubyString.stringValue(iRubyObject);
        this.shareLevel = 2;
        rubyString.shareLevel = 2;
        this.value = rubyString.value;
        this.infectBy(iRubyObject);
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public RubyString reverse(ThreadContext threadContext) {
        if (this.value.length() <= 1) {
            return this.strDup(threadContext.getRuntime());
        }
        ByteList byteList = new ByteList(this.value.length() + 2);
        byteList.realSize = this.value.length();
        int n = this.value.length() - 1;
        int n2 = 0;
        while (n >= 0) {
            byteList.set(n2++, this.value.get(n--));
        }
        RubyString rubyString = new RubyString(threadContext.getRuntime(), this.getMetaClass(), byteList);
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte by = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, (int)by);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyString.newStringShared(iRubyObject.getRuntime(), ByteList.EMPTY_BYTELIST);
        rubyString.setMetaClass((RubyClass)iRubyObject);
        rubyString.callInit(iRubyObjectArray, block);
        return rubyString;
    }

    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this;
            }
            case 1: {
                return this.initialize(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject) {
        this.replace(iRubyObject);
        return this;
    }

    @JRubyMethod
    public IRubyObject casecmp(IRubyObject iRubyObject) {
        int n = this.value.caseInsensitiveCmp(RubyString.stringValue((IRubyObject)iRubyObject).value);
        return RubyFixnum.newFixnum(this.getRuntime(), n);
    }

    @JRubyMethod(name={"=~"})
    public IRubyObject op_match(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyRegexp) {
            return ((RubyRegexp)iRubyObject).op_match(threadContext, this);
        }
        if (iRubyObject instanceof RubyString) {
            throw threadContext.getRuntime().newTypeError("type mismatch: String given");
        }
        return iRubyObject.callMethod(threadContext, "=~", this);
    }

    @JRubyMethod(name={"~"}, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_match2(ThreadContext threadContext) {
        return RubyRegexp.newRegexp(threadContext.getRuntime(), this.value, 0, false).op_match2(threadContext);
    }

    @JRubyMethod
    public IRubyObject match(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.getPattern(iRubyObject, false).callMethod(threadContext, "match", this);
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.capitalize_bang(threadContext);
        return rubyString;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang(ThreadContext threadContext) {
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return threadContext.getRuntime().getNil();
        }
        this.modify();
        int n = this.value.begin;
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        int n3 = byArray[n] & 0xFF;
        if (ASCII.isLower(n3)) {
            byArray[n] = ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        while (++n < n2) {
            n3 = (char)(byArray[n] & 0xFF);
            if (!ASCII.isUpper(n3)) continue;
            byArray[n] = ASCIIEncoding.asciiToLower((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return threadContext.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) >= 0);
        }
        return RubyComparable.op_ge(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return threadContext.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) > 0);
        }
        return RubyComparable.op_gt(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return threadContext.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) <= 0);
        }
        return RubyComparable.op_le(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return threadContext.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) < 0);
        }
        return RubyComparable.op_lt(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject str_eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyString)) {
            return threadContext.getRuntime().getFalse();
        }
        RubyString rubyString = (RubyString)iRubyObject;
        return this.value.equal(rubyString.value) ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString upcase(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.upcase_bang(threadContext);
        return rubyString;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang(ThreadContext threadContext) {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return threadContext.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (!ASCII.isLower(n3)) continue;
            byArray[n] = ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString downcase(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.downcase_bang(threadContext);
        return rubyString;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang(ThreadContext threadContext) {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return threadContext.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (!ASCII.isUpper(n3)) continue;
            byArray[n] = ASCIIEncoding.asciiToLower((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString swapcase(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.swapcase_bang(threadContext);
        return rubyString;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang(ThreadContext threadContext) {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return threadContext.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (ASCII.isUpper(n3)) {
                byArray[n] = ASCIIEncoding.asciiToLower((int)n3);
                bl = true;
                continue;
            }
            if (!ASCII.isLower(n3)) continue;
            byArray[n] = ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject dump() {
        RubyString rubyString = new RubyString(this.getRuntime(), this.getMetaClass(), this.inspectIntoByteList(true));
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod
    public IRubyObject insert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        ByteList byteList = rubyString.value;
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (n < 0) {
            n += this.value.length() + 1;
        }
        if (n < 0 || n > this.value.length()) {
            throw threadContext.getRuntime().newIndexError("index " + n + " out of range");
        }
        this.modify();
        this.value.unsafeReplace(n, 0, byteList);
        this.infectBy(rubyString);
        return this;
    }

    @JRubyMethod
    public IRubyObject inspect() {
        RubyString rubyString = this.getRuntime().newString(this.inspectIntoByteList(false));
        rubyString.infectBy(this);
        return rubyString;
    }

    private ByteList inspectIntoByteList(boolean bl) {
        Ruby ruby = this.getRuntime();
        Encoding encoding = ruby.getKCode().getEncoding();
        int n = this.value.length();
        ByteList byteList = new ByteList(n + 2 + n / 100);
        byteList.append(34);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.value.get(i) & 0xFF;
            if (!bl && (n2 = encoding.length((byte)n3)) > 1 && i + n2 - 1 < n) {
                byteList.append(this.value, i, n2);
                i += n2 - 1;
                continue;
            }
            if (RubyString.isAlnum(n3)) {
                byteList.append((int)((char)n3));
                continue;
            }
            if (n3 == 34 || n3 == 92) {
                byteList.append(92).append((int)((char)n3));
                continue;
            }
            if (n3 == 35 && this.isEVStr(i, n)) {
                byteList.append(92).append((int)((char)n3));
                continue;
            }
            if (RubyString.isPrint(n3)) {
                byteList.append((int)((char)n3));
                continue;
            }
            if (n3 == 10) {
                byteList.append(92).append(110);
                continue;
            }
            if (n3 == 13) {
                byteList.append(92).append(114);
                continue;
            }
            if (n3 == 9) {
                byteList.append(92).append(116);
                continue;
            }
            if (n3 == 12) {
                byteList.append(92).append(102);
                continue;
            }
            if (n3 == 11) {
                byteList.append(92).append(118);
                continue;
            }
            if (n3 == 7) {
                byteList.append(92).append(97);
                continue;
            }
            if (n3 == 8) {
                byteList.append(92).append(98);
                continue;
            }
            if (n3 == 27) {
                byteList.append(92).append(101);
                continue;
            }
            byteList.append(ByteList.plain((CharSequence)Sprintf.sprintf(ruby, (CharSequence)"\\%03o", n3)));
        }
        byteList.append(34);
        return byteList;
    }

    private boolean isEVStr(int n, int n2) {
        if (n + 1 >= n2) {
            return false;
        }
        int n3 = this.value.get(n + 1) & 0xFF;
        return n3 == 36 || n3 == 64 || n3 == 123;
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext threadContext) {
        return this.isEmpty() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject iRubyObject) {
        this.infectBy(iRubyObject);
        return this.cat(RubyString.stringValue((IRubyObject)iRubyObject).value);
    }

    @JRubyMethod(name={"concat", "<<"})
    public RubyString concat(IRubyObject iRubyObject) {
        long l;
        if (iRubyObject instanceof RubyFixnum && (l = ((RubyFixnum)iRubyObject).getLongValue()) >= 0L && l < 256L) {
            return this.cat((byte)l);
        }
        return this.append(iRubyObject);
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList = RubyString.stringValue(iRubyObject).getByteList();
        if (byteList.realSize < 2) {
            throw threadContext.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        byteList = byteList.makeShared(0, 2);
        RubyString rubyString = RubyString.newStringShared(threadContext.getRuntime(), JavaCrypt.crypt(byteList, this.getByteList()));
        rubyString.infectBy(this);
        rubyString.infectBy(iRubyObject);
        return rubyString;
    }

    public static RubyString stringValue(IRubyObject iRubyObject) {
        return (RubyString)(iRubyObject instanceof RubyString ? iRubyObject : iRubyObject.convertToString());
    }

    public IRubyObject sub(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.sub_bang(threadContext, iRubyObjectArray, block);
        return rubyString;
    }

    @JRubyMethod(name={"sub"}, frame=true)
    public IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.sub_bang(threadContext, iRubyObject, block);
        return rubyString;
    }

    @JRubyMethod(name={"sub"}, frame=true)
    public IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.sub_bang(threadContext, iRubyObject, iRubyObject2, block);
        return rubyString;
    }

    public IRubyObject sub_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.sub_bang(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.sub_bang(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (block.isGiven()) {
            RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
            Regex regex = rubyRegexp.getPattern();
            return this.subBangCommon(regex, threadContext, true, rubyRegexp, block, null, false);
        }
        throw threadContext.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyString rubyString = iRubyObject2.convertToString();
        RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
        Regex regex = rubyRegexp.getPattern();
        return this.subBangCommon(regex, threadContext, false, rubyRegexp, block, rubyString, rubyString.isTaint());
    }

    private IRubyObject subBangCommon(Regex regex, ThreadContext threadContext, boolean bl, RubyRegexp rubyRegexp, Block block, RubyString rubyString, boolean bl2) {
        int n = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n);
        Frame frame = threadContext.getPreviousFrame();
        if (matcher.search(this.value.begin, n, 0) >= 0) {
            int n2;
            RubyMatchData rubyMatchData;
            int n3;
            if (bl) {
                byte[] byArray = this.value.bytes;
                n3 = this.value.realSize;
                rubyMatchData = rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
                rubyMatchData.use();
                if (regex.numberOfCaptures() == 0) {
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
                } else {
                    Region region = matcher.getRegion();
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(region.beg[0], region.end[0] - region.beg[0])));
                }
                this.modifyCheck(byArray, n3);
                this.frozenCheck();
                frame.setBackRef(rubyMatchData);
            } else {
                rubyString = rubyRegexp.regsub(rubyString, this, matcher);
                rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
            }
            if (regex.numberOfCaptures() == 0) {
                n2 = matcher.getBegin();
                n3 = matcher.getEnd() - n2;
            } else {
                rubyMatchData = matcher.getRegion();
                n2 = ((Region)rubyMatchData).beg[0];
                n3 = ((Region)rubyMatchData).end[0] - n2;
            }
            rubyMatchData = rubyString.value;
            if (((ByteList)rubyMatchData).realSize > n3) {
                this.modify(this.value.realSize + ((ByteList)rubyMatchData).realSize - n3);
            } else {
                this.modify();
            }
            if (rubyString.isTaint()) {
                bl2 = true;
            }
            if (((ByteList)rubyMatchData).realSize != n3) {
                int n4 = this.value.begin + n2 + n3;
                int n5 = this.value.begin + n2 + ((ByteList)rubyMatchData).realSize;
                int n6 = this.value.realSize - n2 - n3;
                System.arraycopy(this.value.bytes, n4, this.value.bytes, n5, n6);
            }
            System.arraycopy(((ByteList)rubyMatchData).bytes, ((ByteList)rubyMatchData).begin, this.value.bytes, this.value.begin + n2, ((ByteList)rubyMatchData).realSize);
            this.value.realSize += ((ByteList)rubyMatchData).realSize - n3;
            if (bl2) {
                this.setTaint(true);
            }
            return this;
        }
        frame.setBackRef(threadContext.getRuntime().getNil());
        return threadContext.getRuntime().getNil();
    }

    public IRubyObject gsub(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.gsub(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.gsub(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.gsub(threadContext, iRubyObject, block, false);
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return this.gsub(threadContext, iRubyObject, iRubyObject2, block, false);
    }

    public IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.gsub_bang(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.gsub_bang(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.gsub(threadContext, iRubyObject, block, true);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return this.gsub(threadContext, iRubyObject, iRubyObject2, block, true);
    }

    private final IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, Block block, boolean bl) {
        if (block.isGiven()) {
            RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
            Regex regex = rubyRegexp.getPattern();
            return this.gsubCommon(regex, threadContext, bl, true, rubyRegexp, block, null, false);
        }
        throw threadContext.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
    }

    private final IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        RubyString rubyString = iRubyObject2.convertToString();
        RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
        Regex regex = rubyRegexp.getPattern();
        return this.gsubCommon(regex, threadContext, bl, false, rubyRegexp, block, rubyString, rubyString.isTaint());
    }

    private IRubyObject gsubCommon(Regex regex, ThreadContext threadContext, boolean bl, boolean bl2, RubyRegexp rubyRegexp, Block block, IRubyObject iRubyObject, boolean bl3) {
        int n;
        int n2 = this.value.begin;
        int n3 = n2 + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, n2, n3);
        int n4 = matcher.search(n2, n3, 0);
        Frame frame = threadContext.getPreviousFrame();
        if (n4 < 0) {
            frame.setBackRef(threadContext.getRuntime().getNil());
            return bl ? threadContext.getRuntime().getNil() : this.strDup(threadContext.getRuntime());
        }
        int n5 = this.value.realSize + 30;
        ByteList byteList = new ByteList(n5);
        byteList.realSize = n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.value.begin;
        int n9 = 0;
        RubyMatchData rubyMatchData = null;
        while (n4 >= 0) {
            RubyString rubyString;
            int n10;
            int n11;
            Object object;
            if (bl2) {
                object = this.value.bytes;
                n11 = this.value.realSize;
                rubyMatchData = rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
                rubyMatchData.use();
                if (regex.numberOfCaptures() == 0) {
                    n = matcher.getBegin();
                    n10 = matcher.getEnd();
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(threadContext.getRuntime(), n, n10 - n)));
                } else {
                    Region region = matcher.getRegion();
                    n = region.beg[0];
                    n10 = region.end[0];
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(threadContext.getRuntime(), n, n10 - n)));
                }
                this.modifyCheck((byte[])object, n11);
                if (bl) {
                    this.frozenCheck();
                }
            } else {
                rubyString = rubyRegexp.regsub((RubyString)iRubyObject, this, matcher);
                if (regex.numberOfCaptures() == 0) {
                    n = matcher.getBegin();
                    n10 = matcher.getEnd();
                } else {
                    object = matcher.getRegion();
                    n = object.beg[0];
                    n10 = object.end[0];
                }
            }
            if (rubyString.isTaint()) {
                bl3 = true;
            }
            object = rubyString.value;
            n11 = n7 - n6 + (n4 - n9) + object.realSize + 3;
            if (n5 < n11) {
                while (n5 < n11) {
                    n5 <<= 1;
                }
                n11 = n7 - n6;
                byteList.realloc(n5);
                byteList.realSize = n5;
                n7 = n6 + n11;
            }
            n11 = n4 - n9;
            System.arraycopy(this.value.bytes, n8, byteList.bytes, n7, n11);
            System.arraycopy(object.bytes, object.begin, byteList.bytes, n7 += n11, object.realSize);
            n7 += object.realSize;
            n9 = n10;
            if (n == n10) {
                if (this.value.realSize <= n10) break;
                n11 = regex.getEncoding().length(this.value.bytes[n2 + n10]);
                System.arraycopy(this.value.bytes, n2 + n10, byteList.bytes, n7, n11);
                n7 += n11;
                n9 = n10 + n11;
            }
            n8 = n2 + n9;
            if (n9 > this.value.realSize) break;
            n4 = matcher.search(n8, n3, 0);
        }
        if (this.value.realSize > n9) {
            n = n7 - n6;
            if (n5 - n < this.value.realSize - n9) {
                n5 = n + this.value.realSize - n9;
                byteList.realloc(n5);
                n7 = n6 + n;
            }
            System.arraycopy(this.value.bytes, n8, byteList.bytes, n7, this.value.realSize - n9);
            n7 += this.value.realSize - n9;
        }
        if (rubyMatchData != null) {
            frame.setBackRef(rubyMatchData);
        } else {
            rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
        }
        byteList.realSize = n7 - n6;
        if (bl) {
            this.view(byteList);
            if (bl3) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString rubyString = new RubyString(threadContext.getRuntime(), this.getMetaClass(), byteList);
        rubyString.infectBy(this);
        if (bl3) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    public IRubyObject index(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.index(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.index(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.indexCommon(0, iRubyObject, threadContext);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.num2int(iRubyObject2);
        if (n < 0 && (n += this.value.realSize) < 0) {
            if (iRubyObject instanceof RubyRegexp) {
                threadContext.getPreviousFrame().setBackRef(threadContext.getRuntime().getNil());
            }
            return threadContext.getRuntime().getNil();
        }
        return this.indexCommon(n, iRubyObject, threadContext);
    }

    private IRubyObject indexCommon(int n, IRubyObject iRubyObject, ThreadContext threadContext) throws RaiseException {
        if (iRubyObject instanceof RubyRegexp) {
            RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
            n = rubyRegexp.adjustStartPos(this, n, false);
            n = rubyRegexp.search(threadContext, this, n, false);
        } else {
            if (iRubyObject instanceof RubyFixnum) {
                int n2 = RubyNumeric.fix2int(iRubyObject);
                if (n2 < 0 || n2 > 255) {
                    return threadContext.getRuntime().getNil();
                }
                byte by = (byte)n2;
                byte[] byArray = this.value.bytes;
                int n3 = this.value.begin + this.value.realSize;
                n += this.value.begin;
                while (n < n3) {
                    if (byArray[n] == by) {
                        return RubyFixnum.newFixnum(threadContext.getRuntime(), n - this.value.begin);
                    }
                    ++n;
                }
                return threadContext.getRuntime().getNil();
            }
            if (iRubyObject instanceof RubyString) {
                n = this.strIndex((RubyString)iRubyObject, n);
            } else {
                IRubyObject iRubyObject2 = iRubyObject.checkStringType();
                if (iRubyObject2.isNil()) {
                    throw threadContext.getRuntime().newTypeError("type mismatch: " + iRubyObject.getMetaClass().getName() + " given");
                }
                n = this.strIndex((RubyString)iRubyObject2, n);
            }
        }
        return n == -1 ? threadContext.getRuntime().getNil() : RubyFixnum.newFixnum(threadContext.getRuntime(), n);
    }

    private int strIndex(RubyString rubyString, int n) {
        if (n < 0 && (n += this.value.realSize) < 0) {
            return -1;
        }
        if (this.value.realSize - n < rubyString.value.realSize) {
            return -1;
        }
        if (rubyString.value.realSize == 0) {
            return n;
        }
        return this.value.indexOf(rubyString.value, n);
    }

    public IRubyObject rindex(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.rindex(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.rindex(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.rindexCommon(iRubyObject, this.value.realSize, threadContext);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.num2int(iRubyObject2);
        if (n < 0 && (n += this.value.realSize) < 0) {
            if (iRubyObject instanceof RubyRegexp) {
                threadContext.getPreviousFrame().setBackRef(threadContext.getRuntime().getNil());
            }
            return threadContext.getRuntime().getNil();
        }
        if (n > this.value.realSize) {
            n = this.value.realSize;
        }
        return this.rindexCommon(iRubyObject, n, threadContext);
    }

    private IRubyObject rindexCommon(IRubyObject iRubyObject, int n, ThreadContext threadContext) throws RaiseException {
        if (iRubyObject instanceof RubyRegexp) {
            RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
            if (rubyRegexp.length() > 0) {
                n = rubyRegexp.adjustStartPos(this, n, true);
                n = rubyRegexp.search(threadContext, this, n, true);
            }
            if (n >= 0) {
                return RubyFixnum.newFixnum(threadContext.getRuntime(), n);
            }
        } else if (iRubyObject instanceof RubyString) {
            if ((n = this.strRindex((RubyString)iRubyObject, n)) >= 0) {
                return RubyFixnum.newFixnum(threadContext.getRuntime(), n);
            }
        } else {
            if (iRubyObject instanceof RubyFixnum) {
                int n2 = RubyNumeric.fix2int(iRubyObject);
                if (n2 < 0 || n2 > 255) {
                    return threadContext.getRuntime().getNil();
                }
                byte by = (byte)n2;
                byte[] byArray = this.value.bytes;
                int n3 = this.value.begin;
                int n4 = n3 + n;
                if (n == this.value.realSize) {
                    if (n == 0) {
                        return threadContext.getRuntime().getNil();
                    }
                    --n4;
                }
                while (n3 <= n4) {
                    if (byArray[n4] == by) {
                        return RubyFixnum.newFixnum(threadContext.getRuntime(), n4 - this.value.begin);
                    }
                    --n4;
                }
                return threadContext.getRuntime().getNil();
            }
            IRubyObject iRubyObject2 = iRubyObject.checkStringType();
            if (iRubyObject2.isNil()) {
                throw threadContext.getRuntime().newTypeError("type mismatch: " + iRubyObject.getMetaClass().getName() + " given");
            }
            if ((n = this.strRindex((RubyString)iRubyObject2, n)) >= 0) {
                return RubyFixnum.newFixnum(threadContext.getRuntime(), n);
            }
        }
        return threadContext.getRuntime().getNil();
    }

    private int strRindex(RubyString rubyString, int n) {
        int n2 = rubyString.value.realSize;
        if (this.value.realSize < n2) {
            return -1;
        }
        if (this.value.realSize - n < n2) {
            n = this.value.realSize - n2;
        }
        return this.value.lastIndexOf(rubyString.value, n);
    }

    public IRubyObject substr(int n, int n2) {
        return this.substr(this.getRuntime(), n, n2);
    }

    public IRubyObject substr(Ruby ruby, int n, int n2) {
        int n3 = this.value.length();
        if (n2 < 0 || n > n3) {
            return this.getRuntime().getNil();
        }
        if (n < 0 && (n += n3) < 0) {
            return this.getRuntime().getNil();
        }
        int n4 = Math.min(n3, n + n2);
        return this.makeShared(this.getRuntime(), n, n4 - n);
    }

    public IRubyObject replace(int n, int n2, RubyString rubyString) {
        if (n + n2 >= this.value.length()) {
            n2 = this.value.length() - n;
        }
        this.modify();
        this.value.unsafeReplace(n, n2, rubyString.value);
        return this.infectBy(rubyString);
    }

    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.op_aref(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.op_aref(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyRegexp) {
            if (((RubyRegexp)iRubyObject).search(threadContext, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(RubyNumeric.fix2int(iRubyObject2), threadContext.getCurrentFrame().getBackRef());
            }
            return threadContext.getRuntime().getNil();
        }
        return this.substr(threadContext.getRuntime(), RubyNumeric.fix2int(iRubyObject), RubyNumeric.fix2int(iRubyObject2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyRegexp) {
            if (((RubyRegexp)iRubyObject).search(threadContext, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(0, threadContext.getCurrentFrame().getBackRef());
            }
            return threadContext.getRuntime().getNil();
        }
        if (iRubyObject instanceof RubyString) {
            return this.value.indexOf(RubyString.stringValue((IRubyObject)iRubyObject).value) != -1 ? iRubyObject : threadContext.getRuntime().getNil();
        }
        if (iRubyObject instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObject).begLen(this.value.length(), 0);
            return lArray == null ? threadContext.getRuntime().getNil() : this.substr(threadContext.getRuntime(), (int)lArray[0], (int)lArray[1]);
        }
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (n < 0) {
            n += this.value.length();
        }
        if (n < 0 || n >= this.value.length()) {
            return threadContext.getRuntime().getNil();
        }
        return threadContext.getRuntime().newFixnum(this.value.get(n) & 0xFF);
    }

    private void subpatSet(ThreadContext threadContext, RubyRegexp rubyRegexp, int n, IRubyObject iRubyObject) {
        int n2;
        int n3;
        if (rubyRegexp.search(threadContext, this, 0, false) < 0) {
            throw threadContext.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData rubyMatchData = (RubyMatchData)threadContext.getCurrentFrame().getBackRef();
        if (rubyMatchData.regs == null) {
            if (n >= 1) {
                throw threadContext.getRuntime().newIndexError("index " + n + " out of regexp");
            }
            if (n < 0) {
                if (-n >= 1) {
                    throw threadContext.getRuntime().newIndexError("index " + n + " out of regexp");
                }
                ++n;
            }
            if ((n3 = rubyMatchData.begin) == -1) {
                throw threadContext.getRuntime().newIndexError("regexp group " + n + " not matched");
            }
            n2 = rubyMatchData.end;
        } else {
            if (n >= rubyMatchData.regs.numRegs) {
                throw threadContext.getRuntime().newIndexError("index " + n + " out of regexp");
            }
            if (n < 0) {
                if (-n >= rubyMatchData.regs.numRegs) {
                    throw threadContext.getRuntime().newIndexError("index " + n + " out of regexp");
                }
                n += rubyMatchData.regs.numRegs;
            }
            if ((n3 = rubyMatchData.regs.beg[n]) == -1) {
                throw threadContext.getRuntime().newIndexError("regexp group " + n + " not matched");
            }
            n2 = rubyMatchData.regs.end[n];
        }
        int n4 = n2 - n3;
        this.replace(n3, n4, RubyString.stringValue(iRubyObject));
    }

    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 2: {
                return this.op_aset(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.op_aset(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 2, 3);
        return null;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum || iRubyObject.respondsTo("to_int")) {
            int n = RubyNumeric.fix2int(iRubyObject);
            if (n < 0) {
                n += this.value.length();
            }
            if (n < 0 || n >= this.value.length()) {
                throw threadContext.getRuntime().newIndexError("string index out of bounds");
            }
            if (iRubyObject2 instanceof RubyFixnum) {
                this.modify();
                this.value.set(n, (int)((byte)RubyNumeric.fix2int(iRubyObject2)));
            } else {
                this.replace(n, 1, RubyString.stringValue(iRubyObject2));
            }
            return iRubyObject2;
        }
        if (iRubyObject instanceof RubyRegexp) {
            RubyString rubyString = RubyString.stringValue(iRubyObject2);
            this.subpatSet(threadContext, (RubyRegexp)iRubyObject, 0, rubyString);
            return rubyString;
        }
        if (iRubyObject instanceof RubyString) {
            RubyString rubyString = (RubyString)iRubyObject;
            int n = this.value.indexOf(rubyString.value);
            if (n < 0) {
                throw threadContext.getRuntime().newIndexError("string not matched");
            }
            this.replace(n, rubyString.value.length(), RubyString.stringValue(iRubyObject2));
            return iRubyObject2;
        }
        if (iRubyObject instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObject).begLen(this.value.realSize, 2);
            this.replace((int)lArray[0], (int)lArray[1], RubyString.stringValue(iRubyObject2));
            return iRubyObject2;
        }
        throw threadContext.getRuntime().newTypeError("wrong argument type");
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (iRubyObject instanceof RubyRegexp) {
            RubyString rubyString = RubyString.stringValue(iRubyObject3);
            int n = RubyNumeric.fix2int(iRubyObject2);
            this.subpatSet(threadContext, (RubyRegexp)iRubyObject, n, rubyString);
            return rubyString;
        }
        RubyString rubyString = RubyString.stringValue(iRubyObject3);
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = RubyNumeric.fix2int(iRubyObject2);
        if (n2 < 0) {
            throw threadContext.getRuntime().newIndexError("negative length");
        }
        int n3 = this.value.length();
        if (n < 0) {
            n += n3;
        }
        if (n < 0 || n > 0 && n > n3) {
            throw threadContext.getRuntime().newIndexError("string index out of bounds");
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        this.replace(n, n2, rubyString);
        return rubyString;
    }

    public IRubyObject slice_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.slice_bang(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.slice_bang(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.op_aref(threadContext, iRubyObject);
        if (iRubyObject2.isNil()) {
            return iRubyObject2;
        }
        this.op_aset(threadContext, iRubyObject, RubyString.newEmptyString(threadContext.getRuntime()));
        return iRubyObject2;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = this.op_aref(threadContext, iRubyObject, iRubyObject2);
        if (iRubyObject3.isNil()) {
            return iRubyObject3;
        }
        this.op_aset(threadContext, iRubyObject, iRubyObject2, RubyString.newEmptyString(threadContext.getRuntime()));
        return iRubyObject3;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.succ_bang();
        return rubyString;
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        int n;
        if (this.value.length() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (n = this.value.length() - 1; n >= 0; --n) {
            n3 = this.value.get(n) & 0xFF;
            if (!RubyString.isAlnum(n3)) continue;
            bl = true;
            if (RubyString.isDigit(n3) && n3 < 57 || RubyString.isLower(n3) && n3 < 122 || RubyString.isUpper(n3) && n3 < 90) {
                this.value.set(n, (int)((byte)(n3 + 1)));
                n2 = -1;
                break;
            }
            n2 = n;
            int n5 = RubyString.isDigit(n3) ? 49 : (n4 = RubyString.isLower(n3) ? 97 : 65);
            this.value.set(n, (int)((byte)(RubyString.isDigit(n3) ? 48 : (RubyString.isLower(n3) ? 97 : 65))));
        }
        if (!bl) {
            for (n = this.value.length() - 1; n >= 0; --n) {
                n3 = this.value.get(n) & 0xFF;
                if (n3 < 255) {
                    this.value.set(n, (int)((byte)(n3 + 1)));
                    n2 = -1;
                    break;
                }
                n2 = n;
                n4 = 1;
                this.value.set(n, 0);
            }
        }
        if (n2 > -1) {
            this.value.insert(n2, (int)((byte)n4));
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.upto(threadContext, iRubyObject, false, block);
    }

    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl, Block block) {
        RubyString rubyString = iRubyObject.convertToString();
        int n = this.value.cmp(rubyString.value);
        if (n > 0 || bl && n == 0) {
            return this;
        }
        IRubyObject iRubyObject2 = rubyString.callMethod(threadContext, "succ");
        RubyString rubyString2 = this;
        while (!rubyString2.op_equal(threadContext, iRubyObject2).isTrue()) {
            block.yield(threadContext, rubyString2);
            if (!bl && rubyString2.op_equal(threadContext, rubyString).isTrue()) break;
            rubyString2 = rubyString2.callMethod(threadContext, "succ").convertToString();
            if ((!bl || !rubyString2.op_equal(threadContext, rubyString).isTrue()) && rubyString2.value.realSize <= rubyString.value.realSize && rubyString2.value.realSize != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            int n = RubyNumeric.fix2int(iRubyObject);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)n) continue;
                return threadContext.getRuntime().getTrue();
            }
            return threadContext.getRuntime().getFalse();
        }
        ByteList byteList = RubyString.stringValue((IRubyObject)iRubyObject).value;
        return threadContext.getRuntime().newBoolean(this.value.indexOf(byteList) != -1);
    }

    public IRubyObject to_i(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.to_i();
            }
            case 1: {
                return this.to_i(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 10);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(IRubyObject iRubyObject) {
        long l = iRubyObject.convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)l);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct(ThreadContext threadContext) {
        int n;
        int n2;
        if (this.isEmpty()) {
            return threadContext.getRuntime().newFixnum(0);
        }
        int n3 = 8;
        for (n2 = this.value.begin; n2 < this.value.begin + this.value.realSize && ASCII.isSpace(this.value.bytes[n2] & 0xFF); ++n2) {
        }
        int n4 = n = this.value.bytes[n2] == 45 || this.value.bytes[n2] == 43 ? n2 + 1 : n2;
        if (n + 1 < this.value.begin + this.value.realSize && this.value.bytes[n] == 48) {
            if (this.value.bytes[n + 1] == 120 || this.value.bytes[n + 1] == 88) {
                n3 = 16;
            } else if (this.value.bytes[n + 1] == 98 || this.value.bytes[n + 1] == 66) {
                n3 = 2;
            } else if (this.value.bytes[n + 1] == 100 || this.value.bytes[n + 1] == 68) {
                n3 = 10;
            }
        }
        return RubyNumeric.str2inum(threadContext.getRuntime(), this, n3);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex(ThreadContext threadContext) {
        return RubyNumeric.str2inum(threadContext.getRuntime(), this, 16);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    public RubyArray split(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.split(threadContext);
            }
            case 1: {
                return this.split(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.split(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 2);
        return null;
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext threadContext) {
        return this.split(threadContext, threadContext.getRuntime().getNil());
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.splitCommon(iRubyObject, false, 0, 0, threadContext);
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public RubyArray split(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.fix2int(iRubyObject2);
        if (n <= 0) {
            return this.splitCommon(iRubyObject, false, n, 1, threadContext);
        }
        if (n == 1) {
            return this.value.realSize == 0 ? threadContext.getRuntime().newArray() : threadContext.getRuntime().newArray(this);
        }
        return this.splitCommon(iRubyObject, true, n, 1, threadContext);
    }

    private RubyArray splitCommon(IRubyObject iRubyObject, boolean bl, int n, int n2, ThreadContext threadContext) {
        RubyArray rubyArray;
        if (iRubyObject.isNil() && (iRubyObject = threadContext.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            rubyArray = this.awkSplit(bl, n, n2);
        } else if (iRubyObject instanceof RubyString && ((RubyString)iRubyObject).value.realSize == 1) {
            RubyString rubyString = (RubyString)iRubyObject;
            rubyArray = rubyString.value.bytes[rubyString.value.begin] == 32 ? this.awkSplit(bl, n, n2) : this.split(threadContext, iRubyObject, bl, n, n2);
        } else {
            rubyArray = this.split(threadContext, iRubyObject, bl, n, n2);
        }
        if (!bl && n == 0) {
            while (rubyArray.size() > 0 && ((RubyString)rubyArray.eltInternal((int)(rubyArray.size() - 1))).value.realSize == 0) {
                rubyArray.pop();
            }
        }
        return rubyArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray split(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl, int n, int n2) {
        int n3;
        Ruby ruby = threadContext.getRuntime();
        Regex regex = this.getPattern(iRubyObject, true).getPattern();
        int n4 = n3 = this.value.begin;
        int n5 = 0;
        int n6 = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n6);
        boolean bl2 = false;
        RubyArray rubyArray = ruby.newArray();
        if (regex.numberOfCaptures() == 0) {
            int n7;
            while ((n7 = matcher.search(n4, n6, 0)) >= 0) {
                block17: {
                    if (n4 == n7 + n3 && matcher.getBegin() == matcher.getEnd()) {
                        if (this.value.realSize == 0) {
                            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                            break;
                        }
                        if (bl2) {
                            rubyArray.append(this.substr(ruby, n5, regex.getEncoding().length(this.value.bytes[n3 + n5])));
                            n5 = n4 - n3;
                            break block17;
                        } else {
                            n4 = n4 == n6 ? ++n4 : (n4 += regex.getEncoding().length(this.value.bytes[n4]));
                            bl2 = true;
                            continue;
                        }
                    }
                    rubyArray.append(this.substr(n5, n7 - n5));
                    n5 = matcher.getEnd();
                    n4 = n3 + matcher.getEnd();
                }
                bl2 = false;
                if (!bl || n > ++n2) continue;
                break;
            }
        } else {
            int n8;
            while ((n8 = matcher.search(n4, n6, 0)) >= 0) {
                Region region;
                block18: {
                    region = matcher.getRegion();
                    if (n4 == n8 + n3 && region.beg[0] == region.end[0]) {
                        if (this.value.realSize == 0) {
                            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                            break;
                        }
                        if (bl2) {
                            rubyArray.append(this.substr(n5, regex.getEncoding().length(this.value.bytes[n3 + n5])));
                            n5 = n4 - n3;
                            break block18;
                        } else {
                            n4 = n4 == n6 ? ++n4 : (n4 += regex.getEncoding().length(this.value.bytes[n4]));
                            bl2 = true;
                            continue;
                        }
                    }
                    rubyArray.append(this.substr(n5, n8 - n5));
                    n5 = n4 = region.end[0];
                    n4 += n3;
                }
                bl2 = false;
                for (int i = 1; i < region.numRegs; ++i) {
                    if (region.beg[i] == -1) continue;
                    if (region.beg[i] == region.end[i]) {
                        rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                        continue;
                    }
                    rubyArray.append(this.substr(region.beg[i], region.end[i] - region.beg[i]));
                }
                if (!bl || n > ++n2) continue;
            }
        }
        threadContext.getCurrentFrame().setBackRef(ruby.getNil());
        if (this.value.realSize <= 0) return rubyArray;
        if (!bl && this.value.realSize <= n5) {
            if (n >= 0) return rubyArray;
        }
        if (this.value.realSize == n5) {
            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
            return rubyArray;
        }
        rubyArray.append(this.substr(n5, this.value.realSize - n5));
        return rubyArray;
    }

    private RubyArray awkSplit(boolean bl, int n, int n2) {
        int n3;
        Ruby ruby = this.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        byte[] byArray = this.value.bytes;
        int n4 = n3 + this.value.realSize;
        boolean bl2 = true;
        int n5 = 0;
        n5 = 0;
        int n6 = 0;
        for (n3 = this.value.begin; n3 < n4; ++n3) {
            if (bl2) {
                if (ASCII.isSpace(byArray[n3] & 0xFF)) {
                    ++n5;
                    continue;
                }
                n6 = n5 + 1;
                bl2 = false;
                if (!bl || n > n2) continue;
                break;
            }
            if (ASCII.isSpace(byArray[n3] & 0xFF)) {
                rubyArray.append(this.makeShared(ruby, n5, n6 - n5));
                bl2 = true;
                n5 = n6 + 1;
                if (!bl) continue;
                ++n2;
                continue;
            }
            ++n6;
        }
        if (this.value.realSize > 0 && (bl || this.value.realSize > n5 || n < 0)) {
            if (this.value.realSize == n5) {
                rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
            } else {
                rubyArray.append(this.makeShared(ruby, n5, this.value.realSize - n5));
            }
        }
        return rubyArray;
    }

    private final RubyRegexp getPattern(IRubyObject iRubyObject, boolean bl) {
        if (iRubyObject instanceof RubyRegexp) {
            return (RubyRegexp)iRubyObject;
        }
        if (!(iRubyObject instanceof RubyString)) {
            IRubyObject iRubyObject2 = iRubyObject.checkStringType();
            if (iRubyObject2.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Regexp)");
            }
            iRubyObject = iRubyObject2;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), ((RubyString)iRubyObject).value, 0, bl);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = threadContext.getRuntime();
        Frame frame = threadContext.getPreviousFrame();
        RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
        Regex regex = rubyRegexp.getPattern();
        int n = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n);
        matcher.value = 0;
        if (!block.isGiven()) {
            RubyArray rubyArray = ruby.newArray();
            if (regex.numberOfCaptures() == 0) {
                IRubyObject iRubyObject2;
                while ((iRubyObject2 = this.scanOnceNG(rubyRegexp, matcher, n)) != null) {
                    rubyArray.append(iRubyObject2);
                }
            } else {
                IRubyObject iRubyObject3;
                while ((iRubyObject3 = this.scanOnce(rubyRegexp, matcher, n)) != null) {
                    rubyArray.append(iRubyObject3);
                }
            }
            if (rubyArray.size() > 0) {
                rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
            } else {
                frame.setBackRef(ruby.getNil());
            }
            return rubyArray;
        }
        byte[] byArray = this.value.bytes;
        int n2 = this.value.realSize;
        IRubyObject iRubyObject4 = null;
        if (regex.numberOfCaptures() == 0) {
            IRubyObject iRubyObject5;
            while ((iRubyObject5 = this.scanOnceNG(rubyRegexp, matcher, n)) != null) {
                iRubyObject4 = rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
                ((RubyMatchData)iRubyObject4).use();
                block.yield(threadContext, iRubyObject5);
                this.modifyCheck(byArray, n2);
            }
        } else {
            IRubyObject iRubyObject6;
            while ((iRubyObject6 = this.scanOnce(rubyRegexp, matcher, n)) != null) {
                iRubyObject4 = rubyRegexp.updateBackRef(threadContext, this, frame, matcher);
                ((RubyMatchData)iRubyObject4).use();
                block.yield(threadContext, iRubyObject6);
                this.modifyCheck(byArray, n2);
            }
        }
        frame.setBackRef(iRubyObject4 == null ? ruby.getNil() : iRubyObject4);
        return this;
    }

    private Encoding encodingCheck(RubyRegexp rubyRegexp) {
        return rubyRegexp.getKCode().getEncoding();
    }

    private IRubyObject scanOnceNG(RubyRegexp rubyRegexp, Matcher matcher, int n) {
        if (matcher.search(matcher.value + this.value.begin, n, 0) >= 0) {
            int n2 = matcher.getEnd();
            matcher.value = matcher.getBegin() == n2 ? (this.value.realSize > n2 ? n2 + rubyRegexp.getPattern().getEncoding().length(this.value.bytes[this.value.begin + n2]) : n2 + 1) : n2;
            return this.substr(matcher.getBegin(), n2 - matcher.getBegin()).infectBy(rubyRegexp);
        }
        return null;
    }

    private IRubyObject scanOnce(RubyRegexp rubyRegexp, Matcher matcher, int n) {
        if (matcher.search(matcher.value + this.value.begin, n, 0) >= 0) {
            Region region = matcher.getRegion();
            int n2 = region.end[0];
            matcher.value = region.beg[0] == n2 ? (this.value.realSize > n2 ? n2 + rubyRegexp.getPattern().getEncoding().length(this.value.bytes[this.value.begin + n2]) : n2 + 1) : n2;
            RubyArray rubyArray = this.getRuntime().newArray(region.numRegs);
            for (int i = 1; i < region.numRegs; ++i) {
                int n3 = region.beg[i];
                if (n3 == -1) {
                    rubyArray.append(this.getRuntime().getNil());
                    continue;
                }
                rubyArray.append(this.substr(n3, region.end[i] - n3).infectBy(rubyRegexp));
            }
            return rubyArray;
        }
        return null;
    }

    private final IRubyObject justify(IRubyObject iRubyObject, char c) {
        Ruby ruby = this.getRuntime();
        int n = RubyFixnum.num2int(iRubyObject);
        int n2 = 0;
        int n3 = RubyString.SPACE_BYTELIST.begin;
        n2 = RubyString.SPACE_BYTELIST.realSize;
        byte[] byArray = RubyString.SPACE_BYTELIST.bytes;
        IRubyObject iRubyObject2 = ruby.getNil();
        return this.justifyCommon(n, c, n2, byArray, n3, ruby, iRubyObject2);
    }

    private final IRubyObject justify(IRubyObject iRubyObject, IRubyObject iRubyObject2, char c) {
        Ruby ruby = this.getRuntime();
        int n = RubyFixnum.num2int(iRubyObject);
        int n2 = 0;
        RubyString rubyString = iRubyObject2.convertToString();
        ByteList byteList = rubyString.value;
        int n3 = byteList.begin;
        n2 = byteList.realSize;
        if (n2 == 0) {
            throw ruby.newArgumentError("zero width padding");
        }
        byte[] byArray = byteList.bytes;
        return this.justifyCommon(n, c, n2, byArray, n3, ruby, rubyString);
    }

    private IRubyObject justifyCommon(int n, char c, int n2, byte[] byArray, int n3, Ruby ruby, IRubyObject iRubyObject) {
        int n4;
        if (n < 0 || this.value.realSize >= n) {
            return this.strDup(ruby);
        }
        ByteList byteList = new ByteList(n);
        byteList.realSize = n;
        int n5 = byteList.begin;
        byte[] byArray2 = byteList.bytes;
        if (c != 'l') {
            int n6 = n - this.value.realSize;
            n4 = n5 + (c == 'r' ? n6 : n6 / 2);
            if (n2 <= 1) {
                while (n5 < n4) {
                    byArray2[n5++] = byArray[n3];
                }
            } else {
                int n7 = n3;
                while (n5 + n2 <= n4) {
                    System.arraycopy(byArray, n3, byArray2, n5, n2);
                    n5 += n2;
                }
                while (n5 < n4) {
                    byArray2[n5++] = byArray[n7++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, byArray2, n5, this.value.realSize);
        if (c != 'r') {
            n5 += this.value.realSize;
            n4 = byteList.begin + n;
            if (n2 <= 1) {
                while (n5 < n4) {
                    byArray2[n5++] = byArray[n3];
                }
            } else {
                while (n5 + n2 <= n4) {
                    System.arraycopy(byArray, n3, byArray2, n5, n2);
                    n5 += n2;
                }
                while (n5 < n4) {
                    byArray2[n5++] = byArray[n3++];
                }
            }
        }
        RubyString rubyString = new RubyString(ruby, this.getMetaClass(), byteList);
        rubyString.infectBy(this);
        if (n2 > 0) {
            rubyString.infectBy(iRubyObject);
        }
        return rubyString;
    }

    public IRubyObject ljust(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.ljust(iRubyObjectArray[0]);
            }
            case 2: {
                return this.ljust(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject iRubyObject) {
        return this.justify(iRubyObject, 'l');
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.justify(iRubyObject, iRubyObject2, 'l');
    }

    public IRubyObject rjust(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.rjust(iRubyObjectArray[0]);
            }
            case 2: {
                return this.rjust(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject iRubyObject) {
        return this.justify(iRubyObject, 'r');
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.justify(iRubyObject, iRubyObject2, 'r');
    }

    public IRubyObject center(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.center(iRubyObjectArray[0]);
            }
            case 2: {
                return this.center(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject iRubyObject) {
        return this.justify(iRubyObject, 'c');
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.justify(iRubyObject, iRubyObject2, 'c');
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.chop_bang();
        return rubyString;
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang() {
        int n = this.value.realSize - 1;
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + n] == 10 && n > 0 && this.value.bytes[this.value.begin + n - 1] == 13) {
            --n;
        }
        this.view(0, n);
        return this;
    }

    public RubyString chomp(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.chomp();
            }
            case 1: {
                return this.chomp(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod
    public RubyString chomp() {
        RubyString rubyString = this.strDup(this.getRuntime());
        rubyString.chomp_bang();
        return rubyString;
    }

    @JRubyMethod
    public RubyString chomp(IRubyObject iRubyObject) {
        RubyString rubyString = this.strDup(this.getRuntime());
        rubyString.chomp_bang(iRubyObject);
        return rubyString;
    }

    public IRubyObject chomp_bang(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.chomp_bang();
            }
            case 1: {
                return this.chomp_bang(iRubyObjectArray[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang() {
        int n = this.value.length();
        if (n == 0) {
            return this.getRuntime().getNil();
        }
        byte[] byArray = this.value.bytes;
        IRubyObject iRubyObject = this.getRuntime().getGlobalVariables().get("$/");
        if (iRubyObject == this.getRuntime().getGlobalVariables().getDefaultSeparator()) {
            int n2 = this.value.realSize;
            int n3 = this.value.begin;
            if (byArray[n3 + n - 1] == 10) {
                if (--n2 > 0 && byArray[n3 + n2 - 1] == 13) {
                    --n2;
                }
                this.view(0, n2);
            } else if (byArray[n3 + n - 1] == 13) {
                this.view(0, --n2);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        return this.chompBangCommon(iRubyObject);
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang(IRubyObject iRubyObject) {
        return this.chompBangCommon(iRubyObject);
    }

    private IRubyObject chompBangCommon(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return this.getRuntime().getNil();
        }
        RubyString rubyString = iRubyObject.convertToString();
        int n = this.value.realSize;
        int n2 = this.value.begin;
        if (n == 0) {
            return this.getRuntime().getNil();
        }
        byte[] byArray = this.value.bytes;
        int n3 = rubyString.value.realSize;
        if (n3 == 0) {
            while (n > 0 && byArray[n2 + n - 1] == 10) {
                if (--n <= 0 || byArray[n2 + n - 1] != 13) continue;
                --n;
            }
            if (n < this.value.realSize) {
                this.view(0, n);
                return this;
            }
            return this.getRuntime().getNil();
        }
        if (n3 > n) {
            return this.getRuntime().getNil();
        }
        byte by = rubyString.value.bytes[n3 - 1];
        if (n3 == 1 && by == 10) {
            byArray = this.value.bytes;
            int n4 = this.value.realSize;
            if (byArray[n2 + n - 1] == 10) {
                if (--n4 > 0 && byArray[n2 + n4 - 1] == 13) {
                    --n4;
                }
                this.view(0, n4);
            } else if (byArray[n2 + n - 1] == 13) {
                this.view(0, --n4);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        if (byArray[n2 + n - 1] == by && n3 <= 1 || this.value.endsWith(rubyString.value)) {
            this.view(0, this.value.realSize - n3);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject lstrip(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.lstrip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang() {
        int n;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (n = 0; n < this.value.realSize && ASCII.isSpace(this.value.bytes[this.value.begin + n] & 0xFF); ++n) {
        }
        if (n > 0) {
            this.view(n, this.value.realSize - n);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject rstrip(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.rstrip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang() {
        int n;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (n = this.value.realSize - 1; n >= 0 && this.value.bytes[this.value.begin + n] == 0; --n) {
        }
        while (n >= 0 && ASCII.isSpace(this.value.bytes[this.value.begin + n] & 0xFF)) {
            --n;
        }
        if (n < this.value.realSize - 1) {
            this.view(0, n + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject strip(ThreadContext threadContext) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.strip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang() {
        IRubyObject iRubyObject = this.lstrip_bang();
        IRubyObject iRubyObject2 = this.rstrip_bang();
        if (iRubyObject.isNil() && iRubyObject2.isNil()) {
            return iRubyObject;
        }
        return this;
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count(IRubyObject[] iRubyObjectArray) {
        int n;
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0);
        }
        boolean[] blArray = new boolean[256];
        boolean bl = true;
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            RubyString rubyString = iRubyObjectArray[n].convertToString();
            rubyString.setup_table(blArray, bl);
            bl = false;
        }
        n = this.value.begin;
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        int n3 = 0;
        while (n < n2) {
            if (!blArray[byArray[n++] & 0xFF]) continue;
            ++n3;
        }
        return this.getRuntime().newFixnum(n3);
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.delete_bang(iRubyObjectArray);
        return rubyString;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang(IRubyObject[] iRubyObjectArray) {
        int n;
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] blArray = new boolean[256];
        boolean bl = true;
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            RubyString rubyString = iRubyObjectArray[n].convertToString();
            rubyString.setup_table(blArray, bl);
            bl = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int n2 = n = this.value.begin;
        int n3 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl2 = false;
        while (n < n3) {
            if (blArray[byArray[n] & 0xFF]) {
                bl2 = true;
            } else {
                byArray[n2++] = byArray[n];
            }
            ++n;
        }
        this.value.realSize = n2 - this.value.begin;
        if (bl2) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"squeeze"}, rest=true)
    public IRubyObject squeeze(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.squeeze_bang(iRubyObjectArray);
        return rubyString;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true)
    public IRubyObject squeeze_bang(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        boolean[] blArray = new boolean[256];
        if (iRubyObjectArray.length == 0) {
            for (n2 = 0; n2 < 256; ++n2) {
                blArray[n2] = true;
            }
        } else {
            n2 = 1;
            for (n = 0; n < iRubyObjectArray.length; ++n) {
                RubyString rubyString = iRubyObjectArray[n].convertToString();
                rubyString.setup_table(blArray, n2 != 0);
                n2 = 0;
            }
        }
        this.modify();
        n = n2 = this.value.begin;
        int n3 = n2 + this.value.realSize;
        byte[] byArray = this.value.bytes;
        int n4 = -1;
        while (n2 < n3) {
            int n5;
            if ((n5 = byArray[n2++] & 0xFF) == n4 && blArray[n5]) continue;
            int n6 = n++;
            n4 = n5;
            byArray[n6] = (byte)n4;
        }
        if (n - this.value.begin != this.value.realSize) {
            this.value.realSize = n - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject tr(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.tr_trans(iRubyObject, iRubyObject2, false);
        return rubyString;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.tr_trans(iRubyObject, iRubyObject2, false);
    }

    private final void setup_table(boolean[] blArray, boolean bl) {
        int n;
        int n2;
        boolean[] blArray2 = new boolean[256];
        TR tR = new TR();
        boolean bl2 = false;
        tR.p = this.value.begin;
        tR.pend = this.value.begin + this.value.realSize;
        tR.buf = this.value.bytes;
        tR.max = 0;
        tR.now = 0;
        tR.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            bl2 = true;
            ++tR.p;
        }
        if (bl) {
            for (n2 = 0; n2 < 256; ++n2) {
                blArray[n2] = true;
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            blArray2[n2] = bl2;
        }
        while ((n = this.trnext(tR)) >= 0) {
            blArray2[n & 0xFF] = !bl2;
        }
        for (n2 = 0; n2 < 256; ++n2) {
            blArray[n2] = blArray[n2] && blArray2[n2];
        }
    }

    private final IRubyObject tr_trans(IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        int n;
        int n2;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList byteList = iRubyObject2.convertToString().value;
        if (byteList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{iRubyObject});
        }
        ByteList byteList2 = iRubyObject.convertToString().value;
        TR tR = new TR();
        TR tR2 = new TR();
        boolean bl2 = false;
        boolean bl3 = false;
        tR.p = byteList2.begin;
        tR.pend = byteList2.begin + byteList2.realSize;
        tR.buf = byteList2.bytes;
        if (byteList2.realSize >= 2 && byteList2.bytes[byteList2.begin] == 94) {
            bl2 = true;
            ++tR.p;
        }
        tR2.p = byteList.begin;
        tR2.pend = byteList.begin + byteList.realSize;
        tR2.buf = byteList.bytes;
        tR2.gen = 0;
        tR.gen = 0;
        tR2.now = 0;
        tR.now = 0;
        tR2.max = 0;
        tR.max = 0;
        int[] nArray = new int[256];
        if (bl2) {
            for (n2 = 0; n2 < 256; ++n2) {
                nArray[n2] = 1;
            }
            while ((n = this.trnext(tR)) >= 0) {
                nArray[n & 0xFF] = -1;
            }
            while ((n = this.trnext(tR2)) >= 0) {
            }
            for (n2 = 0; n2 < 256; ++n2) {
                if (nArray[n2] < 0) continue;
                nArray[n2] = tR2.now;
            }
        } else {
            for (n2 = 0; n2 < 256; ++n2) {
                nArray[n2] = -1;
            }
            while ((n = this.trnext(tR)) >= 0) {
                n2 = this.trnext(tR2);
                if (n2 == -1) {
                    n2 = tR2.now;
                }
                nArray[n & 0xFF] = n2;
            }
        }
        this.modify();
        int n3 = n2 + this.value.realSize;
        byte[] byArray = this.value.bytes;
        if (bl) {
            int n4 = n2;
            int n5 = -1;
            while (n2 < n3) {
                byte by;
                if ((n = nArray[(by = byArray[n2++]) & 0xFF]) >= 0) {
                    if (n5 == n) continue;
                    n5 = n;
                    byArray[n4++] = (byte)(n & 0xFF);
                    bl3 = true;
                    continue;
                }
                n5 = -1;
                byArray[n4++] = by;
            }
            if (this.value.realSize > n4 - this.value.begin) {
                this.value.realSize = n4 - this.value.begin;
                bl3 = true;
            }
        } else {
            for (n2 = this.value.begin; n2 < n3; ++n2) {
                n = nArray[byArray[n2] & 0xFF];
                if (n < 0) continue;
                byArray[n2] = (byte)(n & 0xFF);
                bl3 = true;
            }
        }
        if (bl3) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR tR) {
        byte[] byArray = tR.buf;
        while (tR.gen == 0) {
            if (tR.p == tR.pend) {
                return -1;
            }
            if (tR.p < tR.pend - 1 && byArray[tR.p] == 92) {
                ++tR.p;
            }
            tR.now = byArray[tR.p++];
            if (tR.p < tR.pend - 1 && byArray[tR.p] == 45) {
                ++tR.p;
                if (tR.p < tR.pend) {
                    if (tR.now > (byArray[tR.p] & 0xFF)) {
                        ++tR.p;
                        continue;
                    }
                    tR.gen = 1;
                    tR.max = byArray[tR.p++] & 0xFF;
                }
            }
            return tR.now & 0xFF;
        }
        if (++tR.now < tR.max) {
            return tR.now & 0xFF;
        }
        tR.gen = 0;
        return tR.max & 0xFF;
    }

    @JRubyMethod
    public IRubyObject tr_s(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = this.strDup(threadContext.getRuntime());
        rubyString.tr_trans(iRubyObject, iRubyObject2, true);
        return rubyString;
    }

    @JRubyMethod(name={"tr_s!"})
    public IRubyObject tr_s_bang(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.tr_trans(iRubyObject, iRubyObject2, true);
    }

    @JRubyMethod(name={"each_line", "each"}, required=0, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString;
        int n = this.value.begin;
        int n2 = n + this.value.realSize;
        int n3 = n;
        int n4 = this.value.realSize;
        IRubyObject iRubyObject = iRubyObjectArray.length == 0 ? this.getRuntime().getGlobalVariables().get("$/") : iRubyObjectArray[0];
        if (iRubyObject.isNil()) {
            block.yield(threadContext, this);
            return this;
        }
        RubyString rubyString2 = RubyString.stringValue(iRubyObject);
        ByteList byteList = rubyString2.value;
        byte[] byArray = this.value.bytes;
        int n5 = byteList.realSize;
        byte by = n5 == 0 ? (byte)10 : byteList.bytes[byteList.begin + n5 - 1];
        int n6 = n;
        n += n5;
        while (n < n2) {
            if (n5 == 0 && byArray[n] == 10) {
                if (byArray[++n] == 10) {
                    while (n < n2 && byArray[n] == 10) {
                        ++n;
                    }
                }
            } else if (n3 < n && byArray[n - 1] == by && (n5 <= 1 || ByteList.memcmp((byte[])byteList.bytes, (int)byteList.begin, (int)n5, (byte[])byArray, (int)(n - n5), (int)n5) == 0)) {
                rubyString = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(n6 - n3, n - n6));
                rubyString.infectBy(this);
                block.yield(threadContext, rubyString);
                this.modifyCheck(byArray, n4);
                n6 = n;
            }
            ++n;
        }
        if (n6 != n2) {
            if (n > n2) {
                n = n2;
            }
            rubyString = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(n6 - n3, n - n6));
            rubyString.infectBy(this);
            block.yield(threadContext, rubyString);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public RubyString each_byte(ThreadContext threadContext, Block block) {
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(threadContext, ruby.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    public RubySymbol intern() {
        String string = this.toString();
        if (string.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (string.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.getRuntime().newSymbol(string);
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol to_sym() {
        return this.intern();
    }

    @JRubyMethod(name={"sum"}, optional=1)
    public RubyInteger sum(IRubyObject[] iRubyObjectArray) {
        long l;
        if (iRubyObjectArray.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 1)");
        }
        long l2 = 16L;
        if (iRubyObjectArray.length == 1 && (l = iRubyObjectArray[0].convertToInteger().getLongValue()) > 0L) {
            l2 = l;
        }
        l = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            l += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(l2 == 0L ? l : l % (long)Math.pow(2.0, l2));
    }

    @JRubyMethod(name={"to_c"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        Frame frame = threadContext.getCurrentFrame();
        IRubyObject iRubyObject = frame.getBackRef();
        if (iRubyObject != null && iRubyObject instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject).use();
        }
        IRubyObject iRubyObject2 = RuntimeHelpers.invoke(threadContext, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newRegexp(ruby, Numeric.ComplexPatterns.underscores_pat), ruby.newString(new ByteList(new byte[]{95})));
        RubyArray rubyArray = RubyComplex.str_to_c_internal(threadContext, iRubyObject2);
        frame.setBackRef(iRubyObject);
        if (!rubyArray.eltInternal(0).isNil()) {
            return rubyArray.eltInternal(0);
        }
        return RubyComplex.newComplexCanonicalize(threadContext, RubyFixnum.zero(ruby));
    }

    @JRubyMethod(name={"to_r"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        Frame frame = threadContext.getCurrentFrame();
        IRubyObject iRubyObject = frame.getBackRef();
        if (iRubyObject != null && iRubyObject instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject).use();
        }
        IRubyObject iRubyObject2 = RuntimeHelpers.invoke(threadContext, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newRegexp(ruby, Numeric.ComplexPatterns.underscores_pat), ruby.newString(new ByteList(new byte[]{95})));
        RubyArray rubyArray = RubyRational.str_to_r_internal(threadContext, iRubyObject2);
        frame.setBackRef(iRubyObject);
        if (!rubyArray.eltInternal(0).isNil()) {
            return rubyArray.eltInternal(0);
        }
        return RubyRational.newRationalCanonicalize(threadContext, RubyFixnum.zero(ruby));
    }

    public static RubyString unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubyString rubyString = RubyString.newString(unmarshalStream.getRuntime(), unmarshalStream.unmarshalString());
        unmarshalStream.registerLinkTarget(rubyString);
        return rubyString;
    }

    @JRubyMethod
    public RubyArray unpack(IRubyObject iRubyObject) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)iRubyObject).value);
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    public void setValue(CharSequence charSequence) {
        this.view(ByteList.plain((CharSequence)charSequence));
    }

    public void setValue(ByteList byteList) {
        this.view(byteList);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Something's seriously broken with encodings", exception);
        }
    }

    public IRubyObject to_java() {
        return MiniJava.javaToRuby(this.getRuntime(), new String(this.getBytes()));
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }
}

