/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyThread;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"ThreadGroup"})
public class RubyThreadGroup
extends RubyObject {
    private Map<Integer, IRubyObject> rubyThreadList = new HashMap<Integer, IRubyObject>();
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("ThreadGroup", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setThreadGroup(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyThreadGroup.class);
        RubyThreadGroup rubyThreadGroup = new RubyThreadGroup(ruby, rubyClass);
        ruby.setDefaultThreadGroup(rubyThreadGroup);
        rubyClass.defineConstant("Default", rubyThreadGroup);
        return rubyClass;
    }

    @JRubyMethod(name={"new"}, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, Block block) {
        return new RubyThreadGroup(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
    }

    @JRubyMethod(name={"add"}, required=1, frame=true)
    public synchronized IRubyObject add(IRubyObject iRubyObject, Block block) {
        if (!(iRubyObject instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getThread());
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to frozen ThreadGroup");
        }
        RubyThread rubyThread = (RubyThread)iRubyObject;
        if (rubyThread.alive_p().isTrue()) {
            this.addDirectly(rubyThread);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectly(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            IRubyObject iRubyObject = rubyThread.group();
            if (iRubyObject != this.getRuntime().getNil()) {
                RubyThreadGroup rubyThreadGroup = (RubyThreadGroup)iRubyObject;
                rubyThreadGroup.rubyThreadList.remove(System.identityHashCode(rubyThread));
            }
            rubyThread.setThreadGroup(this);
            this.rubyThreadList.put(System.identityHashCode(rubyThread), rubyThread);
        }
    }

    public synchronized void remove(RubyThread rubyThread) {
        rubyThread.setThreadGroup(null);
        this.rubyThreadList.remove(System.identityHashCode(rubyThread));
    }

    @JRubyMethod(name={"enclose"}, frame=true)
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"}, frame=true)
    public IRubyObject enclosed_p(Block block) {
        return new RubyBoolean(this.getRuntime(), this.enclosed);
    }

    @JRubyMethod(name={"list"}, frame=true)
    public synchronized IRubyObject list(Block block) {
        return this.getRuntime().newArrayNoCopy(this.rubyThreadList.values().toArray(new IRubyObject[this.rubyThreadList.size()]));
    }

    private RubyThreadGroup(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }
}

