/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyException;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyKernel;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubyStringIO;
import org.jruby.nb.nb.nb.anno.FrameField;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.Adler32Ext;
import org.jruby.nb.nb.nb.util.CRC32Ext;
import org.jruby.nb.nb.nb.util.IOInputStream;
import org.jruby.nb.nb.nb.util.IOOutputStream;
import org.jruby.nb.nb.nb.util.ZlibDeflate;
import org.jruby.nb.nb.nb.util.ZlibInflate;
import org.jruby.util.ByteList;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    private static final long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static RubyModule createZlibModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Zlib");
        RubyClass rubyClass = rubyModule.defineClassUnder("GzipFile", ruby.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyGzipFile.class);
        RubyClass rubyClass2 = rubyModule.defineClassUnder("GzipReader", rubyClass, RubyGzipReader.GZIPREADER_ALLOCATOR);
        rubyClass2.includeModule(ruby.getEnumerable());
        rubyClass2.defineAnnotatedMethods(RubyGzipReader.class);
        RubyClass rubyClass3 = ruby.getStandardError();
        RubyClass rubyClass4 = rubyModule.defineClassUnder("Error", rubyClass3, rubyClass3.getAllocator());
        rubyClass2.defineClassUnder("Error", rubyClass4, rubyClass4.getAllocator());
        RubyClass rubyClass5 = rubyModule.defineClassUnder("GzipWriter", rubyClass, RubyGzipWriter.GZIPWRITER_ALLOCATOR);
        rubyClass5.defineAnnotatedMethods(RubyGzipWriter.class);
        rubyModule.defineConstant("ZLIB_VERSION", ruby.newString("1.2.1"));
        rubyModule.defineConstant("VERSION", ruby.newString("0.6.0"));
        rubyModule.defineConstant("BINARY", ruby.newFixnum(0));
        rubyModule.defineConstant("ASCII", ruby.newFixnum(1));
        rubyModule.defineConstant("UNKNOWN", ruby.newFixnum(2));
        rubyModule.defineConstant("DEF_MEM_LEVEL", ruby.newFixnum(8));
        rubyModule.defineConstant("MAX_MEM_LEVEL", ruby.newFixnum(9));
        rubyModule.defineConstant("OS_UNIX", ruby.newFixnum(3));
        rubyModule.defineConstant("OS_UNKNOWN", ruby.newFixnum(255));
        rubyModule.defineConstant("OS_CODE", ruby.newFixnum(11));
        rubyModule.defineConstant("OS_ZSYSTEM", ruby.newFixnum(8));
        rubyModule.defineConstant("OS_VMCMS", ruby.newFixnum(4));
        rubyModule.defineConstant("OS_VMS", ruby.newFixnum(2));
        rubyModule.defineConstant("OS_RISCOS", ruby.newFixnum(13));
        rubyModule.defineConstant("OS_MACOS", ruby.newFixnum(7));
        rubyModule.defineConstant("OS_OS2", ruby.newFixnum(6));
        rubyModule.defineConstant("OS_AMIGA", ruby.newFixnum(1));
        rubyModule.defineConstant("OS_QDOS", ruby.newFixnum(12));
        rubyModule.defineConstant("OS_WIN32", ruby.newFixnum(11));
        rubyModule.defineConstant("OS_ATARI", ruby.newFixnum(5));
        rubyModule.defineConstant("OS_MSDOS", ruby.newFixnum(0));
        rubyModule.defineConstant("OS_CPM", ruby.newFixnum(9));
        rubyModule.defineConstant("OS_TOPS20", ruby.newFixnum(10));
        rubyModule.defineConstant("DEFAULT_STRATEGY", ruby.newFixnum(0));
        rubyModule.defineConstant("FILTERED", ruby.newFixnum(1));
        rubyModule.defineConstant("HUFFMAN_ONLY", ruby.newFixnum(2));
        rubyModule.defineConstant("NO_FLUSH", ruby.newFixnum(0));
        rubyModule.defineConstant("SYNC_FLUSH", ruby.newFixnum(2));
        rubyModule.defineConstant("FULL_FLUSH", ruby.newFixnum(3));
        rubyModule.defineConstant("FINISH", ruby.newFixnum(4));
        rubyModule.defineConstant("NO_COMPRESSION", ruby.newFixnum(0));
        rubyModule.defineConstant("BEST_SPEED", ruby.newFixnum(1));
        rubyModule.defineConstant("DEFAULT_COMPRESSION", ruby.newFixnum(-1));
        rubyModule.defineConstant("BEST_COMPRESSION", ruby.newFixnum(9));
        rubyModule.defineConstant("MAX_WBITS", ruby.newFixnum(15));
        rubyModule.defineAnnotatedMethods(RubyZlib.class);
        rubyModule.defineClassUnder("StreamEnd", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("StreamError", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("BufError", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("NeedDict", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("MemError", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("VersionError", rubyClass4, rubyClass4.getAllocator());
        rubyModule.defineClassUnder("DataError", rubyClass4, rubyClass4.getAllocator());
        RubyClass rubyClass6 = rubyClass.defineClassUnder("Error", rubyClass4, rubyClass4.getAllocator());
        rubyClass.defineClassUnder("CRCError", rubyClass6, rubyClass6.getAllocator());
        rubyClass.defineClassUnder("NoFooter", rubyClass6, rubyClass6.getAllocator());
        rubyClass.defineClassUnder("LengthError", rubyClass6, rubyClass6.getAllocator());
        RubyClass rubyClass7 = rubyModule.defineClassUnder("ZStream", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass7.defineAnnotatedMethods(ZStream.class);
        rubyClass7.undefineMethod("new");
        RubyClass rubyClass8 = rubyModule.defineClassUnder("Inflate", rubyClass7, Inflate.INFLATE_ALLOCATOR);
        rubyClass8.defineAnnotatedMethods(Inflate.class);
        RubyClass rubyClass9 = rubyModule.defineClassUnder("Deflate", rubyClass7, Deflate.DEFLATE_ALLOCATOR);
        rubyClass9.defineAnnotatedMethods(Deflate.class);
        ruby.getKernel().callMethod(ruby.getCurrentContext(), "require", ruby.newString("stringio"));
        return rubyModule;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject iRubyObject) {
        return ((RubyModule)iRubyObject).fastGetConstant("ZLIB_VERSION");
    }

    @JRubyMethod(name={"version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject version(IRubyObject iRubyObject) {
        return ((RubyModule)iRubyObject).fastGetConstant("VERSION");
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
        iRubyObjectArray = Arity.scanArgs(iRubyObject.getRuntime(), iRubyObjectArray, 0, 2);
        long l = 0L;
        ByteList byteList = null;
        if (!iRubyObjectArray[0].isNil()) {
            byteList = iRubyObjectArray[0].convertToString().getByteList();
        }
        if (!iRubyObjectArray[1].isNil()) {
            l = RubyNumeric.num2long(iRubyObjectArray[1]);
        }
        CRC32Ext cRC32Ext = new CRC32Ext((int)l);
        if (byteList != null) {
            cRC32Ext.update(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return iRubyObject.getRuntime().newFixnum(cRC32Ext.getValue());
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
        iRubyObjectArray = Arity.scanArgs(iRubyObject.getRuntime(), iRubyObjectArray, 0, 2);
        int n = 1;
        ByteList byteList = null;
        if (!iRubyObjectArray[0].isNil()) {
            byteList = iRubyObjectArray[0].convertToString().getByteList();
        }
        if (!iRubyObjectArray[1].isNil()) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1]);
        }
        Adler32Ext adler32Ext = new Adler32Ext(n);
        if (byteList != null) {
            adler32Ext.update(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return iRubyObject.getRuntime().newFixnum(adler32Ext.getValue());
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject iRubyObject) {
        ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>(crctab.length);
        for (int i = 0; i < crctab.length; ++i) {
            arrayList.add(iRubyObject.getRuntime().newFixnum(crctab[i]));
        }
        return iRubyObject.getRuntime().newArray(arrayList);
    }

    @JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
    public static class RubyGzipWriter
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPWRITER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyGzipWriter(ruby, rubyClass);
            }
        };
        private GZIPOutputStream io;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static RubyGzipWriter newGzipWriter(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            RubyGzipWriter rubyGzipWriter = (RubyGzipWriter)rubyClass.allocate();
            rubyGzipWriter.callInit(iRubyObjectArray, block);
            return rubyGzipWriter;
        }

        @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
        public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) throws IOException {
            Ruby ruby = iRubyObject.getRuntime();
            IRubyObject iRubyObject2 = ruby.getNil();
            IRubyObject iRubyObject3 = ruby.getNil();
            if (iRubyObjectArray.length > 1) {
                iRubyObject2 = iRubyObjectArray[1];
                if (iRubyObjectArray.length > 2) {
                    iRubyObject3 = iRubyObjectArray[2];
                }
            }
            IRubyObject iRubyObject4 = RuntimeHelpers.invoke(threadContext, (IRubyObject)ruby.getFile(), "open", iRubyObjectArray[0], ruby.newString("wb"));
            RubyGzipWriter rubyGzipWriter = RubyGzipWriter.newGzipWriter(iRubyObject, new IRubyObject[]{iRubyObject4, iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
            return RubyGzipFile.wrap(threadContext, (RubyGzipFile)rubyGzipWriter, iRubyObject4, block);
        }

        public RubyGzipWriter(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"initialize"}, required=1, rest=true, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize2(IRubyObject[] iRubyObjectArray, Block block) throws IOException {
            this.realIo = (RubyObject)iRubyObjectArray[0];
            this.io = new GZIPOutputStream(new IOOutputStream(iRubyObjectArray[0]));
            return this;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() throws IOException {
            if (!this.closed) {
                this.io.close();
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"append"}, required=1)
        public IRubyObject append(IRubyObject iRubyObject) throws IOException {
            this.write(iRubyObject);
            return this;
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public IRubyObject printf(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) throws IOException {
            this.write(RubyKernel.sprintf(threadContext, this, iRubyObjectArray));
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(name={"print"}, rest=true)
        public IRubyObject print(IRubyObject[] iRubyObjectArray) throws IOException {
            IRubyObject iRubyObject;
            if (iRubyObjectArray.length != 0) {
                int n = iRubyObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(iRubyObjectArray[i]);
                }
            }
            if (!(iRubyObject = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
                this.write(iRubyObject);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"pos"})
        public IRubyObject pos() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"orig_name="}, required=1)
        public IRubyObject set_orig_name(IRubyObject iRubyObject) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"comment="}, required=1)
        public IRubyObject set_comment(IRubyObject iRubyObject) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"putc"}, required=1)
        public IRubyObject putc(IRubyObject iRubyObject) throws IOException {
            this.io.write(RubyNumeric.fix2int(iRubyObject));
            return iRubyObject;
        }

        @JRubyMethod(name={"puts"}, rest=true)
        public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) throws IOException {
            RubyStringIO rubyStringIO = (RubyStringIO)this.getRuntime().fastGetClass("StringIO").newInstance(threadContext, new IRubyObject[0], Block.NULL_BLOCK);
            rubyStringIO.puts(threadContext, iRubyObjectArray);
            this.write(rubyStringIO.string());
            return this.getRuntime().getNil();
        }

        public IRubyObject finish() throws IOException {
            if (!this.finished) {
                this.io.finish();
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] iRubyObjectArray) throws IOException {
            if (iRubyObjectArray.length == 0 || iRubyObjectArray[0].isNil() || RubyNumeric.fix2int(iRubyObjectArray[0]) != 0) {
                this.io.flush();
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"mtime="}, required=1)
        public IRubyObject set_mtime(IRubyObject iRubyObject) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"tell"})
        public IRubyObject tell() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"write"}, required=1)
        public IRubyObject write(IRubyObject iRubyObject) throws IOException {
            ByteList byteList = iRubyObject.convertToString().getByteList();
            this.io.write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            return this.getRuntime().newFixnum(byteList.length());
        }
    }

    @JRubyClass(name={"Zlib::GzipReader"}, parent="Zlib::GzipFile", include={"Enumerable"})
    public static class RubyGzipReader
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPREADER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyGzipReader(ruby, rubyClass);
            }
        };
        private int line;
        private InputStream io;
        private static final int BUFF_SIZE = 4096;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static RubyGzipReader newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            RubyGzipReader rubyGzipReader = (RubyGzipReader)rubyClass.allocate();
            rubyGzipReader.callInit(iRubyObjectArray, block);
            return rubyGzipReader;
        }

        @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
        public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) throws IOException {
            Ruby ruby = iRubyObject.getRuntime();
            IRubyObject iRubyObject3 = RuntimeHelpers.invoke(threadContext, (IRubyObject)ruby.getFile(), "open", iRubyObject2, ruby.newString("rb"));
            RubyGzipReader rubyGzipReader = RubyGzipReader.newInstance(iRubyObject, new IRubyObject[]{iRubyObject3}, Block.NULL_BLOCK);
            return RubyGzipFile.wrap(threadContext, (RubyGzipFile)rubyGzipReader, iRubyObject3, block);
        }

        public RubyGzipReader(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(IRubyObject iRubyObject, Block block) {
            this.realIo = iRubyObject;
            try {
                this.io = new GZIPInputStream(new IOInputStream(iRubyObject));
            }
            catch (IOException iOException) {
                Ruby ruby = iRubyObject.getRuntime();
                RubyClass rubyClass = ruby.fastGetModule("Zlib").fastGetClass("GzipReader").fastGetClass("Error");
                throw new RaiseException(RubyException.newException(ruby, rubyClass, iOException.getMessage()));
            }
            this.line = 1;
            return this;
        }

        @JRubyMethod(name={"rewind"})
        public IRubyObject rewind() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"lineno"})
        public IRubyObject lineno() {
            return this.getRuntime().newFixnum(this.line);
        }

        @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
        public IRubyObject readline(ThreadContext threadContext) throws IOException {
            IRubyObject iRubyObject = this.gets(threadContext, new IRubyObject[0]);
            if (iRubyObject.isNil()) {
                throw this.getRuntime().newEOFError();
            }
            return iRubyObject;
        }

        public IRubyObject internalGets(IRubyObject[] iRubyObjectArray) throws IOException {
            ByteList byteList = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (iRubyObjectArray.length > 0) {
                byteList = iRubyObjectArray[0].convertToString().getByteList();
            }
            return this.internalSepGets(byteList);
        }

        private IRubyObject internalSepGets(ByteList byteList) throws IOException {
            ByteList byteList2 = new ByteList();
            int n = this.io.read();
            while (n != -1 && byteList.indexOf(n) == -1) {
                byteList2.append((byte)n);
                n = this.io.read();
            }
            ++this.line;
            byteList2.append(byteList);
            return RubyString.newString(this.getRuntime(), byteList2);
        }

        @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
        public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) throws IOException {
            IRubyObject iRubyObject = this.internalGets(iRubyObjectArray);
            if (!iRubyObject.isNil()) {
                threadContext.getCurrentFrame().setLastLine(iRubyObject);
            }
            return iRubyObject;
        }

        @JRubyMethod(name={"read"}, optional=1)
        public IRubyObject read(IRubyObject[] iRubyObjectArray) throws IOException {
            if (iRubyObjectArray.length == 0 || iRubyObjectArray[0].isNil()) {
                ByteList byteList = new ByteList(10);
                byte[] byArray = new byte[4096];
                int n = this.io.read(byArray);
                while (n != -1) {
                    byteList.append(byArray, 0, n);
                    n = this.io.read(byArray);
                }
                return RubyString.newString(this.getRuntime(), byteList);
            }
            int n = RubyNumeric.fix2int(iRubyObjectArray[0]);
            if (n < 0) {
                throw this.getRuntime().newArgumentError("negative length " + n + " given");
            }
            if (n > 0) {
                byte[] byArray = new byte[n];
                int n2 = n;
                int n3 = 0;
                int n4 = 0;
                while (n2 > 0 && (n4 = this.io.read(byArray, n3, n2)) != -1) {
                    n2 -= n4;
                    n3 += n4;
                }
                return RubyString.newString(this.getRuntime(), new ByteList(byArray, 0, n - n2, false));
            }
            return RubyString.newEmptyString(this.getRuntime());
        }

        @JRubyMethod(name={"lineno="}, required=1)
        public IRubyObject set_lineno(IRubyObject iRubyObject) {
            this.line = RubyNumeric.fix2int(iRubyObject);
            return iRubyObject;
        }

        @JRubyMethod(name={"pos"})
        public IRubyObject pos() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"readchar"})
        public IRubyObject readchar() throws IOException {
            int n = this.io.read();
            if (n == -1) {
                throw this.getRuntime().newEOFError();
            }
            return this.getRuntime().newFixnum(n);
        }

        @JRubyMethod(name={"getc"})
        public IRubyObject getc() throws IOException {
            int n = this.io.read();
            return n == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(n);
        }

        private boolean isEof() throws IOException {
            return ((GZIPInputStream)this.io).available() != 1;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() throws IOException {
            if (!this.closed) {
                this.io.close();
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"eof"})
        public IRubyObject eof() throws IOException {
            return this.isEof() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"eof?"})
        public IRubyObject eof_p() throws IOException {
            return this.eof();
        }

        @JRubyMethod(name={"unused"})
        public IRubyObject unused() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"tell"})
        public IRubyObject tell() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"each"}, optional=1, frame=true)
        public IRubyObject each(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) throws IOException {
            ByteList byteList = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil()) {
                byteList = iRubyObjectArray[0].convertToString().getByteList();
            }
            while (!this.isEof()) {
                block.yield(threadContext, this.internalSepGets(byteList));
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"ungetc"}, required=1)
        public IRubyObject ungetc(IRubyObject iRubyObject) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"readlines"}, optional=1)
        public IRubyObject readlines(IRubyObject[] iRubyObjectArray) throws IOException {
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            if (iRubyObjectArray.length != 0 && iRubyObjectArray[0].isNil()) {
                arrayList.add(this.read(new IRubyObject[0]));
            } else {
                ByteList byteList = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
                if (iRubyObjectArray.length > 0) {
                    byteList = iRubyObjectArray[0].convertToString().getByteList();
                }
                while (!this.isEof()) {
                    arrayList.add(this.internalSepGets(byteList));
                }
            }
            return this.getRuntime().newArray(arrayList);
        }

        @JRubyMethod(name={"each_byte"}, frame=true)
        public IRubyObject each_byte(ThreadContext threadContext, Block block) throws IOException {
            int n = this.io.read();
            while (n != -1) {
                block.yield(threadContext, this.getRuntime().newFixnum(n));
                n = this.io.read();
            }
            return this.getRuntime().getNil();
        }

        @JRubyClass(name={"Zlib::GzipReader::Error"}, parent="Zlib::GzipReader")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::GzipFile"})
    public static class RubyGzipFile
    extends RubyObject {
        protected static final ObjectAllocator GZIPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyGzipFile(ruby, rubyClass);
            }
        };
        protected boolean closed = false;
        protected boolean finished = false;
        private int os_code = 255;
        private int level = -1;
        private String orig_name;
        private String comment;
        protected IRubyObject realIo;
        private IRubyObject mtime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IRubyObject wrap(ThreadContext threadContext, RubyGzipFile rubyGzipFile, IRubyObject iRubyObject, Block block) throws IOException {
            if (block.isGiven()) {
                IRubyObject iRubyObject2;
                block4: {
                    try {
                        block.yield(threadContext, rubyGzipFile);
                        iRubyObject2 = rubyGzipFile.getRuntime().getNil();
                        Object var6_5 = null;
                        if (rubyGzipFile.isClosed()) break block4;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!rubyGzipFile.isClosed()) {
                            rubyGzipFile.close();
                        }
                        throw throwable;
                    }
                    rubyGzipFile.close();
                }
                return iRubyObject2;
            }
            return iRubyObject;
        }

        @JRubyMethod(name={"wrap"}, required=1, frame=true, meta=true)
        public static IRubyObject wrap(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) throws IOException {
            Ruby ruby = iRubyObject.getRuntime();
            RubyGzipFile rubyGzipFile = iRubyObject == ruby.getModule("Zlib").getClass("GzipWriter") ? RubyGzipWriter.newGzipWriter(iRubyObject, new IRubyObject[]{iRubyObject2}, block) : RubyGzipReader.newInstance(iRubyObject, new IRubyObject[]{iRubyObject2}, block);
            return RubyGzipFile.wrap(threadContext, rubyGzipFile, iRubyObject2, block);
        }

        @JRubyMethod(name={"new"}, frame=true, meta=true)
        public static RubyGzipFile newInstance(IRubyObject iRubyObject, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            RubyGzipFile rubyGzipFile = (RubyGzipFile)rubyClass.allocate();
            rubyGzipFile.callInit(new IRubyObject[0], block);
            return rubyGzipFile;
        }

        public RubyGzipFile(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
            this.mtime = ruby.getNil();
        }

        @JRubyMethod(name={"os_code"})
        public IRubyObject os_code() {
            return this.getRuntime().newFixnum(this.os_code);
        }

        @JRubyMethod(name={"closed?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected boolean isClosed() {
            return this.closed;
        }

        @JRubyMethod(name={"orig_name"})
        public IRubyObject orig_name() {
            return this.orig_name == null ? this.getRuntime().getNil() : this.getRuntime().newString(this.orig_name);
        }

        @JRubyMethod(name={"to_io"})
        public IRubyObject to_io() {
            return this.realIo;
        }

        @JRubyMethod(name={"comment"})
        public IRubyObject comment() {
            return this.comment == null ? this.getRuntime().getNil() : this.getRuntime().newString(this.comment);
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"mtime"})
        public IRubyObject mtime() {
            return this.mtime;
        }

        @JRubyMethod(name={"sync"})
        public IRubyObject sync() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"finish"})
        public IRubyObject finish() throws IOException {
            if (!this.finished) {
                // empty if block
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() throws IOException {
            return null;
        }

        @JRubyMethod(name={"level"})
        public IRubyObject level() {
            return this.getRuntime().newFixnum(this.level);
        }

        @JRubyMethod(name={"sync="}, required=1)
        public IRubyObject set_sync(IRubyObject iRubyObject) {
            return this.getRuntime().getNil();
        }

        @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
        public static class LengthError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
        public static class NoFooter
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
        public static class CRCError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::Deflate"}, parent="Zlib::ZStream")
    public static class Deflate
    extends ZStream {
        protected static final ObjectAllocator DEFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Deflate(ruby, rubyClass);
            }
        };
        private ZlibDeflate defl;

        @JRubyMethod(name={"deflate"}, required=1, optional=1, meta=true)
        public static IRubyObject s_deflate(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
            iRubyObjectArray = Arity.scanArgs(iRubyObject.getRuntime(), iRubyObjectArray, 1, 1);
            int n = -1;
            if (!iRubyObjectArray[1].isNil()) {
                n = RubyNumeric.fix2int(iRubyObjectArray[1]);
            }
            return ZlibDeflate.s_deflate(iRubyObject, iRubyObjectArray[0].convertToString().getByteList(), n);
        }

        public Deflate(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"initialize"}, optional=4, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] iRubyObjectArray) throws Exception {
            iRubyObjectArray = Arity.scanArgs(this.getRuntime(), iRubyObjectArray, 0, 4);
            int n = -1;
            int n2 = 15;
            int n3 = 8;
            int n4 = 0;
            if (!iRubyObjectArray[0].isNil()) {
                n = RubyNumeric.fix2int(iRubyObjectArray[0]);
            }
            if (!iRubyObjectArray[1].isNil()) {
                n2 = RubyNumeric.fix2int(iRubyObjectArray[1]);
            }
            if (!iRubyObjectArray[2].isNil()) {
                n3 = RubyNumeric.fix2int(iRubyObjectArray[2]);
            }
            if (!iRubyObjectArray[3].isNil()) {
                n4 = RubyNumeric.fix2int(iRubyObjectArray[3]);
            }
            this.defl = new ZlibDeflate(this, n, n2, n3, n4);
            return this;
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(IRubyObject iRubyObject) throws Exception {
            this.defl.append(iRubyObject);
            return this;
        }

        @JRubyMethod(name={"params"}, required=2)
        public IRubyObject params(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            this.defl.params(RubyNumeric.fix2int(iRubyObject), RubyNumeric.fix2int(iRubyObject2));
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1)
        public IRubyObject set_dictionary(IRubyObject iRubyObject) throws Exception {
            return this.defl.set_dictionary(iRubyObject);
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] iRubyObjectArray) throws Exception {
            int n = 2;
            if (iRubyObjectArray.length == 1 && !iRubyObjectArray[0].isNil()) {
                n = RubyNumeric.fix2int(iRubyObjectArray[0]);
            }
            return this.defl.flush(n);
        }

        @JRubyMethod(name={"deflate"}, required=1, optional=1)
        public IRubyObject deflate(IRubyObject[] iRubyObjectArray) throws Exception {
            iRubyObjectArray = Arity.scanArgs(this.getRuntime(), iRubyObjectArray, 1, 1);
            int n = 0;
            if (!iRubyObjectArray[1].isNil()) {
                n = RubyNumeric.fix2int(iRubyObjectArray[1]);
            }
            return this.defl.deflate(iRubyObjectArray[0].convertToString().getByteList(), n);
        }

        protected int internalTotalOut() {
            return this.defl.getDeflater().getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.defl.getDeflater().finished();
        }

        protected void internalEnd() {
            this.defl.getDeflater().end();
        }

        protected void internalReset() {
            this.defl.getDeflater().reset();
        }

        protected int internalAdler() {
            return this.defl.getDeflater().getAdler();
        }

        protected IRubyObject internalFinish() throws Exception {
            return this.defl.finish();
        }

        protected int internalTotalIn() {
            return this.defl.getDeflater().getTotalIn();
        }

        protected void internalClose() {
            this.defl.close();
        }
    }

    @JRubyClass(name={"Zlib::Inflate"}, parent="Zlib::ZStream")
    public static class Inflate
    extends ZStream {
        protected static final ObjectAllocator INFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Inflate(ruby, rubyClass);
            }
        };
        private ZlibInflate infl;

        @JRubyMethod(name={"inflate"}, required=1, meta=true)
        public static IRubyObject s_inflate(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws Exception {
            return ZlibInflate.s_inflate(iRubyObject, iRubyObject2.convertToString().getByteList());
        }

        public Inflate(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] iRubyObjectArray) throws Exception {
            this.infl = new ZlibInflate(this);
            return this;
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(IRubyObject iRubyObject) {
            this.infl.append(iRubyObject);
            return this;
        }

        @JRubyMethod(name={"sync_point?"})
        public IRubyObject sync_point_p() {
            return this.infl.sync_point();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1)
        public IRubyObject set_dictionary(IRubyObject iRubyObject) throws Exception {
            return this.infl.set_dictionary(iRubyObject);
        }

        @JRubyMethod(name={"inflate"}, required=1)
        public IRubyObject inflate(IRubyObject iRubyObject) throws Exception {
            return this.infl.inflate(iRubyObject.convertToString().getByteList());
        }

        @JRubyMethod(name={"sync"}, required=1)
        public IRubyObject sync(IRubyObject iRubyObject) {
            return this.infl.sync(iRubyObject);
        }

        protected int internalTotalOut() {
            return this.infl.getInflater().getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.infl.getInflater().finished();
        }

        protected void internalEnd() {
            this.infl.getInflater().end();
        }

        protected void internalReset() {
            this.infl.getInflater().reset();
        }

        protected int internalAdler() {
            return this.infl.getInflater().getAdler();
        }

        protected IRubyObject internalFinish() throws Exception {
            this.infl.finish();
            return this.getRuntime().getNil();
        }

        public IRubyObject finished_p() {
            return this.infl.getInflater().finished() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected int internalTotalIn() {
            return this.infl.getInflater().getTotalIn();
        }

        protected void internalClose() {
            this.infl.close();
        }
    }

    @JRubyClass(name={"Zlib::ZStream"})
    public static abstract class ZStream
    extends RubyObject {
        protected boolean closed = false;
        protected boolean ended = false;
        protected boolean finished = false;

        protected abstract int internalTotalOut();

        protected abstract boolean internalStreamEndP();

        protected abstract void internalEnd();

        protected abstract void internalReset();

        protected abstract int internalAdler();

        protected abstract IRubyObject internalFinish() throws Exception;

        protected abstract int internalTotalIn();

        protected abstract void internalClose();

        public ZStream(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(Block block) {
            return this;
        }

        @JRubyMethod(name={"flust_next_out"})
        public IRubyObject flush_next_out() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"total_out"})
        public IRubyObject total_out() {
            return this.getRuntime().newFixnum(this.internalTotalOut());
        }

        @JRubyMethod(name={"stream_end?"})
        public IRubyObject stream_end_p() {
            return this.internalStreamEndP() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"data_type"})
        public IRubyObject data_type() {
            return this.getRuntime().fastGetModule("Zlib").fastGetConstant("UNKNOWN");
        }

        @JRubyMethod(name={"closed?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"ended?"})
        public IRubyObject ended_p() {
            return this.ended ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"end"})
        public IRubyObject end() {
            if (!this.ended) {
                this.internalEnd();
                this.ended = true;
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"reset"})
        public IRubyObject reset() {
            this.internalReset();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"avail_out"})
        public IRubyObject avail_out() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"avail_out="}, required=1)
        public IRubyObject set_avail_out(IRubyObject iRubyObject) {
            return iRubyObject;
        }

        @JRubyMethod(name={"adler"})
        public IRubyObject adler() {
            return this.getRuntime().newFixnum(this.internalAdler());
        }

        @JRubyMethod(name={"finish"})
        public IRubyObject finish() throws Exception {
            if (!this.finished) {
                this.finished = true;
                return this.internalFinish();
            }
            return RubyString.newEmptyString(this.getRuntime());
        }

        @JRubyMethod(name={"avail_in"})
        public IRubyObject avail_in() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"flush_next_in"})
        public IRubyObject flush_next_in() {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"total_in"})
        public IRubyObject total_in() {
            return this.getRuntime().newFixnum(this.internalTotalIn());
        }

        @JRubyMethod(name={"finished?"})
        public IRubyObject finished_p() {
            return this.finished ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            if (!this.closed) {
                this.internalClose();
                this.closed = true;
            }
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

