/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.anno;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.CodegenUtils;

public class JavaMethodDescriptor {
    public final boolean isStatic;
    public final boolean hasContext;
    public final boolean hasBlock;
    public final boolean hasVarArgs;
    public final int actualRequired;
    public final int arity;
    public final int required;
    public final int optional;
    public final boolean rest;
    private final Class[] parameters;
    public final JRubyMethod anno;
    public final int modifiers;
    private final Class declaringClass;
    public final String declaringClassName;
    public final String declaringClassPath;
    public final String name;
    public final String signature;

    public JavaMethodDescriptor(Method method) {
        int n;
        this.anno = method.getAnnotation(JRubyMethod.class);
        this.modifiers = method.getModifiers();
        this.declaringClass = method.getDeclaringClass();
        this.declaringClassName = this.declaringClass.getName();
        this.declaringClassPath = CodegenUtils.p(this.declaringClass);
        this.name = method.getName();
        this.isStatic = Modifier.isStatic(this.modifiers);
        this.parameters = method.getParameterTypes();
        if (this.parameters.length > 0) {
            this.hasContext = this.parameters[0] == ThreadContext.class;
            this.hasBlock = this.parameters[this.parameters.length - 1] == Block.class;
        } else {
            this.hasContext = false;
            this.hasBlock = false;
        }
        this.hasVarArgs = this.hasContext ? (this.hasBlock ? this.parameters[this.parameters.length - 2] == IRubyObject[].class : this.parameters[this.parameters.length - 1] == IRubyObject[].class) : (this.hasBlock ? this.parameters.length > 1 && this.parameters[this.parameters.length - 2] == IRubyObject[].class : this.parameters.length > 0 && this.parameters[this.parameters.length - 1] == IRubyObject[].class);
        this.optional = this.anno.optional();
        this.rest = this.anno.rest();
        this.required = this.anno.required();
        if (this.optional == 0 && !this.rest) {
            n = this.parameters.length;
            if (n == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --n;
                }
                if (this.hasContext) {
                    --n;
                }
                if (this.hasBlock) {
                    --n;
                }
                this.actualRequired = n;
            }
        } else {
            n = this.parameters.length;
            if (n == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --n;
                }
                if (this.hasContext) {
                    --n;
                }
                if (this.hasBlock) {
                    --n;
                }
                this.actualRequired = --n;
            }
            if (this.actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
            }
        }
        n = Math.max(this.required, this.actualRequired);
        this.arity = this.optional > 0 || this.rest ? -(n + 1) : n;
        this.signature = CodegenUtils.sig(method.getReturnType(), method.getParameterTypes());
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getParameterClasses() {
        return this.parameters;
    }
}

