/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.nb.ast.BlockAcceptingNode;
import org.jruby.nb.nb.nb.ast.IArgumentNode;
import org.jruby.nb.nb.nb.ast.IterNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.nb.runtime.CallType;
import org.jruby.nb.nb.nb.runtime.InterpretedBlock;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public CallNode(ISourcePosition iSourcePosition, Node node, String string, Node node2) {
        this(iSourcePosition, node, string, node2, null);
    }

    public CallNode(ISourcePosition iSourcePosition, Node node, String string, Node node2, Node node3) {
        super(iSourcePosition, NodeType.CALLNODE);
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
        this.setArgsNode(node2);
        this.iterNode = node3;
        this.callAdapter = MethodIndex.getCallSite(string);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        this.callAdapter = MethodIndex.getCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
        return node;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "CallNode: " + this.getName() + " @ " + this.getPosition();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        assert (false) : "No longer called";
        return null;
    }

    public Block getBlock(ThreadContext threadContext, IRubyObject iRubyObject) {
        IterNode iterNode = (IterNode)this.iterNode;
        iterNode.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(threadContext, iterNode.getBlockBody(), iRubyObject);
    }

    public Block getBlock(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RuntimeHelpers.getBlockFromBlockPassBody(ruby, this.iterNode.interpret(ruby, threadContext, iRubyObject, block), block);
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.getName(), new IRubyObject[]{iRubyObject2}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray rubyArray = (RubyArray)this.argsNode.interpret(ruby, threadContext, iRubyObject, block);
            rubyArray.append(iRubyObject2);
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.getName(), rubyArray.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return ruby.getNil();
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.receiverNode.definition(ruby, threadContext, iRubyObject, block) != null) {
            try {
                IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
                RubyClass rubyClass = iRubyObject2.getMetaClass();
                DynamicMethod dynamicMethod = rubyClass.searchMethod(this.getName());
                Visibility visibility = dynamicMethod.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || rubyClass.getRealClass().isInstance(iRubyObject)) && !dynamicMethod.isUndefined()) {
                    return ASTInterpreter.getArgumentDefinition(ruby, threadContext, this.getArgsNode(), "method", iRubyObject, block);
                }
            }
            catch (JumpException jumpException) {
                // empty catch block
            }
        }
        return null;
    }
}

