/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ast.Colon3Node;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Colon2Node
extends Colon3Node
implements INameNode {
    private final Node leftNode;

    public Colon2Node(ISourcePosition iSourcePosition, Node node, String string) {
        super(iSourcePosition, NodeType.COLON2NODE, string);
        this.leftNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitColon2Node(this);
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.leftNode);
    }

    @Override
    public String toString() {
        String string = "Colon2Node [";
        if (this.leftNode != null) {
            string = string + this.leftNode;
        }
        string = string + this.getName();
        return string + "]";
    }

    @Override
    public RubyModule getEnclosingModule(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.leftNode != null) {
            IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
            return RuntimeHelpers.prepareClassNamespace(threadContext, iRubyObject2);
        }
        return threadContext.getCurrentScope().getStaticScope().getModule();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.leftNode == null) {
            return ruby.getObject().fastGetConstantFrom(this.name);
        }
        IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
        if (IdUtil.isConstant(this.name)) {
            if (iRubyObject2 instanceof RubyModule) {
                return ((RubyModule)iRubyObject2).fastGetConstantFrom(this.name);
            }
            throw ruby.newTypeError(iRubyObject2 + " is not a class/module");
        }
        return RuntimeHelpers.invoke(threadContext, iRubyObject2, this.name, block);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
            if (iRubyObject2 instanceof RubyModule && ((RubyModule)iRubyObject2).fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (iRubyObject2.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException jumpException) {
            // empty catch block
        }
        return null;
    }
}

