/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.nb.ast.BlockAcceptingNode;
import org.jruby.nb.nb.nb.ast.IArgumentNode;
import org.jruby.nb.nb.nb.ast.IterNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.nb.runtime.InterpretedBlock;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public FCallNode(ISourcePosition iSourcePosition, String string, Node node) {
        this(iSourcePosition, string, node, null);
    }

    protected FCallNode(ISourcePosition iSourcePosition, String string, Node node, Node node2) {
        super(iSourcePosition, NodeType.FCALLNODE);
        this.setArgsNode(node);
        this.iterNode = node2;
        this.callAdapter = MethodIndex.getFunctionalCallSite(string);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        this.callAdapter = MethodIndex.getFunctionalCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
        return node;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        assert (false) : "Should not happen anymore";
        return null;
    }

    public Block getBlock(ThreadContext threadContext, IRubyObject iRubyObject) {
        IterNode iterNode = (IterNode)this.iterNode;
        iterNode.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(threadContext, iterNode.getBlockBody(), iRubyObject);
    }

    public Block getBlock(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RuntimeHelpers.getBlockFromBlockPassBody(ruby, this.iterNode.interpret(ruby, threadContext, iRubyObject, block), block);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (iRubyObject.getMetaClass().isMethodBound(this.getName(), false)) {
            return ASTInterpreter.getArgumentDefinition(ruby, threadContext, this.getArgsNode(), "method", iRubyObject, block);
        }
        return null;
    }
}

