/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixnumNode
extends Node
implements ILiteralNode {
    private long value;
    private RubyFixnum fixnum;

    public FixnumNode(ISourcePosition iSourcePosition, long l) {
        super(iSourcePosition, NodeType.FIXNUMNODE);
        this.value = l;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFixnumNode(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        if (this.fixnum != null) {
            this.fixnum = null;
        }
        this.value = l;
    }

    public RubyFixnum getFixnum(Ruby ruby) {
        if (this.fixnum == null) {
            this.fixnum = RubyFixnum.newFixnum(ruby, this.value);
            return this.fixnum;
        }
        return this.fixnum;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.getFixnum(ruby);
    }
}

