/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.nb.ast.AssignableNode;
import org.jruby.nb.nb.nb.ast.ListNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.SplatNode;
import org.jruby.nb.nb.nb.ast.util.ArgsUtil;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode headNode;
    private final Node argsNode;

    public MultipleAsgnNode(ISourcePosition iSourcePosition, ListNode listNode, Node node) {
        super(iSourcePosition, NodeType.MULTIPLEASGNNODE);
        this.headNode = listNode;
        this.argsNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitMultipleAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public ListNode getHeadNode() {
        return this.headNode;
    }

    @Override
    public Arity getArity() {
        if (this.argsNode != null) {
            return Arity.required(this.headNode == null ? 0 : this.headNode.size());
        }
        return Arity.fixed(this.headNode.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.headNode, this.argsNode, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        switch (this.getValueNode().nodeId) {
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)this.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(ruby, threadContext, this, arrayNode, iRubyObject, block);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)this.getValueNode();
                RubyArray rubyArray = RuntimeHelpers.splatValue(splatNode.getValue().interpret(ruby, threadContext, iRubyObject, block));
                return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, this, rubyArray, false);
            }
        }
        IRubyObject iRubyObject2 = this.getValueNode().interpret(ruby, threadContext, iRubyObject, block);
        if (!(iRubyObject2 instanceof RubyArray)) {
            iRubyObject2 = RubyArray.newArray(ruby, iRubyObject2);
        }
        return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, this, (RubyArray)iRubyObject2, false);
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        if (!(iRubyObject2 instanceof RubyArray)) {
            iRubyObject2 = ArgsUtil.convertToRubyArray(ruby, iRubyObject2, this.headNode != null);
        }
        return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, this, (RubyArray)iRubyObject2, bl);
    }
}

