/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext.ffi.jna;

import com.sun.jna.Native;
import java.nio.channels.ByteChannel;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.nb.ext.ffi.Factory;
import org.jruby.nb.nb.nb.ext.ffi.Platform;
import org.jruby.nb.nb.nb.ext.ffi.jna.FileDescriptorByteChannel;
import org.jruby.nb.nb.nb.ext.ffi.jna.JNABuffer;
import org.jruby.nb.nb.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.nb.nb.ext.ffi.jna.JNAPlatform;
import org.jruby.nb.nb.nb.ext.ffi.jna.JNAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAFactory
extends Factory {
    private final JNAPlatform platform = new JNAPlatform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby ruby, RubyModule rubyModule) {
        super.init(ruby, rubyModule);
        RubyModule rubyModule2 = rubyModule;
        synchronized (rubyModule2) {
            if (rubyModule.fastGetClass("MemoryPointer") == null) {
                JNAMemoryPointer.createMemoryPointerClass(ruby);
            }
            if (rubyModule.fastGetClass("Buffer") == null) {
                JNABuffer.createBufferClass(ruby);
            }
        }
    }

    @Override
    protected FFIProvider newProvider(Ruby ruby) {
        return new JNAProvider(ruby);
    }

    @Override
    public <T> T loadLibrary(String string, Class<T> clazz) {
        return clazz.cast(Native.loadLibrary((String)string, clazz));
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public ByteChannel newByteChannel(int n) {
        return new FileDescriptorByteChannel(n);
    }
}

