/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext.ffi.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.nb.ext.ffi.MemoryIO;
import org.jruby.nb.nb.nb.ext.ffi.Util;
import org.jruby.nb.nb.nb.ext.ffi.jna.JNAMemoryIO;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::MemoryPointer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class JNAMemoryPointer
extends AbstractMemoryPointer {
    public static final String MEMORY_POINTER_NAME = "MemoryPointer";

    public static RubyClass createMemoryPointerClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(MEMORY_POINTER_NAME, rubyModule.getClass("AbstractMemoryPointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JNAMemoryPointer.class);
        rubyClass.defineAnnotatedConstants(JNAMemoryPointer.class);
        return rubyClass;
    }

    public JNAMemoryPointer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    JNAMemoryPointer(Ruby ruby, Pointer pointer) {
        this(ruby, JNAMemoryIO.wrap(pointer), 0L, Long.MAX_VALUE);
    }

    private JNAMemoryPointer(Ruby ruby, JNAMemoryPointer jNAMemoryPointer, long l) {
        this(ruby, jNAMemoryPointer.io, jNAMemoryPointer.offset + l, jNAMemoryPointer.size == Long.MAX_VALUE ? Long.MAX_VALUE : jNAMemoryPointer.size - l);
    }

    JNAMemoryPointer(Ruby ruby, MemoryIO memoryIO, long l, long l2) {
        super(ruby, FFIProvider.getModule(ruby).fastGetClass(MEMORY_POINTER_NAME), memoryIO, l, l2);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        JNAMemoryIO jNAMemoryIO = n > 0 ? JNAMemoryIO.allocateDirect(n) : JNAMemoryIO.NULL;
        return new JNAMemoryPointer(threadContext.getRuntime(), jNAMemoryIO, 0L, n);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        JNAMemoryIO jNAMemoryIO;
        int n = Util.int32Value(iRubyObject2);
        JNAMemoryIO jNAMemoryIO2 = jNAMemoryIO = n > 0 ? JNAMemoryIO.allocateDirect(n) : JNAMemoryIO.NULL;
        if (iRubyObject3.isTrue()) {
            jNAMemoryIO.setMemory(0L, n, (byte)0);
        }
        return new JNAMemoryPointer(threadContext.getRuntime(), jNAMemoryIO, 0L, n);
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        String string = ((JNAMemoryIO)this.getMemoryIO()).getAddress().toString();
        return RubyString.newString(threadContext.getRuntime(), "MemoryPointer[address=" + string + "]");
    }

    Pointer getAddress() {
        return ((JNAMemoryIO)this.getMemoryIO()).getAddress();
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    private static final long ptr2long(Pointer pointer) {
        return new PointerByReference(pointer).getPointer().getInt(0L);
    }

    @JRubyMethod(name={"address"})
    public IRubyObject address(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(JNAMemoryPointer.ptr2long(this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        String string = Long.toHexString(JNAMemoryPointer.ptr2long(this.getAddress()) + this.offset);
        return RubyString.newString(threadContext.getRuntime(), String.format("#<MemoryPointer address=0x%s>", string));
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        return new JNAMemoryPointer(threadContext.getRuntime(), this, RubyNumeric.fix2long(iRubyObject));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Pointer pointer;
        if (iRubyObject2 instanceof JNAMemoryPointer) {
            pointer = ((JNAMemoryPointer)iRubyObject2).getAddress();
        } else if (iRubyObject2.isNil()) {
            pointer = Pointer.NULL;
        } else {
            throw threadContext.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(iRubyObject), pointer);
        return this;
    }

    protected AbstractMemoryPointer getMemoryPointer(Ruby ruby, long l) {
        return new JNAMemoryPointer(ruby, this.getMemoryIO().getMemoryIO(this.offset + l), 0L, Long.MAX_VALUE);
    }
}

