/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.internal.runtime;

import java.util.ArrayList;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyProc;
import org.jruby.nb.nb.nb.internal.runtime.UndefinedAccessor;
import org.jruby.nb.nb.nb.runtime.IAccessor;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public final class GlobalVariable {
    private IAccessor accessor;
    private ArrayList<IRubyObject> traces = null;
    private boolean tracing;

    public GlobalVariable(IAccessor iAccessor) {
        this.accessor = iAccessor;
    }

    public static GlobalVariable newUndefined(Ruby ruby, String string) {
        GlobalVariable globalVariable = new GlobalVariable(null);
        globalVariable.setAccessor(new UndefinedAccessor(ruby, globalVariable, string));
        return globalVariable;
    }

    public IAccessor getAccessor() {
        return this.accessor;
    }

    public ArrayList getTraces() {
        return this.traces;
    }

    public void addTrace(RubyProc rubyProc) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        this.traces.add(rubyProc);
    }

    public boolean removeTrace(IRubyObject iRubyObject) {
        if (this.traces == null || !this.traces.contains(iRubyObject)) {
            return false;
        }
        this.traces.remove(iRubyObject);
        return true;
    }

    public void removeTraces() {
        this.traces = null;
    }

    public void setAccessor(IAccessor iAccessor) {
        this.accessor = iAccessor;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(IRubyObject iRubyObject) {
        if (this.traces == null) {
            return;
        }
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        if (threadContext.isWithinTrace()) {
            return;
        }
        try {
            threadContext.setWithinTrace(true);
            for (int i = 0; i < this.traces.size(); ++i) {
                ((RubyProc)this.traces.get(i)).call(threadContext, new IRubyObject[]{iRubyObject});
            }
            Object var5_4 = null;
            threadContext.setWithinTrace(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            threadContext.setWithinTrace(false);
            throw throwable;
        }
    }
}

