/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.internal.runtime.methods;

import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public abstract class CallConfiguration {
    public static final CallConfiguration FRAME_AND_SCOPE = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
            threadContext.preMethodFrameAndScope(rubyModule, string, iRubyObject, block, staticScope);
        }

        public void post(ThreadContext threadContext) {
            threadContext.postMethodFrameAndScope();
        }

        public String name() {
            return "FRAME_AND_SCOPE";
        }
    };
    public static final CallConfiguration FRAME_ONLY = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
            threadContext.preMethodFrameOnly(rubyModule, string, iRubyObject, block);
        }

        public void post(ThreadContext threadContext) {
            threadContext.postMethodFrameOnly();
        }

        public String name() {
            return "FRAME_ONLY";
        }
    };
    public static final CallConfiguration SCOPE_ONLY = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
            threadContext.preMethodScopeOnly(rubyModule, staticScope);
        }

        public void post(ThreadContext threadContext) {
            threadContext.postMethodScopeOnly();
        }

        public String name() {
            return "SCOPE_ONLY";
        }
    };
    public static final CallConfiguration NO_FRAME_NO_SCOPE = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
        }

        public void post(ThreadContext threadContext) {
        }

        public String name() {
            return "NO_FRAME_NO_SCOPE";
        }

        public boolean isNoop() {
            return true;
        }
    };
    public static final CallConfiguration BACKTRACE_ONLY = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
            threadContext.preMethodBacktraceOnly(string);
        }

        public void post(ThreadContext threadContext) {
            threadContext.postMethodBacktraceOnly();
        }

        public String name() {
            return "BACKTRACE_ONLY";
        }
    };
    public static final CallConfiguration BACKTRACE_AND_SCOPE = new CallConfiguration(){

        public void pre(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
            threadContext.preMethodBacktraceAndScope(string, rubyModule, staticScope);
        }

        public void post(ThreadContext threadContext) {
            threadContext.postMethodBacktraceAndScope();
        }

        public String name() {
            return "BACKTRACE_AND_SCOPE";
        }
    };

    public static CallConfiguration getCallConfigByAnno(JRubyMethod jRubyMethod) {
        return CallConfiguration.getCallConfig(jRubyMethod.frame(), jRubyMethod.scope(), jRubyMethod.backtrace());
    }

    public static CallConfiguration getCallConfig(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                return FRAME_AND_SCOPE;
            }
            return FRAME_ONLY;
        }
        if (bl2) {
            if (bl3) {
                return BACKTRACE_AND_SCOPE;
            }
            return SCOPE_ONLY;
        }
        if (bl3) {
            return BACKTRACE_ONLY;
        }
        return NO_FRAME_NO_SCOPE;
    }

    private CallConfiguration() {
    }

    public abstract void pre(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5, StaticScope var6, JumpTarget var7);

    public abstract void post(ThreadContext var1);

    public abstract String name();

    public boolean isNoop() {
        return false;
    }
}

