/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.javasupport.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectProxyCache<T, A> {
    private static final int DEFAULT_SEGMENTS = 16;
    private static final int DEFAULT_SEGMENT_SIZE = 8;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int VULTURE_RUN_FREQ_SECONDS = 5;
    private static int _nextId = 0;
    private final ReferenceType referenceType;
    private final Segment<T, A>[] segments;
    private final int segmentShift;
    private final int segmentMask;
    private final Thread vulture;
    private final int id;

    private static synchronized int nextId() {
        return ++_nextId;
    }

    public ObjectProxyCache() {
        this(16, 8, ReferenceType.WEAK);
    }

    public ObjectProxyCache(ReferenceType referenceType) {
        this(16, 8, referenceType);
    }

    public ObjectProxyCache(int n, int n2, ReferenceType referenceType) {
        int n3;
        int n4;
        if (n <= 0 || n2 <= 0 || referenceType == null) {
            throw new IllegalArgumentException();
        }
        this.id = ObjectProxyCache.nextId();
        this.referenceType = referenceType;
        if (n > 65536) {
            n = 65536;
        }
        int n5 = 0;
        for (n4 = 1; n4 < n; n4 <<= 1) {
            ++n5;
        }
        this.segmentShift = 24 - n5;
        this.segmentMask = n4 - 1;
        this.segments = Segment.newArray(n4);
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        int n6 = n4;
        while (--n6 >= 0) {
            this.segments[n6] = new Segment(n3, this);
        }
        this.vulture = new Thread("ObjectProxyCache " + this.id + " vulture"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    boolean bl;
                    try {
                        1.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean bl2 = bl = ObjectProxyCache.this.size() > 200;
                    if (bl) {
                        System.err.println("***Vulture " + ObjectProxyCache.this.id + " waking, stats:");
                        System.err.println(ObjectProxyCache.this.stats());
                    }
                    int n = ObjectProxyCache.this.segments.length;
                    while (--n >= 0) {
                        Object var5_5;
                        Segment segment = ObjectProxyCache.this.segments[n];
                        segment.lock();
                        try {
                            segment.expunge();
                            var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            var5_5 = null;
                            segment.unlock();
                            throw throwable;
                        }
                        segment.unlock();
                        1.yield();
                    }
                    if (!bl) continue;
                    System.err.println("***Vulture " + ObjectProxyCache.this.id + " sleeping, stats:");
                    System.err.println(ObjectProxyCache.this.stats());
                }
            }
        };
        try {
            this.vulture.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public abstract T allocateProxy(Object var1, A var2);

    public T get(Object object) {
        if (object == null) {
            return null;
        }
        int n = ObjectProxyCache.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    public T getOrCreate(Object object, A a) {
        if (object == null || a == null) {
            return null;
        }
        int n = ObjectProxyCache.hash(object);
        return this.segmentFor(n).getOrCreate(object, n, a);
    }

    public void put(Object object, T t) {
        if (object == null || t == null) {
            return;
        }
        int n = ObjectProxyCache.hash(object);
        this.segmentFor(n).put(object, n, t);
    }

    private static int hash(Object object) {
        int n = System.identityHashCode(object);
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private Segment<T, A> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public int size() {
        int n = 0;
        for (Segment<T, A> segment : this.segments) {
            n += segment.tableSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stats() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        stringBuilder.append("Segments: ").append(this.segments.length).append("\n");
        for (Segment<T, A> segment : this.segments) {
            Object var12_11;
            int n4 = 0;
            int n5 = 0;
            segment.lock();
            try {
                n4 = ((Segment)segment).count();
                n5 = segment.entryTable.length;
                var12_11 = null;
            }
            catch (Throwable throwable) {
                var12_11 = null;
                segment.unlock();
                throw throwable;
            }
            segment.unlock();
            n2 += n4;
            n3 += n5;
            stringBuilder.append("seg[").append(n++).append("]:  size: ").append(n4).append("  alloc: ").append(n5).append("\n");
        }
        stringBuilder.append("Total: size: ").append(n2).append("  alloc: ").append(n3).append("\n");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Segment<T, A>
    extends ReentrantLock {
        final ObjectProxyCache<T, A> cache;
        final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile Entry<T>[] entryTable;
        int tableSize;
        int threshold;

        Segment(int n, ObjectProxyCache<T, A> objectProxyCache) {
            this.threshold = (int)((float)n * 0.75f);
            this.entryTable = Entry.newArray(n);
            this.cache = objectProxyCache;
        }

        private void expunge() {
            EntryRef entryRef;
            Entry<T>[] entryArray = this.entryTable;
            ReferenceQueue<Object> referenceQueue = this.referenceQueue;
            block0: while ((entryRef = (EntryRef)((Object)referenceQueue.poll())) != null) {
                int n = entryRef.hash();
                Entry<T> entry = entryArray[n & entryArray.length - 1];
                while (entry != null) {
                    if (n == entry.hash && (entryRef == entry.objectRef || entryRef == entry.proxyRef)) {
                        this.remove(entryArray, n, entry);
                        continue block0;
                    }
                    entry = entry.next;
                }
            }
        }

        private void remove(Entry<T>[] entryArray, int n, Entry<T> entry) {
            Entry<T> entry2;
            int n2 = n & entryArray.length - 1;
            Entry<T> entry3 = entry2 = entryArray[n2];
            while (entry3 != null) {
                if (entry3 == entry) {
                    Entry entry4 = entry3.next;
                    Entry<T> entry5 = entry2;
                    while (entry5 != entry3) {
                        entry4 = new Entry(entry5.objectRef, entry5.hash, entry5.proxyRef, entry4);
                        entry5 = entry5.next;
                    }
                    entryArray[n2] = entry4;
                    --this.tableSize;
                    this.entryTable = entryArray;
                    return;
                }
                entry3 = entry3.next;
            }
        }

        private int count() {
            int n = 0;
            for (Entry<T> entry : this.entryTable) {
                while (entry != null) {
                    ++n;
                    entry = entry.next;
                }
            }
            return n;
        }

        private Entry<T>[] rehash() {
            assert (this.tableSize == this.count()) : "tableSize " + this.tableSize + " != count() " + this.count();
            Entry<T>[] entryArray = this.entryTable;
            int n = entryArray.length;
            if (n >= 0x40000000) {
                return entryArray;
            }
            int n2 = n << 1;
            int n3 = n2 - 1;
            this.threshold = (int)((float)n2 * 0.75f);
            Entry<T>[] entryArray2 = Entry.newArray(n2);
            int n4 = n;
            while (--n4 >= 0) {
                int n5;
                Entry<T> entry = entryArray[n4];
                if (entry == null) continue;
                int n6 = entry.hash & n3;
                Entry entry2 = entry.next;
                if (entry2 == null) {
                    entryArray2[n6] = entry;
                    continue;
                }
                int n7 = n6;
                Entry<T> entry3 = entry;
                Entry entry4 = entry2;
                while (entry4 != null) {
                    n5 = entry4.hash & n3;
                    if (n5 != n7) {
                        n7 = n5;
                        entry3 = entry4;
                    }
                    entry4 = entry4.next;
                }
                entryArray2[n7] = entry3;
                entry4 = entry;
                while (entry4 != entry3) {
                    n5 = entry4.hash & n3;
                    Entry entry5 = new Entry(entry4.objectRef, entry4.hash, entry4.proxyRef, entryArray2[n5]);
                    entryArray2[n5] = entry5;
                    entry4 = entry4.next;
                }
            }
            this.entryTable = entryArray2;
            return entryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void put(Object object, int n, T t) {
            block7: {
                block6: {
                    this.lock();
                    try {
                        this.expunge();
                        int n2 = this.tableSize + 1;
                        Entry<T>[] entryArray = n2 > this.threshold ? this.rehash() : this.entryTable;
                        int n3 = n & entryArray.length - 1;
                        Entry<T> entry = entryArray[n3];
                        while (entry != null) {
                            if (n == entry.hash && object == entry.objectRef.get()) {
                                if (t == entry.proxyRef.get()) {
                                    Object var9_8 = null;
                                    break block6;
                                } else {
                                    this.remove(entryArray, n, entry);
                                    --n2;
                                    break;
                                }
                            }
                            entry = entry.next;
                        }
                        entryArray[n3] = entry = new Entry<T>(object, n, t, ((ObjectProxyCache)this.cache).referenceType, entryArray[n3], this.referenceQueue);
                        this.tableSize = n2;
                        this.entryTable = entryArray;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        this.unlock();
                        throw throwable;
                    }
                }
                this.unlock();
                return;
            }
            Object var9_9 = null;
            this.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        T getOrCreate(Object object, int n, A a) {
            Object t;
            block9: {
                Object t2;
                block8: {
                    Object t3;
                    Entry<T>[] entryArray = this.entryTable;
                    Entry<T> entry = this.entryTable[n & entryArray.length - 1];
                    while (entry != null) {
                        if (n == entry.hash && object == entry.objectRef.get()) {
                            t3 = entry.proxyRef.get();
                            if (t3 == null) break;
                            return t3;
                        }
                        entry = entry.next;
                    }
                    this.lock();
                    try {
                        this.expunge();
                        int n2 = this.tableSize + 1;
                        entryArray = n2 > this.threshold ? this.rehash() : this.entryTable;
                        int n3 = n & entryArray.length - 1;
                        Entry<T> entry2 = entryArray[n3];
                        while (entry2 != null) {
                            if (n == entry2.hash && object == entry2.objectRef.get()) {
                                t3 = entry2.proxyRef.get();
                                if (t3 != null) {
                                    t2 = t3;
                                    Object var11_12 = null;
                                    break block8;
                                } else {
                                    this.remove(entryArray, n, entry2);
                                    --n2;
                                    break;
                                }
                            }
                            entry2 = entry2.next;
                        }
                        t3 = this.cache.allocateProxy(object, a);
                        entryArray[n3] = entry2 = new Entry(object, n, t3, ((ObjectProxyCache)this.cache).referenceType, entryArray[n3], this.referenceQueue);
                        this.tableSize = n2;
                        this.entryTable = entryArray;
                        t = t3;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        this.unlock();
                        throw throwable;
                    }
                }
                this.unlock();
                return t2;
            }
            Object var11_13 = null;
            this.unlock();
            return t;
        }

        T get(Object object, int n) {
            Entry<T>[] entryArray = this.entryTable;
            Entry<T> entry = this.entryTable[n & entryArray.length - 1];
            while (entry != null) {
                if (n == entry.hash && object == entry.objectRef.get()) {
                    return entry.proxyRef.get();
                }
                entry = entry.next;
            }
            return null;
        }

        static final <T, A> Segment<T, A>[] newArray(int n) {
            return new Segment[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<T> {
        final EntryRef<Object> objectRef;
        final int hash;
        final EntryRef<T> proxyRef;
        final Entry<T> next;

        Entry(Object object, int n, T t, ReferenceType referenceType, Entry<T> entry, ReferenceQueue<Object> referenceQueue) {
            this.hash = n;
            this.next = entry;
            if (referenceType == ReferenceType.WEAK) {
                this.objectRef = new WeakEntryRef<Object>(n, object, referenceQueue);
                this.proxyRef = new WeakEntryRef<T>(n, t, referenceQueue);
            } else {
                this.objectRef = new SoftEntryRef<Object>(n, object, referenceQueue);
                this.proxyRef = new SoftEntryRef<T>(n, t, referenceQueue);
            }
        }

        Entry(EntryRef<Object> entryRef, int n, EntryRef<T> entryRef2, Entry<T> entry) {
            this.objectRef = entryRef;
            this.hash = n;
            this.proxyRef = entryRef2;
            this.next = entry;
        }

        static final <T> Entry<T>[] newArray(int n) {
            return new Entry[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SoftEntryRef<T>
    extends SoftReference<T>
    implements EntryRef<T> {
        final int hash;

        SoftEntryRef(int n, T t, ReferenceQueue<Object> referenceQueue) {
            super(t, referenceQueue);
            this.hash = n;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakEntryRef<T>
    extends WeakReference<T>
    implements EntryRef<T> {
        final int hash;

        WeakEntryRef(int n, T t, ReferenceQueue<Object> referenceQueue) {
            super(t, referenceQueue);
            this.hash = n;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntryRef<T> {
        public T get();

        public int hash();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceType {
        WEAK,
        SOFT;

    }
}

