/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.WeakIdentityHashMap;

public class ObjectSpace {
    private ReferenceQueue deadReferences = new ReferenceQueue();
    private WeakReferenceListNode top;
    private ReferenceQueue deadIdentityReferences = new ReferenceQueue();
    private final Map identities = new HashMap();
    private final Map identitiesByObject = new WeakIdentityHashMap();
    private long maxId = 4L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long idOf(IRubyObject iRubyObject) {
        Map map = this.identities;
        synchronized (map) {
            Long l = (Long)this.identitiesByObject.get(iRubyObject);
            if (l == null) {
                l = this.createId(iRubyObject);
            }
            return l;
        }
    }

    private Long createId(IRubyObject iRubyObject) {
        this.cleanIdentities();
        this.maxId += 2L;
        Long l = new Long(this.maxId);
        this.identities.put(l, new IdReference(iRubyObject, this.maxId, this.deadIdentityReferences));
        this.identitiesByObject.put(iRubyObject, l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject id2ref(long l) {
        Map map = this.identities;
        synchronized (map) {
            this.cleanIdentities();
            IdReference idReference = (IdReference)this.identities.get(new Long(l));
            if (idReference == null) {
                return null;
            }
            return (IRubyObject)idReference.get();
        }
    }

    private void cleanIdentities() {
        IdReference idReference;
        while ((idReference = (IdReference)this.deadIdentityReferences.poll()) != null) {
            this.identities.remove(new Long(idReference.id()));
        }
    }

    public void addFinalizer(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.addFinalizer(iRubyObject2);
    }

    public void removeFinalizers(long l) {
        IRubyObject iRubyObject = this.id2ref(l);
        if (iRubyObject != null) {
            iRubyObject.removeFinalizers();
        }
    }

    public synchronized void add(IRubyObject iRubyObject) {
        this.cleanup();
        this.top = new WeakReferenceListNode(iRubyObject, this.deadReferences, this.top);
    }

    public synchronized Iterator iterator(RubyModule rubyModule) {
        final ArrayList<WeakReferenceListNode> arrayList = new ArrayList<WeakReferenceListNode>();
        WeakReferenceListNode weakReferenceListNode = this.top;
        while (weakReferenceListNode != null) {
            IRubyObject iRubyObject = (IRubyObject)weakReferenceListNode.get();
            if (iRubyObject != null && rubyModule.isInstance(iRubyObject)) {
                arrayList.add(weakReferenceListNode);
            }
            weakReferenceListNode = weakReferenceListNode.nextNode;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = arrayList.iterator();
            }

            public boolean hasNext() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                WeakReferenceListNode weakReferenceListNode;
                Object var1_1 = null;
                while (this.iter.hasNext() && (var1_1 = (weakReferenceListNode = (WeakReferenceListNode)this.iter.next()).get()) == null) {
                }
                return var1_1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized void cleanup() {
        WeakReferenceListNode weakReferenceListNode;
        while ((weakReferenceListNode = (WeakReferenceListNode)this.deadReferences.poll()) != null) {
            weakReferenceListNode.remove();
        }
    }

    private static class IdReference
    extends WeakReference {
        private final long id;

        public IdReference(IRubyObject iRubyObject, long l, ReferenceQueue referenceQueue) {
            super(iRubyObject, referenceQueue);
            this.id = l;
        }

        public long id() {
            return this.id;
        }
    }

    private class WeakReferenceListNode
    extends WeakReference {
        private WeakReferenceListNode prevNode;
        private WeakReferenceListNode nextNode;

        public WeakReferenceListNode(Object object, ReferenceQueue referenceQueue, WeakReferenceListNode weakReferenceListNode) {
            super(object, referenceQueue);
            this.nextNode = weakReferenceListNode;
            if (weakReferenceListNode != null) {
                weakReferenceListNode.prevNode = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ObjectSpace objectSpace = ObjectSpace.this;
            synchronized (objectSpace) {
                if (this.prevNode != null) {
                    this.prevNode.nextNode = this.nextNode;
                } else {
                    ObjectSpace.this.top = this.nextNode;
                }
                if (this.nextNode != null) {
                    this.nextNode.prevNode = this.prevNode;
                }
            }
        }
    }
}

