/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.runtime.marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.marshal.UnmarshalStream;

public class UnmarshalCache {
    private final Ruby runtime;
    private final List<IRubyObject> links = new ArrayList<IRubyObject>();
    private final List<RubySymbol> symbols = new ArrayList<RubySymbol>();

    public UnmarshalCache(Ruby ruby) {
        this.runtime = ruby;
    }

    public void register(IRubyObject iRubyObject) {
        this.selectCache(iRubyObject).add(iRubyObject);
    }

    private List selectCache(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubySymbol ? this.symbols : this.links;
    }

    public boolean isLinkType(int n) {
        return n == 59 || n == 64;
    }

    public IRubyObject readLink(UnmarshalStream unmarshalStream, int n) throws IOException {
        int n2 = unmarshalStream.unmarshalInt();
        if (n == 64) {
            return this.linkedByIndex(n2);
        }
        assert (n == 59);
        return this.symbolByIndex(n2);
    }

    private IRubyObject linkedByIndex(int n) {
        try {
            return this.links.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.runtime.newArgumentError("dump format error (unlinked, index: " + n + ")");
        }
    }

    private RubySymbol symbolByIndex(int n) {
        try {
            return this.symbols.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.runtime.newTypeError("bad symbol");
        }
    }
}

