/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.util;

public final class IdUtil {
    public static boolean isConstant(String string) {
        return Character.isUpperCase(string.charAt(0));
    }

    public static boolean isClassVariable(String string) {
        return string.length() > 1 && string.charAt(0) == '@' && string.charAt(1) == '@';
    }

    public static boolean isInstanceVariable(String string) {
        return string.length() > 0 && string.charAt(0) == '@' && (string.length() < 2 || string.charAt(1) != '@');
    }

    public static boolean isGlobal(String string) {
        return string.length() > 0 && string.charAt(0) == '$';
    }

    public static boolean isLocal(String string) {
        return !IdUtil.isGlobal(string) && !IdUtil.isClassVariable(string) && !IdUtil.isInstanceVariable(string) && !IdUtil.isConstant(string);
    }

    public static boolean isAttrSet(String string) {
        return string.endsWith("=");
    }

    public static boolean isValidConstantName(String string) {
        char c;
        int n = string.length();
        if (n > 0 && (c = string.charAt(0)) <= 'Z' && c >= 'A') {
            return IdUtil.isNameString(string, 1, n);
        }
        return false;
    }

    public static boolean isValidInstanceVariableName(String string) {
        int n = string.length();
        if (n > 0 && '@' == string.charAt(0)) {
            if (n > 1) {
                if (IdUtil.isInitialCharacter(string.charAt(1))) {
                    return IdUtil.isNameString(string, 2, n);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidClassVariableName(String string) {
        int n = string.length();
        if (n > 1 && '@' == string.charAt(0) && '@' == string.charAt(1)) {
            if (n > 2) {
                if (IdUtil.isInitialCharacter(string.charAt(2))) {
                    return IdUtil.isNameString(string, 3, n);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isInitialCharacter(int n) {
        return (n &= 0xFFFFFFDF) <= 90 && n >= 65 || n == 95;
    }

    public static boolean isNameCharacter(char c) {
        int n = c & 0xFFFFFFDF;
        return n <= 90 && n >= 65 || c == '_' || c <= '9' && c >= '0';
    }

    public static boolean isNameString(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (IdUtil.isNameCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

