/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.util;

import org.joni.Regex;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public class Numeric {
    private static long SQRT_LONG_MAX = 0x80000000L;

    public static IRubyObject f_add(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum && ((RubyFixnum)iRubyObject2).getLongValue() == 0L) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyFixnum && ((RubyFixnum)iRubyObject).getLongValue() == 0L) {
            return iRubyObject2;
        }
        return iRubyObject.callMethod(threadContext, "+", iRubyObject2);
    }

    public static IRubyObject f_cmp(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).getLongValue() - ((RubyFixnum)iRubyObject2).getLongValue();
            if (l > 0L) {
                return RubyFixnum.one(threadContext.getRuntime());
            }
            if (l < 0L) {
                return RubyFixnum.minus_one(threadContext.getRuntime());
            }
            return RubyFixnum.zero(threadContext.getRuntime());
        }
        return iRubyObject.callMethod(threadContext, "<=>", iRubyObject2);
    }

    public static IRubyObject f_div(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum && ((RubyFixnum)iRubyObject2).getLongValue() == 1L) {
            return iRubyObject;
        }
        return iRubyObject.callMethod(threadContext, "/", iRubyObject2);
    }

    public static IRubyObject f_gt_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() > ((RubyFixnum)iRubyObject2).getLongValue() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
        }
        return iRubyObject.callMethod(threadContext, ">", iRubyObject2);
    }

    public static IRubyObject f_lt_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() < ((RubyFixnum)iRubyObject2).getLongValue() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
        }
        return iRubyObject.callMethod(threadContext, "<", iRubyObject2);
    }

    public static IRubyObject f_mod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "%", iRubyObject2);
    }

    public static IRubyObject f_mul(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject2 instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject2).getLongValue();
            if (l == 0L) {
                if (iRubyObject instanceof RubyFloat) {
                    return ruby.newFloat(0.0);
                }
                return RubyFixnum.zero(ruby);
            }
            if (l == 1L) {
                return iRubyObject;
            }
        } else if (iRubyObject instanceof RubyFixnum) {
            long l = ((RubyFixnum)iRubyObject).getLongValue();
            if (l == 0L) {
                if (iRubyObject2 instanceof RubyFloat) {
                    return ruby.newFloat(0.0);
                }
                return RubyFixnum.zero(ruby);
            }
            if (l == 1L) {
                return iRubyObject2;
            }
        }
        return iRubyObject.callMethod(threadContext, "*", iRubyObject2);
    }

    public static IRubyObject f_sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum && ((RubyFixnum)iRubyObject2).getLongValue() == 0L) {
            return iRubyObject;
        }
        return iRubyObject.callMethod(threadContext, "-", iRubyObject2);
    }

    public static IRubyObject f_xor(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "^", iRubyObject2);
    }

    public static IRubyObject f_abs(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "abs");
    }

    public static IRubyObject f_abs2(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "abs2");
    }

    public static IRubyObject f_arg(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "arg");
    }

    public static IRubyObject f_conjugate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "conjugate");
    }

    public static IRubyObject f_denominator(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "denominator");
    }

    public static IRubyObject f_exact_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "exact?");
    }

    public static IRubyObject f_numerator(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "numerator");
    }

    public static IRubyObject f_polar(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "polar");
    }

    public static IRubyObject f_scalar_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "scalar?");
    }

    public static IRubyObject f_divmod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "divmod", iRubyObject2);
    }

    public static IRubyObject f_floor(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "floor");
    }

    public static IRubyObject f_inspect(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "inspect");
    }

    public static IRubyObject f_negate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "-@");
    }

    public static IRubyObject f_to_f(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "to_f");
    }

    public static IRubyObject f_to_i(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "to_i");
    }

    public static IRubyObject f_to_r(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "to_r");
    }

    public static IRubyObject f_to_s(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "to_s");
    }

    public static IRubyObject f_truncate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "truncate");
    }

    public static boolean f_equal_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() == ((RubyFixnum)iRubyObject2).getLongValue();
        }
        return iRubyObject.callMethod(threadContext, "==", iRubyObject2).isTrue();
    }

    public static IRubyObject f_expt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "**", iRubyObject2);
    }

    public static IRubyObject f_idiv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "div", iRubyObject2);
    }

    public static IRubyObject f_quo(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "quo", iRubyObject2);
    }

    public static IRubyObject f_rshift(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, ">>", iRubyObject2);
    }

    public static IRubyObject f_lshift(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(threadContext, "<<", iRubyObject2);
    }

    public static boolean f_negative_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() < 0L;
        }
        return iRubyObject.callMethod(threadContext, "<", RubyFixnum.zero(threadContext.getRuntime())).isTrue();
    }

    public static boolean f_zero_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() == 0L;
        }
        return iRubyObject.callMethod(threadContext, "==", RubyFixnum.zero(threadContext.getRuntime())).isTrue();
    }

    public static boolean f_one_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue() == 1L;
        }
        return iRubyObject.callMethod(threadContext, "==", RubyFixnum.one(threadContext.getRuntime())).isTrue();
    }

    public static long i_gcd(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l == 0L) {
            return l2;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = 0L;
        while ((l & 1L) == 0L && (l2 & 1L) == 0L) {
            ++l3;
            l >>= 1;
            l2 >>= 1;
        }
        while ((l & 1L) == 0L) {
            l >>= 1;
        }
        while ((l2 & 1L) == 0L) {
            l2 >>= 1;
        }
        while (l != l2) {
            if (l2 > l) {
                long l4 = l;
                l = l2;
                l2 = l4;
            }
            l -= l2;
            while ((l & 1L) == 0L) {
                l >>= 1;
            }
        }
        return l << (int)l3;
    }

    public static IRubyObject f_gcd(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(threadContext.getRuntime(), Numeric.i_gcd(((RubyFixnum)iRubyObject).getLongValue(), ((RubyFixnum)iRubyObject2).getLongValue()));
        }
        if (Numeric.f_negative_p(threadContext, iRubyObject)) {
            iRubyObject = Numeric.f_negate(threadContext, iRubyObject);
        }
        if (Numeric.f_negative_p(threadContext, iRubyObject2)) {
            iRubyObject2 = Numeric.f_negate(threadContext, iRubyObject2);
        }
        if (Numeric.f_zero_p(threadContext, iRubyObject)) {
            return iRubyObject2;
        }
        if (Numeric.f_zero_p(threadContext, iRubyObject2)) {
            return iRubyObject;
        }
        while (true) {
            if (iRubyObject instanceof RubyFixnum) {
                if (((RubyFixnum)iRubyObject).getLongValue() == 0L) {
                    return iRubyObject2;
                }
                if (iRubyObject2 instanceof RubyFixnum) {
                    return RubyFixnum.newFixnum(threadContext.getRuntime(), Numeric.i_gcd(((RubyFixnum)iRubyObject).getLongValue(), ((RubyFixnum)iRubyObject2).getLongValue()));
                }
            }
            IRubyObject iRubyObject3 = iRubyObject;
            iRubyObject = Numeric.f_mod(threadContext, iRubyObject2, iRubyObject);
            iRubyObject2 = iRubyObject3;
        }
    }

    public static IRubyObject f_lcm(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (Numeric.f_zero_p(threadContext, iRubyObject) || Numeric.f_zero_p(threadContext, iRubyObject2)) {
            return RubyFixnum.zero(threadContext.getRuntime());
        }
        return Numeric.f_abs(threadContext, Numeric.f_mul(threadContext, Numeric.f_div(threadContext, iRubyObject, Numeric.f_gcd(threadContext, iRubyObject, iRubyObject2)), iRubyObject2));
    }

    public static long i_ilog2(ThreadContext threadContext, IRubyObject iRubyObject) {
        long l = (iRubyObject.callMethod(threadContext, "size").convertToInteger().getLongValue() - 8L) * 8L + 1L;
        if (l > 0L) {
            iRubyObject = Numeric.f_rshift(threadContext, iRubyObject, RubyFixnum.newFixnum(threadContext.getRuntime(), l));
        }
        long l2 = iRubyObject.convertToInteger().getLongValue();
        long l3 = -1L;
        while (l2 != 0L) {
            l2 >>= 1;
            ++l3;
        }
        return l + l3;
    }

    public static double ldexp(double d, long l) {
        return d * Math.pow(2.0, l);
    }

    public static double frexp(double d, long[] lArray) {
        int n = 1;
        long l = 0L;
        if (d != 0.0) {
            if (d < 0.0) {
                d = -d;
                n = -1;
            }
            while (d < 0.5) {
                d *= 2.0;
                --l;
            }
            while (d >= 1.0) {
                d *= 0.5;
                ++l;
            }
        }
        lArray[0] = l;
        return (double)n * d;
    }

    static boolean fitSqrtLong(long l) {
        return l < SQRT_LONG_MAX && l >= -SQRT_LONG_MAX;
    }

    public static IRubyObject int_pow(ThreadContext threadContext, long l, long l2) {
        boolean bl = l < 0L;
        long l3 = 1L;
        if (bl) {
            l = -l;
        }
        if ((l2 & 1L) != 0L) {
            l3 = l;
        } else {
            bl = false;
        }
        l2 &= 0xFFFFFFFFFFFFFFFEL;
        Ruby ruby = threadContext.getRuntime();
        while (true) {
            if (l2 % 2L == 0L) {
                if (!Numeric.fitSqrtLong(l)) {
                    IRubyObject iRubyObject = RubyBignum.newBignum(ruby, RubyBignum.fix2big(RubyFixnum.newFixnum(ruby, l))).op_pow(threadContext, RubyFixnum.newFixnum(ruby, l2));
                    if (l3 != 1L) {
                        iRubyObject = RubyBignum.newBignum(ruby, RubyBignum.fix2big(RubyFixnum.newFixnum(ruby, bl ? -l3 : l3))).op_mul(threadContext, iRubyObject);
                    }
                    return iRubyObject;
                }
                l *= l;
                l2 >>= 1;
                continue;
            }
            long l4 = l * l;
            if (l4 / l != l3) {
                IRubyObject iRubyObject = RubyBignum.newBignum(ruby, RubyBignum.fix2big(RubyFixnum.newFixnum(ruby, l))).op_pow(threadContext, RubyFixnum.newFixnum(ruby, l2));
                if (l3 != 1L) {
                    iRubyObject = RubyBignum.newBignum(ruby, RubyBignum.fix2big(RubyFixnum.newFixnum(ruby, bl ? -l3 : l3))).op_mul(threadContext, iRubyObject);
                }
                return iRubyObject;
            }
            l3 = l4;
            if (--l2 == 0L) break;
        }
        if (bl) {
            l3 = -l3;
        }
        return RubyFixnum.newFixnum(ruby, l3);
    }

    public static final class RationalPatterns {
        public static final Regex rat_pat;
        public static final Regex an_e_pat;
        public static final Regex a_dot_pat;

        static {
            String string = "(?:\\d(?:_\\d|\\d)*)";
            String string2 = "(?:" + string + "?\\.)?" + string + "(?:[eE][-+]?" + string + ")?";
            String string3 = string;
            String string4 = "\\A([-+])?(" + string2 + ")(?:\\/(" + string3 + "))?";
            rat_pat = new Regex(string4.getBytes(), 0, string4.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            an_e_pat = new Regex("[Ee]".getBytes(), 0, 4, 0, (Encoding)ASCIIEncoding.INSTANCE);
            a_dot_pat = new Regex("\\.".getBytes(), 0, 2, 0, (Encoding)ASCIIEncoding.INSTANCE);
        }
    }

    public static final class ComplexPatterns {
        public static final Regex comp_pat0;
        public static final Regex comp_pat1;
        public static final Regex comp_pat2;
        public static final Regex underscores_pat;

        static {
            String string = "(?:\\d(?:_\\d|\\d)*)";
            String string2 = "(?:" + string + "?\\.)?" + string + "(?:[eE][-+]?" + string + ")?";
            String string3 = string;
            String string4 = "[-+]?" + string2 + "(?:\\/" + string3 + ")?";
            String string5 = string2 + "(?:\\/" + string3 + ")?";
            String string6 = "\\A(" + string4 + ")@(" + string4 + ")";
            String string7 = "\\A([-+])?(" + string4 + ")?[iIjJ]";
            String string8 = "\\A(" + string4 + ")(([-+])(" + string5 + ")?[iIjJ])?";
            comp_pat0 = new Regex(string6.getBytes(), 0, string6.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            comp_pat1 = new Regex(string7.getBytes(), 0, string7.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            comp_pat2 = new Regex(string8.getBytes(), 0, string8.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            underscores_pat = new Regex("_+".getBytes(), 0, 2, 0, (Encoding)ASCIIEncoding.INSTANCE);
        }
    }
}

