/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.util.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.ext.posix.POSIX;
import org.jruby.nb.nb.nb.RubyIO;
import org.jruby.nb.nb.nb.util.JRubyFile;
import org.jruby.nb.nb.nb.util.io.BadDescriptorException;
import org.jruby.nb.nb.nb.util.io.DirectoryAsFileException;
import org.jruby.nb.nb.nb.util.io.FileExistsException;
import org.jruby.nb.nb.nb.util.io.InvalidValueException;
import org.jruby.nb.nb.nb.util.io.ModeFlags;
import org.jruby.nb.nb.nb.util.io.NullChannel;
import org.jruby.nb.nb.nb.util.io.PipeException;
import org.jruby.util.ByteList;

public class ChannelDescriptor {
    private static final boolean DEBUG = false;
    private Channel channel;
    private int fileno;
    private FileDescriptor fileDescriptor;
    private ModeFlags originalModes;
    private AtomicInteger refCounter;
    private InputStream baseInputStream;
    private boolean canBeSeekable = true;

    private ChannelDescriptor(Channel channel, int n, ModeFlags modeFlags, FileDescriptor fileDescriptor, AtomicInteger atomicInteger, boolean bl) {
        this.refCounter = atomicInteger;
        this.channel = channel;
        this.fileno = n;
        this.originalModes = modeFlags;
        this.fileDescriptor = fileDescriptor;
        this.canBeSeekable = bl;
    }

    public ChannelDescriptor(Channel channel, int n, ModeFlags modeFlags, FileDescriptor fileDescriptor) {
        this(channel, n, modeFlags, fileDescriptor, new AtomicInteger(1), true);
    }

    public ChannelDescriptor(InputStream inputStream, int n, ModeFlags modeFlags, FileDescriptor fileDescriptor) {
        this(Channels.newChannel(inputStream), n, modeFlags, fileDescriptor, new AtomicInteger(1), true);
        this.baseInputStream = inputStream;
    }

    public ChannelDescriptor(Channel channel, int n, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, n, ChannelDescriptor.getModesFromChannel(channel), fileDescriptor);
    }

    public int getFileno() {
        return this.fileno;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    InputStream getBaseInputStream() {
        return this.baseInputStream;
    }

    public boolean isSeekable() {
        return this.canBeSeekable && this.channel instanceof FileChannel;
    }

    public void setCanBeSeekable(boolean bl) {
        this.canBeSeekable = bl;
    }

    public boolean isNull() {
        return this.channel instanceof NullChannel;
    }

    public boolean isWritable() {
        return this.channel instanceof WritableByteChannel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void checkOpen() throws BadDescriptorException {
        if (!this.isOpen()) {
            throw new BadDescriptorException();
        }
    }

    public ModeFlags getOriginalModes() {
        return this.originalModes;
    }

    public void checkNewModes(ModeFlags modeFlags) throws InvalidValueException {
        if (!modeFlags.isSubsetOf(this.originalModes)) {
            throw new InvalidValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup() {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            int n = RubyIO.getNewFileno();
            return new ChannelDescriptor(this.channel, n, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup2(int n) {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            return new ChannelDescriptor(this.channel, n, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dup2Into(ChannelDescriptor channelDescriptor) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            channelDescriptor.close();
            channelDescriptor.channel = this.channel;
            channelDescriptor.fileno = this.fileno;
            channelDescriptor.originalModes = this.originalModes;
            channelDescriptor.fileDescriptor = this.fileDescriptor;
            channelDescriptor.refCounter = this.refCounter;
            channelDescriptor.canBeSeekable = this.canBeSeekable;
        }
    }

    public long lseek(long l, int n) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.channel instanceof FileChannel) {
            this.checkOpen();
            FileChannel fileChannel = (FileChannel)this.channel;
            try {
                long l2;
                switch (n) {
                    case 0: {
                        l2 = l;
                        fileChannel.position(l2);
                        break;
                    }
                    case 1: {
                        l2 = fileChannel.position() + l;
                        fileChannel.position(l2);
                        break;
                    }
                    case 2: {
                        l2 = fileChannel.size() + l;
                        fileChannel.position(l2);
                        break;
                    }
                    default: {
                        throw new InvalidValueException();
                    }
                }
                return l2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidValueException();
            }
        }
        throw new PipeException();
    }

    public int read(int n, ByteList byteList) throws IOException, BadDescriptorException {
        this.checkOpen();
        byteList.ensure(byteList.length() + n);
        int n2 = this.read(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin() + byteList.length(), n));
        if (n2 > 0) {
            byteList.length(byteList.length() + n2);
        }
        return n2;
    }

    public int read(ByteBuffer byteBuffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        ReadableByteChannel readableByteChannel = (ReadableByteChannel)this.channel;
        int n = 0;
        n = readableByteChannel.read(byteBuffer);
        return n;
    }

    public int internalWrite(ByteBuffer byteBuffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        WritableByteChannel writableByteChannel = (WritableByteChannel)this.channel;
        if (this.isSeekable() && this.originalModes.isAppendable()) {
            FileChannel fileChannel = (FileChannel)this.channel;
            fileChannel.position(fileChannel.size());
        }
        return writableByteChannel.write(byteBuffer);
    }

    public int write(ByteBuffer byteBuffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(byteBuffer);
    }

    public int write(ByteList byteList) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length()));
    }

    public int write(ByteList byteList, int n, int n2) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin() + n, n2));
    }

    public int write(int n) throws IOException, BadDescriptorException {
        this.checkOpen();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.put((byte)n);
        byteBuffer.flip();
        return this.internalWrite(byteBuffer);
    }

    public static ChannelDescriptor open(String string, String string2, ModeFlags modeFlags) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(string, string2, modeFlags, 0, null);
    }

    public static ChannelDescriptor open(String string, String string2, ModeFlags modeFlags, int n, POSIX pOSIX) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        boolean bl = false;
        if (string2.equals("/dev/null") || string2.equalsIgnoreCase("nul:") || string2.equalsIgnoreCase("nul")) {
            NullChannel nullChannel = new NullChannel();
            return new ChannelDescriptor(nullChannel, RubyIO.getNewFileno(), modeFlags, new FileDescriptor());
        }
        if (string2.startsWith("file:")) {
            String string3 = string2.substring(5, string2.indexOf("!"));
            String string4 = string2.substring(string2.indexOf("!") + 2);
            if (!new File(string3).exists()) {
                throw new FileNotFoundException(string2);
            }
            JarFile jarFile = new JarFile(string3);
            ZipEntry zipEntry = jarFile.getEntry(string4);
            if (zipEntry == null) {
                throw new FileNotFoundException(string2);
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            return new ChannelDescriptor(Channels.newChannel(inputStream), RubyIO.getNewFileno(), modeFlags, new FileDescriptor());
        }
        JRubyFile jRubyFile = JRubyFile.create(string, string2);
        if (jRubyFile.isDirectory() && modeFlags.isWritable()) {
            throw new DirectoryAsFileException();
        }
        if (modeFlags.isCreate()) {
            if (jRubyFile.exists() && modeFlags.isExclusive()) {
                throw new FileExistsException(string2);
            }
            bl = jRubyFile.createNewFile();
        } else if (!jRubyFile.exists()) {
            throw new FileNotFoundException(string2);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(jRubyFile, modeFlags.toJavaModeString());
        if (bl && pOSIX != null && n != -1) {
            pOSIX.chmod(jRubyFile.getPath(), n);
        }
        if (modeFlags.isTruncate()) {
            randomAccessFile.setLength(0L);
        }
        return new ChannelDescriptor(randomAccessFile.getChannel(), RubyIO.getNewFileno(), modeFlags, randomAccessFile.getFD());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            if (this.refCounter.get() <= 0) {
                throw new BadDescriptorException();
            }
            if (!this.channel.isOpen()) {
                throw new BadDescriptorException();
            }
            int n = this.refCounter.decrementAndGet();
            if (n <= 0) {
                this.channel.close();
            }
        }
    }

    private static ModeFlags getModesFromChannel(Channel channel) throws InvalidValueException {
        ModeFlags modeFlags = channel instanceof ReadableByteChannel ? (channel instanceof WritableByteChannel ? new ModeFlags(2L) : new ModeFlags(0L)) : (channel instanceof WritableByteChannel ? new ModeFlags(1L) : new ModeFlags(2L));
        return modeFlags;
    }
}

