/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.runtime.CallType;

public class MethodIndex {
    public static final List<String> NAMES = new ArrayList<String>();
    private static final Map<String, Integer> NUMBERS = new HashMap<String, Integer>();
    private static final Map<Integer, CallSite> CALL_SITES = new HashMap<Integer, CallSite>();
    private static final Map<Integer, CallSite> FUNCTIONAL_CALL_SITES = new HashMap<Integer, CallSite>();
    private static final Map<Integer, CallSite> VARIABLE_CALL_SITES = new HashMap<Integer, CallSite>();
    public static final int NO_INDEX = MethodIndex.getIndex("");
    public static final int OP_PLUS = MethodIndex.getIndex("+");
    public static final int OP_MINUS = MethodIndex.getIndex("-");
    public static final int OP_LT = MethodIndex.getIndex("<");
    public static final int AREF = MethodIndex.getIndex("[]");
    public static final int ASET = MethodIndex.getIndex("[]=");
    public static final int EQUALEQUAL = MethodIndex.getIndex("==");
    public static final int OP_LSHIFT = MethodIndex.getIndex("<<");
    public static final int EMPTY_P = MethodIndex.getIndex("empty?");
    public static final int TO_S = MethodIndex.getIndex("to_s");
    public static final int TO_I = MethodIndex.getIndex("to_i");
    public static final int TO_STR = MethodIndex.getIndex("to_str");
    public static final int TO_ARY = MethodIndex.getIndex("to_ary");
    public static final int TO_INT = MethodIndex.getIndex("to_int");
    public static final int TO_F = MethodIndex.getIndex("to_f");
    public static final int TO_A = MethodIndex.getIndex("to_a");
    public static final int TO_IO = MethodIndex.getIndex("to_io");
    public static final int HASH = MethodIndex.getIndex("hash");
    public static final int OP_GT = MethodIndex.getIndex(">");
    public static final int OP_TIMES = MethodIndex.getIndex("*");
    public static final int OP_LE = MethodIndex.getIndex("<=");
    public static final int OP_SPACESHIP = MethodIndex.getIndex("<=>");
    public static final int OP_EQQ = MethodIndex.getIndex("===");
    public static final int EQL_P = MethodIndex.getIndex("eql?");
    public static final int TO_HASH = MethodIndex.getIndex("to_hash");
    public static final int METHOD_MISSING = MethodIndex.getIndex("method_missing");
    public static final int DEFAULT = MethodIndex.getIndex("default");

    public static synchronized int getIndex(String string) {
        Integer n = NUMBERS.get(string);
        if (n == null) {
            n = new Integer(NAMES.size());
            NUMBERS.put(string, n);
            NAMES.add(string);
        }
        return n;
    }

    public static synchronized CallSite getCallSite(String string) {
        if (!RubyInstanceConfig.FASTOPS_COMPILE_ENABLED) {
            return new CallSite.InlineCachingCallSite(string, CallType.NORMAL);
        }
        if (string.equals("+")) {
            return new CallSite.PlusCallSite();
        }
        if (string.equals("-")) {
            return new CallSite.MinusCallSite();
        }
        if (string.equals("*")) {
            return new CallSite.MulCallSite();
        }
        if (string.equals("/")) {
            return new CallSite.DivCallSite();
        }
        if (string.equals("<")) {
            return new CallSite.LtCallSite();
        }
        if (string.equals("<=")) {
            return new CallSite.LeCallSite();
        }
        if (string.equals(">")) {
            return new CallSite.GtCallSite();
        }
        if (string.equals(">=")) {
            return new CallSite.GeCallSite();
        }
        return new CallSite.InlineCachingCallSite(string, CallType.NORMAL);
    }

    public static synchronized CallSite getFunctionalCallSite(String string) {
        return new CallSite.InlineCachingCallSite(string, CallType.FUNCTIONAL);
    }

    public static synchronized CallSite getVariableCallSite(String string) {
        return new CallSite.InlineCachingCallSite(string, CallType.VARIABLE);
    }
}

