/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.callback;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.exceptions.MainExitException;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.exceptions.ThreadKill;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.callback.Callback;

public abstract class InvocationCallback
implements Callback {
    public static final Class[] EMPTY_ARGS = new Class[0];
    public static final Class[] OPTIONAL_ARGS = new Class[]{IRubyObject[].class};
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes = EMPTY_ARGS;
    private String javaName;
    private boolean isSingleton;

    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (this.arityValue >= 0) {
            if (iRubyObjectArray.length != this.arityValue) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + this.arityValue + ")");
            }
        } else if (iRubyObjectArray.length < -(1 + this.arityValue)) {
            throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(iRubyObject, iRubyObjectArray, block);
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (JumpException jumpException) {
            throw jumpException;
        }
        catch (ThreadKill threadKill) {
            throw threadKill;
        }
        catch (MainExitException mainExitException) {
            throw mainExitException;
        }
        catch (Exception exception) {
            Ruby ruby = iRubyObject.getRuntime();
            ruby.getJavaSupport().handleNativeException(exception);
            return ruby.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2, Block var3);

    public void setArity(Arity arity) {
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    public void setArgumentTypes(Class[] classArray) {
        this.argumentTypes = classArray;
    }

    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean bl) {
        this.isSingleton = bl;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }
}

