/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.scope;

import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.parser.BlockStaticScope;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.scope.ThreeVarDynamicScope;

public class FourVarDynamicScope
extends ThreeVarDynamicScope {
    private static final int SIZE = 4;
    private static final String SIZE_ERROR = "FourVarDynamicScope only supports scopes with four variables";
    private static final String GROW_ERROR = "FourVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueThree;

    public FourVarDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public FourVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 4) {
            throw new RuntimeException(GROW_ERROR);
        }
    }

    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (n < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (n) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
            case 3: {
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        if (n2 > 0) {
            return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
        }
        return this.getValueDepthZeroOrNil(n, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (n < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (n) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = iRubyObject;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = iRubyObject;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = iRubyObject;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
            case 3: {
                if (this.variableValueThree == null) {
                    this.variableValueThree = iRubyObject;
                    return this.variableValueThree;
                }
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValueThree == null) {
            this.variableValueThree = iRubyObject;
            return this.variableValueThree;
        }
        return this.variableValueThree;
    }

    public IRubyObject setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(n, iRubyObject, n2 - 1);
        }
        assert (n < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (n) {
            case 0: {
                this.variableValueZero = iRubyObject;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = iRubyObject;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = iRubyObject;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = iRubyObject;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (n) {
            case 0: {
                this.variableValueZero = iRubyObject;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = iRubyObject;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = iRubyObject;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = iRubyObject;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject iRubyObject) {
        this.variableValueThree = iRubyObject;
        return this.variableValueThree;
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (n <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (n) {
            case 4: {
                this.variableValueThree = iRubyObjectArray[3];
            }
            case 3: {
                this.variableValueTwo = iRubyObjectArray[2];
            }
            case 2: {
                this.variableValueOne = iRubyObjectArray[1];
            }
            case 1: {
                this.variableValueZero = iRubyObjectArray[0];
            }
        }
    }

    public void setArgValues(IRubyObject iRubyObject) {
        this.variableValueZero = iRubyObject;
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.variableValueZero = iRubyObject;
        this.variableValueOne = iRubyObject2;
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.variableValueZero = iRubyObject;
        this.variableValueOne = iRubyObject2;
        this.variableValueTwo = iRubyObject3;
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (n) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
                case 3: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
                }
                case 4: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        switch (n) {
            case 4: {
                iRubyObjectArray[3] = this.variableValueThree;
            }
            case 3: {
                iRubyObjectArray[2] = this.variableValueTwo;
            }
            case 2: {
                iRubyObjectArray[1] = this.variableValueOne;
            }
            case 1: {
                iRubyObjectArray[0] = this.variableValueZero;
            }
        }
        return iRubyObjectArray;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] stringArray = this.staticScope.getVariables();
        stringBuffer.append(stringArray[0]).append("=");
        if (this.variableValueZero == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueZero);
        }
        stringBuffer.append(",");
        if (this.variableValueOne == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueOne);
        }
        stringBuffer.append(",");
        if (this.variableValueTwo == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueTwo);
        }
        stringBuffer.append(",");
        if (this.variableValueThree == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueThree);
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

