/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.scope;

import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.parser.BlockStaticScope;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.scope.NoVarsDynamicScope;

public class OneVarDynamicScope
extends NoVarsDynamicScope {
    protected IRubyObject variableValueZero;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 1) {
            throw new RuntimeException("OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero};
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (n == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        return this.variableValueZero;
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        if (n2 > 0) {
            return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
        }
        return this.getValueDepthZeroOrNil(n, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (n == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        if (this.variableValueZero == null) {
            this.variableValueZero = iRubyObject;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValueZero == null) {
            this.variableValueZero = iRubyObject;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    public IRubyObject setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(n, iRubyObject, n2 - 1);
        }
        assert (n == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValueZero = iRubyObject;
        return this.variableValueZero;
    }

    public IRubyObject setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValueZero = iRubyObject;
        return this.variableValueZero;
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject iRubyObject) {
        this.variableValueZero = iRubyObject;
        return this.variableValueZero;
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (iRubyObjectArray.length == 1) : "SingleVarDynamicScope only supports one variable";
        if (n == 1) {
            this.variableValueZero = iRubyObjectArray[0];
        }
    }

    public void setArgValues(IRubyObject iRubyObject) {
        this.variableValueZero = iRubyObject;
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        assert (false) : "SingleVarDynamicScope only supports one variable not two";
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (false) : "SingleVarDynamicScope only supports one variable not three";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n <= 1) : "OneVarDynamicScope only supports one variable";
        if (this.staticScope.getRestArg() < 0) {
            if (n == 1) {
                return new IRubyObject[]{this.variableValueZero};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        if (n == 1) {
            iRubyObjectArray[0] = this.variableValueZero;
        }
        return iRubyObjectArray;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] stringArray = this.staticScope.getVariables();
        stringBuffer.append(stringArray[0]).append("=");
        if (this.variableValueZero == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueZero);
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

