/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private final IRubyObject io;
    private final CallSite writeAdapter;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOOutputStream(IRubyObject iRubyObject) {
        if (iRubyObject.respondsTo("write")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("write");
        } else if (iRubyObject.respondsTo("<<")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("<<");
        } else {
            throw new IllegalArgumentException("Object: " + iRubyObject + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = iRubyObject;
    }

    public void write(int n) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)n}, false)));
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(byArray, n, n2, false)));
    }

    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io);
        }
    }
}

