/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Join {
    public static final Executor TRIVIAL_EXECUTOR = new Executor(){

        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    };
    private final Executor executor;
    private final LinkedList[] writes;
    private final long asyncMask;
    private long mask = 0L;
    private final Reaction[][] reactionsPerChannel;

    private Join(long l, Reaction[][] reactionArray, Executor executor) {
        LinkedList[] linkedListArray = new LinkedList[reactionArray.length];
        for (int i = 0; i < linkedListArray.length; ++i) {
            if (reactionArray[i] == null) continue;
            linkedListArray[i] = new LinkedList();
        }
        this.asyncMask = l;
        this.reactionsPerChannel = reactionArray;
        this.writes = linkedListArray;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRaw(int n, Object object) {
        Reaction reaction = null;
        Object[] objectArray = null;
        Join join = this;
        synchronized (join) {
            Reaction[] reactionArray;
            LinkedList linkedList = this.writes[n];
            if (linkedList == null) {
                throw new IndexOutOfBoundsException();
            }
            linkedList.addLast(object);
            this.mask |= 1L << n;
            for (Reaction reaction2 : reactionArray = this.reactionsPerChannel[n]) {
                if ((reaction2.mask & this.mask) != reaction2.mask) continue;
                int[] nArray = reaction2.indices;
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i];
                    LinkedList linkedList2 = this.writes[n2];
                    objectArray[i] = linkedList2.removeFirst();
                    if (!linkedList2.isEmpty()) continue;
                    this.mask &= 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
                }
                reaction = reaction2;
                break;
            }
        }
        if (reaction != null) {
            reaction.dispatch(this, objectArray);
        }
    }

    public boolean isAsync(int n) {
        return (1L << n & this.asyncMask) != 0L;
    }

    public void send(int n, Object object) {
        if (this.isAsync(n)) {
            this.sendRaw(n, object);
        } else {
            this.sendRaw(n, new AsyncCall(object));
        }
    }

    public void send(Enum<?> enum_, Object object) {
        this.send(enum_.ordinal(), object);
    }

    public Object call(int n, Object object) {
        if (this.isAsync(n)) {
            this.sendRaw(n, object);
            return null;
        }
        SyncCall syncCall = new SyncCall(object);
        this.sendRaw(n, syncCall);
        return syncCall.call();
    }

    public Object call(Enum<?> enum_, Object object) {
        return this.call(enum_.ordinal(), object);
    }

    private static class SyncCall
    extends Call {
        private Join join = null;
        private SyncReaction reaction = null;
        private Object[] args = null;

        public SyncCall(Object object) {
            super(object);
        }

        public synchronized void activate(Join join, SyncReaction syncReaction, Object[] objectArray) {
            this.join = join;
            this.reaction = syncReaction;
            this.args = objectArray;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object call() {
            boolean bl = false;
            try {
                while (this.reaction == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                Object var4_3 = null;
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            return this.reaction.react(this.join, this.args);
        }
    }

    private static class AsyncCall
    extends Call {
        public AsyncCall(Object object) {
            super(object);
        }

        public void activate(final Join join, final SyncReaction syncReaction, final Object[] objectArray) {
            join.executor.execute(new Runnable(){

                public void run() {
                    syncReaction.react(join, objectArray);
                }
            });
        }
    }

    private static abstract class Call {
        private final Object message;

        public Call(Object object) {
            this.message = object;
        }

        public Object getMessage() {
            return this.message;
        }

        public abstract void activate(Join var1, SyncReaction var2, Object[] var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SyncReaction
    extends Reaction {
        public SyncReaction(int[] nArray) {
            super((int[])nArray.clone(), false);
        }

        public SyncReaction(Enum<?> enum_, Enum<?> ... enumArray) {
            super(enum_, enumArray, false);
        }

        @Override
        void dispatch(Join join, Object[] objectArray) {
            Call call = (Call)objectArray[0];
            objectArray[0] = call.getMessage();
            call.activate(join, this, objectArray);
        }

        public abstract Object react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AsyncReaction
    extends Reaction {
        public AsyncReaction(int[] nArray) {
            super((int[])nArray.clone(), true);
        }

        public AsyncReaction(Enum<?> enum_, Enum<?> ... enumArray) {
            super(enum_, enumArray, true);
        }

        @Override
        void dispatch(final Join join, final Object[] objectArray) {
            final AsyncReaction asyncReaction = this;
            join.executor.execute(new Runnable(){

                public void run() {
                    asyncReaction.react(join, objectArray);
                }
            });
        }

        public abstract void react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FastReaction
    extends Reaction {
        public FastReaction(int[] nArray) {
            super((int[])nArray.clone(), true);
        }

        public FastReaction(Enum<?> enum_, Enum<?> ... enumArray) {
            super(enum_, enumArray, true);
        }

        @Override
        void dispatch(Join join, Object[] objectArray) {
            try {
                this.react(join, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public abstract void react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Reaction {
        private final int[] indices;
        private final long mask;
        private final long asyncMask;

        private static int[] toIndices(Enum<?> enum_, Enum<?>[] enumArray) {
            int[] nArray = new int[enumArray.length + 1];
            nArray[0] = enum_.ordinal();
            for (int i = 0; i < enumArray.length; ++i) {
                nArray[i + 1] = enumArray[i].ordinal();
            }
            return nArray;
        }

        Reaction(Enum<?> enum_, Enum<?>[] enumArray, boolean bl) {
            this(Reaction.toIndices(enum_, enumArray), bl);
        }

        Reaction(int[] nArray, boolean bl) {
            long l = 0L;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n > 63) {
                    throw new IndexOutOfBoundsException();
                }
                if ((l & 1L << n) != 0L) {
                    throw new IllegalArgumentException("Duplicate channels in reaction");
                }
                l |= 1L << n;
            }
            this.indices = nArray;
            this.mask = l;
            this.asyncMask = bl ? l : l & (1L << nArray[0] ^ 0xFFFFFFFFFFFFFFFFL);
        }

        abstract void dispatch(Join var1, Object[] var2);
    }

    public static class Spec {
        private ArrayList<ArrayList<Reaction>> reactionsPerChannel = new ArrayList();
        private long asyncMask = 0L;
        private long mask = 0L;
        private volatile Reaction[][] cachedReactionsPerChannel = null;
        private static final Reaction[] EMPTY_REACTIONS = new Reaction[0];

        public void addReaction(Reaction reaction) {
            if ((this.mask & (this.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & reaction.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use a synchronous channel in a non-head position");
            }
            if ((reaction.mask & (reaction.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & this.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use an asynchronous channel in the head position of a synchronous reaction");
            }
            this.cachedReactionsPerChannel = null;
            int[] nArray = reaction.indices;
            for (int i = 0; i < nArray.length; ++i) {
                ArrayList<Reaction> arrayList;
                int n = nArray[i];
                if (this.reactionsPerChannel.size() <= n) {
                    this.reactionsPerChannel.ensureCapacity(n + 1);
                    while (this.reactionsPerChannel.size() <= n) {
                        this.reactionsPerChannel.add(null);
                    }
                }
                if ((arrayList = this.reactionsPerChannel.get(n)) == null) {
                    arrayList = new ArrayList();
                    this.reactionsPerChannel.set(n, arrayList);
                }
                arrayList.add(reaction);
            }
            this.asyncMask |= reaction.asyncMask;
            this.mask |= reaction.mask;
        }

        public Join createJoin() {
            return this.createJoin(TRIVIAL_EXECUTOR);
        }

        public Join createJoin(Executor executor) {
            if (this.cachedReactionsPerChannel == null) {
                int n = this.reactionsPerChannel.size();
                Reaction[][] reactionArrayArray = new Reaction[n][];
                for (int i = 0; i < n; ++i) {
                    ArrayList<Reaction> arrayList = this.reactionsPerChannel.get(i);
                    if (arrayList == null) continue;
                    reactionArrayArray[i] = arrayList.toArray(EMPTY_REACTIONS);
                }
                this.cachedReactionsPerChannel = reactionArrayArray;
            }
            return new Join(this.asyncMask, this.cachedReactionsPerChannel, executor);
        }
    }
}

