/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import org.joni.encoding.Encoding;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public final class KCode {
    public static final KCode NIL = new KCode(null, "ASCII", 0);
    public static final KCode NONE = new KCode("NONE", "ASCII", 0);
    public static final KCode UTF8 = new KCode("UTF8", "UTF8", 64);
    public static final KCode SJIS = new KCode("SJIS", "SJIS", 48);
    public static final KCode EUC = new KCode("EUC", "EUCJP", 32);
    private final String kcode;
    private final String encodingName;
    private final int code;
    private volatile Encoding encoding;

    private KCode(String string, String string2, int n) {
        this.kcode = string;
        this.encodingName = string2;
        this.code = n;
    }

    public static KCode create(Ruby ruby, String string) {
        if (string == null) {
            return NIL;
        }
        if (string.length() == 0) {
            return NONE;
        }
        switch (string.charAt(0)) {
            case 'E': 
            case 'e': {
                return EUC;
            }
            case 'S': 
            case 's': {
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public IRubyObject kcode(Ruby ruby) {
        return this.kcode == null ? ruby.getNil() : ruby.newString(this.kcode);
    }

    public String getKCode() {
        return this.kcode;
    }

    public int bits() {
        return this.code;
    }

    public String name() {
        return this.kcode != null ? this.kcode.toLowerCase() : null;
    }

    public Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = Encoding.load((String)this.encodingName);
        }
        return this.encoding;
    }
}

