/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public class TypeConverter {
    public static final IRubyObject convertToType(IRubyObject iRubyObject, RubyClass rubyClass, int n, String string, boolean bl) {
        if (!iRubyObject.respondsTo(string)) {
            return TypeConverter.handleUncoercibleObject(bl, iRubyObject, rubyClass);
        }
        return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), n, string);
    }

    public static final IRubyObject convertToType(IRubyObject iRubyObject, RubyClass rubyClass, String string, boolean bl) {
        if (!iRubyObject.respondsTo(string)) {
            return TypeConverter.handleUncoercibleObject(bl, iRubyObject, rubyClass);
        }
        return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), string);
    }

    public static final IRubyObject convertToType(IRubyObject iRubyObject, RubyClass rubyClass, int n, String string) {
        if (rubyClass.isInstance(iRubyObject)) {
            return iRubyObject;
        }
        IRubyObject iRubyObject2 = TypeConverter.convertToType(iRubyObject, rubyClass, n, string, true);
        if (!rubyClass.isInstance(iRubyObject2)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject.getMetaClass() + "#" + string + " should return " + rubyClass.getName());
        }
        return iRubyObject2;
    }

    public static final IRubyObject convertToTypeWithCheck(IRubyObject iRubyObject, RubyClass rubyClass, int n, String string) {
        if (rubyClass.isInstance(iRubyObject)) {
            return iRubyObject;
        }
        IRubyObject iRubyObject2 = TypeConverter.convertToType(iRubyObject, rubyClass, n, string, false);
        if (iRubyObject2.isNil()) {
            return iRubyObject2;
        }
        if (!rubyClass.isInstance(iRubyObject2)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject.getMetaClass() + "#" + string + " should return " + rubyClass.getName());
        }
        return iRubyObject2;
    }

    public static final IRubyObject convertToTypeOrRaise(IRubyObject iRubyObject, RubyClass rubyClass, String string) {
        if (rubyClass.isInstance(iRubyObject)) {
            return iRubyObject;
        }
        IRubyObject iRubyObject2 = TypeConverter.convertToType(iRubyObject, rubyClass, string, true);
        if (iRubyObject2.isNil()) {
            return iRubyObject2;
        }
        if (!rubyClass.isInstance(iRubyObject2)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject.getMetaClass() + "#" + string + " should return " + rubyClass.getName());
        }
        return iRubyObject2;
    }

    private static IRubyObject handleUncoercibleObject(boolean bl, IRubyObject iRubyObject, RubyClass rubyClass) throws RaiseException {
        if (bl) {
            String string = iRubyObject.isNil() ? "nil" : (iRubyObject instanceof RubyBoolean ? (iRubyObject.isTrue() ? "true" : "false") : iRubyObject.getMetaClass().getRealClass().getName());
            throw iRubyObject.getRuntime().newTypeError("can't convert " + string + " into " + rubyClass);
        }
        return iRubyObject.getRuntime().getNil();
    }
}

