/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public class JRubyObjectInputStream
extends RubyObject {
    JRubyObjectInputStreamImpl impl;
    private static final ObjectAllocator JROIS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyObjectInputStream(ruby, rubyClass);
        }
    };

    public static RubyClass createJRubyObjectInputStream(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("JRubyObjectInputStream", ruby.getObject(), JROIS_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JRubyObjectInputStream.class);
        return rubyClass;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2 = ((RubyClass)iRubyObject).allocate();
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "initialize", iRubyObjectArray, block);
        return iRubyObject2;
    }

    public JRubyObjectInputStream(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject) throws IOException {
        InputStream inputStream = (InputStream)JavaUtil.convertRubyToJava(iRubyObject, InputStream.class);
        this.impl = new JRubyObjectInputStreamImpl(this.getRuntime(), inputStream);
        return this;
    }

    @JRubyMethod(name={"read_object"}, alias={"readObject"})
    public IRubyObject readObject() throws IOException, ClassNotFoundException {
        return JavaObject.wrap(this.getRuntime(), this.impl.readObject());
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() throws IOException {
        this.impl.close();
        return this;
    }

    class JRubyObjectInputStreamImpl
    extends ObjectInputStream {
        protected Ruby runtime;

        public JRubyObjectInputStreamImpl(Ruby ruby, InputStream inputStream) throws IOException {
            super(inputStream);
            this.runtime = ruby;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return Class.forName(objectStreamClass.getName(), true, this.runtime.getJRubyClassLoader());
        }
    }
}

