/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util.io;

import org.jruby.nb.nb.util.io.InvalidValueException;

public class ModeFlags
implements Cloneable {
    public static final int RDONLY = 0;
    public static final int WRONLY = 1;
    public static final int RDWR = 2;
    public static final int CREAT = 256;
    public static final int EXCL = 1024;
    public static final int NOCTTY = 256;
    public static final int TRUNC = 512;
    public static final int APPEND = 8;
    public static final int NONBLOCK = 4;
    public static final int BINARY = 32768;
    public static final int ACCMODE = 65536;
    private final int flags;

    public ModeFlags() {
        this.flags = 0;
    }

    public ModeFlags(long l) throws InvalidValueException {
        this.flags = (int)l;
        if (this.isReadOnly() && (l & 8L) != 0L) {
            throw new InvalidValueException();
        }
    }

    public String toJavaModeString() {
        if (this.isWritable() || this.isCreate() || this.isTruncate()) {
            return "rw";
        }
        return "r";
    }

    public boolean isReadOnly() {
        return (this.flags & 1) == 0 && (this.flags & 2) == 0;
    }

    public boolean isReadable() {
        return (this.flags & 2) != 0 || this.isReadOnly();
    }

    public boolean isBinary() {
        return (this.flags & 0x8000) != 0;
    }

    public boolean isCreate() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isWritable() {
        return (this.flags & 2) != 0 || (this.flags & 1) != 0;
    }

    public boolean isExclusive() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isAppendable() {
        return (this.flags & 8) != 0;
    }

    public boolean isTruncate() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isSubsetOf(ModeFlags modeFlags) {
        return !(!modeFlags.isReadable() && this.isReadable() || !modeFlags.isWritable() && this.isWritable()) && (modeFlags.isAppendable() || !this.isAppendable());
    }

    public String toString() {
        return "" + this.flags;
    }

    public int getOpenFileFlags() {
        int n = 0;
        int n2 = this.flags & 3;
        n = n2 == 0 ? 1 : (n2 == 1 ? 2 : 3);
        if ((this.flags & 8) != 0) {
            n |= 0x40;
        }
        if ((this.flags & 0x100) != 0) {
            n |= 0x80;
        }
        if ((this.flags & 0x8000) == 32768) {
            n |= 4;
        }
        return n;
    }
}

