/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;

public class AstNodeUtils {
    private static final String INDENT = "   ";

    public static void dumpTree(AstNode astNode) {
        AstNodeUtils.dump(astNode, "");
    }

    private static void dump(AstNode astNode, String string) {
        System.out.println(string + astNode.toString());
        for (AstNode astNode2 : astNode.children()) {
            AstNodeUtils.dump(astNode2, INDENT);
        }
    }

    public static AstNode getRoot(AstNode astNode) {
        while (astNode.parent() != null) {
            astNode = astNode.parent();
        }
        return astNode;
    }

    public static AstNode findDescendant(AstNode astNode, int n) {
        int n2 = astNode.startOffset();
        int n3 = astNode.endOffset();
        if (n < n2 || n > n3) {
            return null;
        }
        if (n >= n2 && n < n3 && astNode.children().isEmpty()) {
            return astNode;
        }
        for (AstNode astNode2 : astNode.children()) {
            int n4 = astNode2.startOffset();
            int n5 = astNode2.endOffset();
            if (n < n4 || n >= n5) continue;
            return AstNodeUtils.findDescendant(astNode2, n);
        }
        return astNode;
    }

    public static void visitChildren(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        for (AstNode astNode2 : astNode.children()) {
            astNodeVisitor.visit(astNode2);
            AstNodeUtils.visitChildren(astNode2, astNodeVisitor);
        }
    }

    public static void visitAncestors(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        AstNode astNode2 = astNode.parent();
        if (astNode2 != null) {
            astNodeVisitor.visit(astNode2);
            AstNodeUtils.visitAncestors(astNode2, astNodeVisitor);
        }
    }
}

