/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxTree {
    public static AstNode makeTree(List<SyntaxElement> list) {
        SyntaxElement syntaxElement = list.size() > 0 ? list.get(list.size() - 1) : null;
        int n = syntaxElement == null ? 0 : syntaxElement.offset() + syntaxElement.length();
        AstNode astNode = new AstNode("root", null, 0, n);
        LinkedList<AstNode> linkedList = new LinkedList<AstNode>();
        linkedList.add(astNode);
        for (SyntaxElement syntaxElement2 : list) {
            AstNode astNode2;
            Object object;
            if (syntaxElement2.type() == 4) {
                object = ((SyntaxElement.Named)syntaxElement2).getName();
                int n2 = syntaxElement2.offset() + syntaxElement2.length();
                AstNode astNode3 = new AstNode((String)object, AstNode.NodeType.TAG, syntaxElement2.offset(), n2);
                linkedList.getLast().addChild(astNode3);
                assert (syntaxElement2 instanceof SyntaxElement.Tag);
                if (!((SyntaxElement.Tag)syntaxElement2).isEmpty()) {
                    linkedList.add(astNode3);
                }
                astNode2 = new AstNode((String)object, AstNode.NodeType.OPEN_TAG, syntaxElement2.offset(), n2);
                astNode3.addChild(astNode2);
                continue;
            }
            if (syntaxElement2.type() == 5) {
                int n3;
                object = ((SyntaxElement.Named)syntaxElement2).getName();
                for (n3 = linkedList.size() - 1; !((String)object).equals(linkedList.get(n3).name()) && n3 > 0; --n3) {
                }
                int n4 = syntaxElement2.offset() + syntaxElement2.length();
                astNode2 = new AstNode((String)object, AstNode.NodeType.ENDTAG, syntaxElement2.offset(), n4);
                if (((String)object).equals(linkedList.get(n3).name())) {
                    int n5 = linkedList.size() - n3 - 1;
                    SyntaxTree.removeNLastNodes(n5, linkedList);
                    linkedList.getLast().addChild(astNode2);
                    linkedList.getLast().setEndOffset(n4);
                    linkedList.removeLast();
                    continue;
                }
                AstNode astNode4 = new AstNode((String)object, AstNode.NodeType.TAG, syntaxElement2.offset(), n4);
                astNode4.markUnmatched();
                linkedList.getLast().addChild(astNode4);
                linkedList.add(astNode4);
                astNode4.addChild(astNode2);
                continue;
            }
            object = SyntaxTree.intToNodeType(syntaxElement2.type());
            AstNode astNode5 = new AstNode(null, (AstNode.NodeType)((Object)object), syntaxElement2.offset(), syntaxElement2.offset() + syntaxElement2.length());
            if (object == AstNode.NodeType.DECLARATION) {
                astNode5.setAttribute("public_id", ((SyntaxElement.Declaration)syntaxElement2).getPublicIdentifier());
            }
            linkedList.getLast().addChild(astNode5);
        }
        SyntaxTree.removeNLastNodes(linkedList.size() - 1, linkedList);
        return astNode;
    }

    private static void removeNLastNodes(int n, LinkedList<AstNode> linkedList) {
        LinkedList<LinkedList> linkedList2 = new LinkedList<LinkedList>();
        for (int i = 0; i < n; ++i) {
            LinkedList linkedList3 = new LinkedList();
            linkedList.getLast().markUnmatched();
            for (AstNode astNode : linkedList.getLast().children()) {
                if (astNode.type() != AstNode.NodeType.TAG && astNode.type() != AstNode.NodeType.UNMATCHED_TAG) continue;
                linkedList3.add(astNode);
            }
            linkedList.getLast().removeTagChildren();
            linkedList.removeLast();
            linkedList2.addFirst(linkedList3);
        }
        for (LinkedList linkedList3 : linkedList2) {
            for (AstNode astNode : linkedList3) {
                linkedList.getLast().addChild(astNode);
            }
        }
    }

    private static AstNode.NodeType intToNodeType(int n) {
        switch (n) {
            case 0: {
                return AstNode.NodeType.COMMENT;
            }
            case 1: {
                return AstNode.NodeType.DECLARATION;
            }
            case 5: {
                return AstNode.NodeType.ENDTAG;
            }
            case 6: {
                return AstNode.NodeType.ENTITY_REFERENCE;
            }
            case 2: {
                return AstNode.NodeType.ERROR;
            }
            case 4: {
                return AstNode.NodeType.OPEN_TAG;
            }
            case 3: {
                return AstNode.NodeType.TEXT;
            }
        }
        return null;
    }
}

