/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.dbmodel;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.sql.project.dbmodel.ForeignKeyColumn;
import org.netbeans.modules.sql.project.dbmodel.IndexColumn;
import org.netbeans.modules.sql.project.dbmodel.KeyColumn;
import org.netbeans.modules.sql.project.dbmodel.Parameter;
import org.netbeans.modules.sql.project.dbmodel.PrepStmt;
import org.netbeans.modules.sql.project.dbmodel.Procedure;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumn;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumns;
import org.netbeans.modules.sql.project.dbmodel.Table;
import org.netbeans.modules.sql.project.dbmodel.TableColumn;

public class DBMetaData {
    public static final int NAME = 0;
    public static final int CATALOG = 1;
    public static final int SCHEMA = 2;
    public static final int TYPE = 3;
    public static final String DB2 = "DB2";
    public static final String ORACLE = "ORACLE";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String SYBASE = "SYBASE";
    public static final String VSAM_ADABAS_IAM = "LEGACY";
    public static final String JDBC_ODBC = "JDBCODBC";
    public static final String DB2_TEXT = "DB2";
    public static final String ORACLE_TEXT = "ORACLE";
    public static final String SQLSERVER_TEXT = "SQL SERVER";
    public static final String SYBASE_TEXT = "SYBASE";
    public static final String VSAM_ADABAS_IAM_TEXT = "VSAM/ADABAS/IAM";
    public static final String JDBCODBC_TEXT = "JDBC-ODBC";
    public static final String[] DBTYPES = new String[]{"DB2", "ORACLE", "SQL SERVER", "SYBASE", "VSAM/ADABAS/IAM", "JDBC-ODBC"};
    public static final String[] JAVATYPES = new String[]{"boolean", "byte", "byte[]", "double", "float", "int", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.net.URL", "java.sql.Array", "java.sql.Blob", "java.sql.Clob", "java.sql.Date", "java.sql.Ref", "java.sql.Struct", "java.sql.Time", "java.sql.Timestamp", "long", "short"};
    public static final String[] SQLTYPES = new String[]{"ARRAY", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "CHAR", "CLOB", "DATALINK", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "LONGVARBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR", "RESULTSET"};
    public static final int[] SQLTYPE_CODES = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, -6, -3, 12};
    public static final HashMap SQLTOJAVATYPES = new HashMap();
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";
    private static final String ALIAS = "ALIAS";
    private static final String SYNONYM = "SYNONYM";
    private Connection dbconn;
    private DatabaseMetaData dbmeta;
    private String errMsg;
    private boolean checkPrepStmtMetaData = true;
    private boolean checkProcMetaData = true;
    private boolean errPrepStmtParameters = false;
    private boolean errPrepStmtResultSetColumns = false;
    private String sqlText;

    public void checkPrimaryKeys(Table table) throws Exception {
        this.errMsg = "";
        try {
            List list = this.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
            if (list.size() != 0) {
                table.setPrimaryKeyColumnList(list);
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    KeyColumn keyColumn = (KeyColumn)list.get(i);
                    hashSet.add(keyColumn.getColumnName());
                }
                TableColumn[] tableColumnArray = table.getColumns();
                if (tableColumnArray != null) {
                    for (int i = 0; i < tableColumnArray.length; ++i) {
                        if (!hashSet.contains(tableColumnArray[i].getName())) continue;
                        tableColumnArray[i].setIsPrimaryKey(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public void checkForeignKeys(Table table) throws Exception {
        this.errMsg = "";
        try {
            List list = this.getForeignKeys(table.getCatalog(), table.getSchema(), table.getName());
            if (list != null) {
                table.setForeignKeyColumnList(list);
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    ForeignKeyColumn foreignKeyColumn = (ForeignKeyColumn)list.get(i);
                    hashSet.add(foreignKeyColumn.getColumnName());
                }
                TableColumn[] tableColumnArray = table.getColumns();
                if (tableColumnArray != null) {
                    for (int i = 0; i < tableColumnArray.length; ++i) {
                        if (!hashSet.contains(tableColumnArray[i].getName())) continue;
                        tableColumnArray[i].setIsForeignKey(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public void connectDB(String string, String string2, String string3, String string4) throws Exception {
        this.errMsg = "";
        boolean bl = false;
        try {
            Class.forName(string);
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            if (string2.startsWith("jdbc:oracle:")) {
                bl = true;
                properties.put("oracle.jdbc.V8Compatible", "true");
            }
            this.dbconn = DriverManager.getConnection(string2, properties);
            this.getDBMetaData();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.errMsg = "Could not locate JDBC driver: " + classNotFoundException.getLocalizedMessage();
            throw classNotFoundException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public void disconnectDB() throws Exception {
        this.errMsg = "";
        try {
            if (this.dbconn != null && !this.dbconn.isClosed()) {
                this.dbconn.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.errMsg = sQLException.getLocalizedMessage();
            throw sQLException;
        }
    }

    private void getDBMetaData() throws Exception {
        this.errMsg = "";
        try {
            this.dbmeta = this.dbconn.getMetaData();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.errMsg = sQLException.getLocalizedMessage();
        }
    }

    public String getDBName() throws Exception {
        String string = "";
        this.errMsg = "";
        try {
            string = this.dbmeta.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.errMsg = sQLException.getLocalizedMessage();
            throw sQLException;
        }
        return string;
    }

    public String getDBType() throws Exception {
        String string = "";
        String string2 = this.getDBName().toLowerCase();
        string = string2.equals("microsoft sql server") ? SQLSERVER : (string2.equals("sql server") || string2.indexOf("sybase") > -1 ? "SYBASE" : (string2.indexOf("db2") > -1 || string2.equals("as") ? "DB2" : (string2.equals("exadas") || string2.equals("attunity connect driver") ? VSAM_ADABAS_IAM : (string2.indexOf("orac") > -1 ? "ORACLE" : JDBC_ODBC))));
        return string;
    }

    private String getJDBCSearchPattern(String string) throws Exception {
        this.errMsg = "";
        try {
            String string2 = string;
            String string3 = this.dbmeta.getSearchStringEscape();
            string2 = this.replaceAllChars(string2, '%', string3 + "%");
            string2 = string2.replace('*', '%');
            string2 = string2.replace('?', '_');
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public String[] getSchemas() throws Exception {
        this.errMsg = "";
        try {
            ResultSet resultSet = this.dbmeta.getSchemas();
            Vector<String> vector = new Vector<String>();
            Object[] objectArray = null;
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_SCHEM");
                vector.add(string);
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
            resultSet.close();
            return objectArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public String[][] getTablesOnly(String string, String string2, String string3, boolean bl) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{TABLE, ALIAS, SYNONYM, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{TABLE, ALIAS, SYNONYM};
        }
        return this.getTables(string, string2, string3, stringArray);
    }

    public String[][] getViewsOnly(String string, String string2, String string3, boolean bl) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{VIEW, ALIAS, SYNONYM, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{VIEW, ALIAS, SYNONYM};
        }
        return this.getTables(string, string2, string3, stringArray);
    }

    public String[][] getTablesAndViews(String string, String string2, String string3, boolean bl) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{TABLE, VIEW, ALIAS, SYNONYM, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{TABLE, VIEW, ALIAS, SYNONYM};
        }
        return this.getTables(string, string2, string3, stringArray);
    }

    public String[][] getTables(String string, String string2, String string3, String[] stringArray) throws Exception {
        this.errMsg = "";
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            if (string3.equals("")) {
                string3 = null;
            }
            if (string3 != null) {
                string3 = this.getJDBCSearchPattern(string3);
            }
            ResultSet resultSet = this.dbmeta.getTables(string, string2, string3, stringArray);
            Vector<String[]> vector = new Vector<String[]>();
            String[][] stringArray2 = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString("TABLE_CAT");
                String string5 = resultSet.getString("TABLE_SCHEM");
                String string6 = resultSet.getString("TABLE_NAME");
                String string7 = resultSet.getString("TABLE_TYPE");
                if (string4 == null) {
                    string4 = "";
                }
                if (string5 == null) {
                    string5 = "";
                }
                String[] stringArray3 = new String[]{string6, string4, string5, string7};
                vector.add(stringArray3);
            }
            if (vector.size() > 0) {
                stringArray2 = new String[vector.size()][4];
                vector.copyInto((Object[])stringArray2);
            }
            resultSet.close();
            return stringArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
    }

    public PrepStmt getPrepStmtMetaData(String string, String string2, String string3, String string4) throws Exception {
        this.errMsg = "";
        this.checkPrepStmtMetaData = false;
        PrepStmt prepStmt = null;
        try {
            if (string4 == null || string4.equals("")) {
                return null;
            }
            prepStmt = new PrepStmt(string3, string, string2, string4);
            PreparedStatement preparedStatement = this.dbconn.prepareStatement(string4);
            Parameter[] parameterArray = null;
            parameterArray = this.getPrepStmtParameters(preparedStatement);
            prepStmt.setParameters(parameterArray);
            ResultSetColumn[] resultSetColumnArray = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            if (stringTokenizer.hasMoreElements()) {
                String string5 = (String)stringTokenizer.nextElement();
                if (string5.equalsIgnoreCase("select")) {
                    resultSetColumnArray = this.getPrepStmtResultSetColumns(preparedStatement);
                }
            } else {
                resultSetColumnArray = null;
            }
            prepStmt.setResultSetColumns(resultSetColumnArray);
            this.checkPrepStmtMetaData = this.errPrepStmtParameters && this.errPrepStmtResultSetColumns;
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            this.checkPrepStmtMetaData = true;
        }
        return prepStmt;
    }

    public PrepStmt getPrepStmtMetaData() throws Exception {
        PrepStmt prepStmt = null;
        try {
            prepStmt = this.getPrepStmtMetaData(null, null, null, this.sqlText);
        }
        catch (Exception exception) {
            this.errMsg = exception.getLocalizedMessage();
        }
        return prepStmt;
    }

    public String[][] getProcedures(String string, String string2, String string3) throws Exception {
        this.errMsg = "";
        String[][] stringArray = null;
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            if (string3.equals("")) {
                string3 = null;
            }
            if (string3 != null) {
                string3 = this.getJDBCSearchPattern(string3);
            }
            Vector<String[]> vector = new Vector<String[]>();
            ResultSet resultSet = this.dbmeta.getProcedures(string, string2, string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("PROCEDURE_CAT");
                String string5 = resultSet.getString("PROCEDURE_SCHEM");
                String string6 = resultSet.getString("PROCEDURE_NAME");
                String string7 = this.getProcedureTypeDescription(resultSet.getShort("PROCEDURE_TYPE"));
                if (string4 == null) {
                    string4 = "";
                }
                if (string5 == null) {
                    string5 = "";
                }
                String[] stringArray2 = new String[]{string6, string4, string5, string7};
                vector.add(stringArray2);
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()][4];
                vector.copyInto((Object[])stringArray);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
        }
        return stringArray;
    }

    public List getPrimaryKeys(String string, String string2, String string3) throws Exception {
        List list = Collections.EMPTY_LIST;
        ResultSet resultSet = null;
        this.errMsg = "";
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = this.dbmeta.getPrimaryKeys(string, string2, string3);
            list = KeyColumn.createPrimaryKeyColumnList(resultSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public List getForeignKeys(String string, String string2, String string3) throws Exception {
        this.errMsg = "";
        List list = Collections.EMPTY_LIST;
        ResultSet resultSet = null;
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = this.dbmeta.getImportedKeys(string, string2, string3);
            list = ForeignKeyColumn.createForeignKeyColumnList(resultSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public Procedure getProcedureMetaData() throws Exception {
        return this.getProcedureMetaData(null, null, null, this.sqlText);
    }

    public Procedure getProcedureMetaData(String string, String string2, String string3, String string4) throws Exception {
        Procedure procedure = new Procedure(string3, string, string2, string4);
        try {
            ArrayList<ResultSetColumns> arrayList;
            block36: {
                int n;
                Object object;
                int n2;
                Object object2;
                Vector<Parameter> vector = new Vector<Parameter>();
                if (string.equals("")) {
                    string = null;
                }
                if (string2.equals("")) {
                    string2 = null;
                }
                int n3 = 0;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = true;
                ResultSetColumn resultSetColumn = new ResultSetColumn();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList = new ArrayList<ResultSetColumns>();
                if (string == null || string.trim().equalsIgnoreCase("")) {
                    bl3 = false;
                }
                this.dbmeta = this.dbconn.getMetaData();
                ResultSet resultSet = this.dbmeta.getProcedureColumns(string, string2, string3, "%");
                Object[] objectArray = null;
                int n4 = 0;
                int n5 = 0;
                boolean bl4 = false;
                CallableStatement callableStatement = this.dbconn.prepareCall(this.sqlText);
                while (resultSet.next()) {
                    ++n4;
                    String string5 = resultSet.getString("COLUMN_NAME");
                    if (resultSet.getShort("COLUMN_TYPE") == 5) {
                        bl = true;
                    }
                    ++n3;
                    if (string5 != null) {
                        if (string5.charAt(0) == '@') {
                            string5 = string5.substring(1);
                        }
                    } else {
                        string5 = "param" + String.valueOf(n4);
                    }
                    String string6 = DBMetaData.getSQLTypeDescription(resultSet.getInt("DATA_TYPE"));
                    String string7 = this.getJavaFromSQLTypeDescription(string6);
                    int n6 = resultSet.getInt("DATA_TYPE");
                    if (n6 == 1111 && resultSet.getString("TYPE_NAME").equalsIgnoreCase("REF CURSOR")) {
                        string6 = "RESULTSET";
                        string7 = "java.sql.ResultSet";
                    }
                    object2 = this.getParamTypeDescription(resultSet.getShort("COLUMN_TYPE"));
                    n2 = resultSet.getShort("NULLABLE");
                    int n7 = resultSet.getInt("PRECISION");
                    short s = resultSet.getShort("SCALE");
                    Parameter parameter = new Parameter(string5, string7);
                    boolean bl5 = false;
                    if (n2 == 1) {
                        bl5 = true;
                    }
                    parameter.setJavaType(string7);
                    parameter.setSqlType(string6);
                    parameter.setParamType((String)object2);
                    parameter.setOrdinalPosition(n4);
                    parameter.setNumericPrecision(n7);
                    parameter.setNumericScale(s);
                    parameter.setIsNullable(bl5);
                    if (((String)object2).equals("RETURN")) {
                        bl4 = true;
                    }
                    ++n5;
                    object = resultSet.getString("COLUMN_NAME");
                    n = resultSet.getInt("DATA_TYPE");
                    short s2 = resultSet.getShort("COLUMN_TYPE");
                    String string8 = resultSet.getString("TYPE_NAME");
                    if (s2 == 1) {
                        if (n == 1111 && string8.equals("PL/SQL TABLE")) {
                            n = -14;
                        }
                        if (n == 1111 && string8.equals("PL/SQL RECORD")) {
                            n = -14;
                        }
                        callableStatement.setNull(n5, n);
                    }
                    if (s2 == 2 || s2 == 4) {
                        try {
                            if (n == 1111 && string8.equals("REF CURSOR")) {
                                n = -10;
                                arrayList2.add(new Integer(n5));
                            }
                            callableStatement.registerOutParameter(n5, n);
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.getMessage());
                            sQLException.printStackTrace();
                            this.checkProcMetaData = true;
                        }
                    }
                    if (s2 == 5) {
                        try {
                            if (n == 1111 && string8.equals("REF CURSOR")) {
                                n = -10;
                                arrayList2.add(new Integer(n5));
                            }
                            callableStatement.registerOutParameter(n5, n);
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.getMessage());
                            sQLException.printStackTrace();
                            this.checkProcMetaData = true;
                        }
                    }
                    vector.add(parameter);
                }
                resultSet.close();
                if (vector.size() > 0) {
                    objectArray = new Parameter[vector.size()];
                    vector.copyInto(objectArray);
                }
                procedure.setParameters((Parameter[])objectArray);
                procedure.setHasReturn(bl4);
                try {
                    if (!bl4) break block36;
                    boolean bl6 = callableStatement.execute();
                    int n8 = -1;
                    int n9 = arrayList2.size();
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        ResultSetMetaData resultSetMetaData;
                        object2 = new ArrayList();
                        ++n8;
                        n2 = (Integer)iterator.next();
                        try {
                            ResultSet resultSet2 = (ResultSet)callableStatement.getObject(n2);
                            resultSetMetaData = resultSet2.getMetaData();
                        }
                        catch (SQLException sQLException) {
                            resultSetMetaData = null;
                            this.checkProcMetaData = true;
                        }
                        int n10 = 0;
                        if (resultSetMetaData != null) {
                            n10 = resultSetMetaData.getColumnCount();
                        }
                        for (int i = 1; i <= n10; ++i) {
                            object = new ResultSetColumn();
                            ((ResultSetColumn)object).setOrdinalPosition(i);
                            ((ResultSetColumn)object).setName(resultSetMetaData.getColumnName(i));
                            ((ResultSetColumn)object).setLabel(resultSetMetaData.getColumnLabel(i));
                            ((ResultSetColumn)object).setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                            ((ResultSetColumn)object).setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                            if (resultSetMetaData.isNullable(i) == 1) {
                                ((ResultSetColumn)object).setIsNullable(true);
                            } else {
                                ((ResultSetColumn)object).setIsNullable(false);
                            }
                            n = ((ArrayList)object2).add(object) ? 1 : 0;
                        }
                        if (((ArrayList)object2).size() <= 0) continue;
                        ResultSetColumns resultSetColumns = new ResultSetColumns();
                        resultSetColumns.setColumns((ArrayList)object2);
                        resultSetColumns.setName(string3 + "_" + n8);
                        arrayList.add(resultSetColumns);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("\nException occurred: " + sQLException.getClass().getName() + ", " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    this.errMsg = sQLException.getLocalizedMessage();
                    this.checkProcMetaData = true;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("\nException occurred: " + nullPointerException.getClass().getName() + ", " + nullPointerException.getMessage());
                    nullPointerException.printStackTrace();
                    this.errMsg = nullPointerException.getLocalizedMessage();
                    this.checkProcMetaData = true;
                }
                catch (Exception exception) {
                    System.out.println("\nException occurred: " + exception.getClass().getName() + ", " + exception.getMessage());
                    exception.printStackTrace();
                    this.errMsg = exception.getLocalizedMessage();
                    this.checkProcMetaData = true;
                }
            }
            procedure.setResultSetColumns(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.checkProcMetaData = true;
        }
        return procedure;
    }

    public Table getTableMetaData(String string, String string2, String string3, String string4) throws Exception {
        this.errMsg = "";
        ResultSet resultSet = null;
        try {
            Object object;
            Table table = new Table(string3, string, string2, string4);
            Vector<TableColumn> vector = new Vector<TableColumn>();
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = this.dbmeta.getColumns(string, string2, string3, "%");
            Object[] objectArray = null;
            while (resultSet.next()) {
                object = resultSet.getString("COLUMN_DEF");
                int n = resultSet.getInt("DATA_TYPE");
                String string5 = resultSet.getString("COLUMN_NAME");
                String string6 = DBMetaData.getSQLTypeDescription(n);
                String string7 = this.getJavaFromSQLTypeDescription(string6);
                int n2 = resultSet.getInt("ORDINAL_POSITION");
                int n3 = resultSet.getInt("DECIMAL_DIGITS");
                int n4 = resultSet.getInt("COLUMN_SIZE");
                int n5 = resultSet.getInt("NUM_PREC_RADIX");
                TableColumn tableColumn = new TableColumn(string5, string7);
                boolean bl = false;
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    bl = true;
                }
                tableColumn.setJavaType(string7);
                tableColumn.setSqlType(string6);
                tableColumn.setIsNullable(bl);
                tableColumn.setIsSelected(true);
                tableColumn.setIsPrimaryKey(false);
                tableColumn.setIsForeignKey(false);
                tableColumn.setSqlTypeCode(n);
                tableColumn.setOrdinalPosition(n2);
                tableColumn.setNumericPrecision(n4);
                tableColumn.setNumericScale(n3);
                tableColumn.setNumericRadix(n5);
                if (object != null) {
                    tableColumn.setDefaultValue(((String)object).trim());
                }
                vector.add(tableColumn);
            }
            if (vector.size() > 0) {
                objectArray = new TableColumn[vector.size()];
                vector.copyInto(objectArray);
            }
            table.setColumns((TableColumn[])objectArray);
            this.checkPrimaryKeys(table);
            this.checkForeignKeys(table);
            try {
                resultSet = this.dbmeta.getIndexInfo(string, string2, string3, false, true);
                table.setIndexList(IndexColumn.createIndexList(resultSet));
            }
            catch (Exception exception) {
                this.errMsg = exception.getLocalizedMessage();
            }
            object = table;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getJavaFromSQLTypeDescription(String string) {
        String string2 = "java.lang.String";
        Object v = SQLTOJAVATYPES.get(string);
        if (v != null) {
            string2 = v.toString();
        }
        return string2;
    }

    public static String getSQLTypeDescription(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "OTHER";
    }

    public static int getSQLTypeCode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Must supply non-null String value for sqlText.");
        }
        string = string.trim().toUpperCase();
        for (int i = 0; i < SQLTYPES.length; ++i) {
            if (!SQLTYPES[i].equals(string)) continue;
            return SQLTYPE_CODES[i];
        }
        return 1111;
    }

    private String getJavaTypeDescription(int n) {
        String string = "java.lang.String";
        switch (n) {
            case 2003: {
                string = "java.sql.ARRAY";
            }
            case -5: {
                string = "long";
            }
            case -2: {
                string = "byte[]";
            }
            case -7: {
                string = "boolean";
            }
            case 2004: {
                string = "java.sql.Blob";
            }
            case 1: {
                string = "java.lang.String";
            }
            case 2005: {
                string = "java.sql.Clob";
            }
            case 91: {
                string = "java.sql.Date";
            }
            case 3: {
                string = "java.math.BigDecimal";
            }
            case 8: {
                string = "double";
            }
            case 6: {
                string = "double";
            }
            case 4: {
                string = "int";
            }
            case -4: {
                string = "byte[]";
            }
            case -1: {
                string = "java.lang.String";
            }
            case 2: {
                string = "java.math.BigDecimal";
            }
            case 7: {
                string = "float";
            }
            case 2006: {
                string = "java.sql.Ref";
            }
            case 5: {
                string = "short";
            }
            case 2002: {
                string = "java.sql.Struct";
            }
            case 92: {
                string = "java.sql.Time";
            }
            case 93: {
                string = "java.sql.Timestamp";
            }
            case -6: {
                string = "byte";
            }
            case -3: {
                string = "byte[]";
            }
            case 12: {
                string = "java.lang.String";
            }
        }
        return string;
    }

    private String getParamTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "IN" : (n == 2 ? "INOUT" : (n == 4 ? "OUT" : (n == 5 ? "RETURN" : (n == 3 ? "RESULT" : "UNKNOWN"))));
        return string;
    }

    private String getProcedureTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "PROCEDURE" : (n == 2 ? "FUNCTION" : (n == 0 ? "UNKNOWN" : "UNKNOWN"));
        return string;
    }

    private String getPrepStmtParamTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "IN" : (n == 2 ? "INOUT" : (n == 4 ? "OUT" : (n == 0 ? "UNKNOWN" : "UNKNOWN")));
        return string;
    }

    private String replaceAllChars(String string, char c, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string.charAt(i) == c ? string3 + string2 : string3 + string.charAt(i);
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        DBMetaData dBMetaData = new DBMetaData();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string = "oracle.jdbc.OracleDriver";
        string2 = "jdbc:oracle:thin:@jlongbgx:1521:jlongbgx";
        string3 = "dgdb";
        string4 = "dgdb";
        try {
            Object object;
            int n;
            Object[] objectArray;
            dBMetaData.connectDB(string, string2, string3, string4);
            System.out.println("Successfully connected to " + string2 + ".");
            System.out.println("Database product name: " + dBMetaData.getDBName());
            System.out.println("Database Type: " + dBMetaData.getDBType());
            String[] stringArray2 = dBMetaData.getSchemas();
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                }
            }
            System.out.println();
            System.out.println("TABLES:");
            String[][] stringArray3 = dBMetaData.getTablesAndViews("", "", "DB*", false);
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    objectArray = stringArray3[i];
                    System.out.println(objectArray[1] + "." + (String)objectArray[2] + "." + (String)objectArray[0] + ":Type=" + (String)objectArray[3]);
                }
                System.out.println("Table Count = " + stringArray3.length);
            }
            System.out.println();
            System.out.println("TABLE COLUMNS:");
            Table table = dBMetaData.getTableMetaData("", "DGDB", "DB_EMPLOYEE", TABLE);
            if (table != null && (objectArray = table.getColumns()) != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    object = objectArray[n];
                    System.out.println("Column " + (n + 1) + ":" + ((TableColumn)object).getName() + "(" + ((TableColumn)object).getJavaType() + "):IsNullable=" + ((TableColumn)object).getIsNullable() + ":IsSelected=" + ((TableColumn)object).getIsSelected() + ":IsPrimaryKey=" + ((TableColumn)object).getIsPrimaryKey() + ":IsForeignKey=" + ((TableColumn)object).getIsForeignKey() + ":Precision=" + ((TableColumn)object).getNumericPrecision() + ":Scale=" + ((TableColumn)object).getNumericScale());
                }
            }
            System.out.println();
            System.out.println("PROCEDURES:");
            objectArray = dBMetaData.getProcedures("", "", "P*");
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    object = objectArray[n];
                    System.out.println((String)((Object)object[1]) + "." + (String)((Object)object[2]) + "." + (String)object[0] + ":" + (String)object[3]);
                }
                System.out.println("Procedure Count = " + objectArray.length);
            }
            System.out.println();
            System.out.println("PROCEDURE PARAMETERS:");
            Procedure procedure = dBMetaData.getProcedureMetaData("", "DGDB", "PLUSONE", "PROCEDURE");
            if (procedure != null && (object = procedure.getParameters()) != null) {
                for (int i = 0; i < ((Parameter[])object).length; ++i) {
                    Object object2 = object[i];
                    System.out.println("Parameter " + ((Parameter)object2).getOrdinalPosition() + ":" + ((Parameter)object2).getName() + "(" + ((Parameter)object2).getJavaType() + "):ParamType=" + ((Parameter)object2).getParamType() + ":NumericPrecision=" + ((Parameter)object2).getNumericPrecision() + ":NumericScale=" + ((Parameter)object2).getNumericScale() + ":IsNullable=" + ((Parameter)object2).getIsNullable());
                }
            }
            System.out.println();
            object = dBMetaData.getPrepStmtMetaData("", "", "prep1", "select * from db_employee where RATE=?");
            if (object != null) {
                System.out.println("PREPARED STATMENT:" + ((PrepStmt)object).getName());
                ResultSetColumn[] resultSetColumnArray = ((PrepStmt)object).getResultSetColumns();
                if (resultSetColumnArray != null) {
                    for (int i = 0; i < resultSetColumnArray.length; ++i) {
                        ResultSetColumn resultSetColumn = resultSetColumnArray[i];
                        System.out.println("RS Col " + resultSetColumn.getOrdinalPosition() + ":" + resultSetColumn.getName() + "(" + resultSetColumn.getJavaType() + "):NumericPrecision=" + resultSetColumn.getNumericPrecision() + ":NumericScale=" + resultSetColumn.getNumericScale() + ":IsNullable=" + resultSetColumn.getIsNullable());
                    }
                }
            }
            System.out.println();
            dBMetaData.disconnectDB();
            System.out.println("Successfully disconnected from " + string2 + ".");
        }
        catch (Exception exception) {
            String string5 = dBMetaData.getErrString();
            System.out.println("Exception: " + string5);
        }
    }

    public String getErrString() {
        return this.errMsg;
    }

    private Parameter[] getPrepStmtParameters(PreparedStatement preparedStatement) throws Exception {
        Parameter[] parameterArray;
        block11: {
            String string = "";
            this.errPrepStmtParameters = false;
            parameterArray = null;
            try {
                int n;
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                if (parameterMetaData == null || (n = parameterMetaData.getParameterCount()) <= 0) break block11;
                parameterArray = new Parameter[n];
                for (int i = 1; i <= n; ++i) {
                    Parameter parameter = new Parameter();
                    String string2 = "param" + String.valueOf(i);
                    parameter.setName(string2);
                    String string3 = "VARCHAR";
                    try {
                        string3 = DBMetaData.getSQLTypeDescription(parameterMetaData.getParameterType(i));
                    }
                    catch (SQLException sQLException) {
                        this.errPrepStmtParameters = true;
                        sQLException.printStackTrace();
                        string = sQLException.getLocalizedMessage();
                    }
                    String string4 = "java.lang.String";
                    string4 = this.getJavaFromSQLTypeDescription(string3);
                    int n2 = 0;
                    try {
                        n2 = parameterMetaData.getPrecision(i);
                    }
                    catch (SQLException sQLException) {
                        this.errPrepStmtParameters = true;
                        sQLException.printStackTrace();
                        string = sQLException.getLocalizedMessage();
                    }
                    int n3 = 0;
                    try {
                        n3 = parameterMetaData.getScale(i);
                    }
                    catch (SQLException sQLException) {
                        this.errPrepStmtParameters = true;
                        sQLException.printStackTrace();
                        string = sQLException.getLocalizedMessage();
                    }
                    String string5 = "IN";
                    boolean bl = true;
                    try {
                        bl = parameterMetaData.isNullable(i) == 1;
                    }
                    catch (SQLException sQLException) {
                        this.errPrepStmtParameters = true;
                        sQLException.printStackTrace();
                        string = sQLException.getLocalizedMessage();
                    }
                    parameter.setJavaType(string4);
                    parameter.setSqlType(string3);
                    parameter.setNumericPrecision(n2);
                    parameter.setNumericScale(n3);
                    parameter.setOrdinalPosition(i);
                    parameter.setParamType(string5);
                    parameter.setIsNullable(bl);
                    parameterArray[i - 1] = parameter;
                }
            }
            catch (Exception exception) {
                parameterArray = null;
                this.errPrepStmtParameters = true;
                exception.printStackTrace();
                string = exception.getLocalizedMessage();
            }
        }
        return parameterArray;
    }

    private ResultSetColumn[] getPrepStmtResultSetColumns(PreparedStatement preparedStatement) throws SQLException {
        String string = "";
        this.errPrepStmtResultSetColumns = false;
        ResultSetColumn[] resultSetColumnArray = null;
        try {
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            int n = 0;
            if (resultSetMetaData != null) {
                n = resultSetMetaData.getColumnCount();
            } else {
                this.errPrepStmtResultSetColumns = true;
            }
            if (n > 0) {
                resultSetColumnArray = new ResultSetColumn[n];
                for (int i = 1; i <= n; ++i) {
                    ResultSetColumn resultSetColumn = new ResultSetColumn();
                    resultSetColumn.setName(resultSetMetaData.getColumnName(i));
                    resultSetColumn.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                    resultSetColumn.setJavaType(this.getJavaFromSQLTypeDescription(resultSetColumn.getSqlType()));
                    resultSetColumn.setOrdinalPosition(i);
                    resultSetColumn.setNumericPrecision(resultSetMetaData.getPrecision(i));
                    resultSetColumn.setNumericScale(resultSetMetaData.getScale(i));
                    if (resultSetMetaData.isNullable(i) == 1) {
                        resultSetColumn.setIsNullable(true);
                    } else {
                        resultSetColumn.setIsNullable(false);
                    }
                    resultSetColumnArray[i - 1] = resultSetColumn;
                }
            }
        }
        catch (SQLException sQLException) {
            this.errPrepStmtResultSetColumns = true;
            resultSetColumnArray = null;
            sQLException.printStackTrace();
            string = sQLException.getLocalizedMessage();
            throw sQLException;
        }
        return resultSetColumnArray;
    }

    public void getProcResultSetColumns(CallableStatement callableStatement, Procedure procedure) throws SQLException, NullPointerException {
        ArrayList<ResultSetColumns> arrayList;
        block20: {
            String string = "";
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            callableStatement = this.dbconn.prepareCall(this.sqlText);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList = new ArrayList<ResultSetColumns>();
            int n2 = 0;
            try {
                Object object;
                int n3;
                Parameter[] parameterArray = procedure.getParameters();
                n = procedure.getNumParameters();
                if (n > 0) {
                    for (n3 = 0; n3 < n; ++n3) {
                        ++n2;
                        Parameter parameter = parameterArray[n3];
                        String string2 = parameter.getName();
                        object = parameter.getSqlType();
                        int n4 = DBMetaData.getSQLTypeCode((String)object);
                        String string3 = parameter.getParamType();
                        callableStatement.setNull(n2, n4);
                        if (string3.equalsIgnoreCase("INOUT") || string3.equalsIgnoreCase("OUT")) {
                            try {
                                if (n4 == 1111 && string3.equals("OTHER")) {
                                    n4 = 1111;
                                    arrayList2.add(new Integer(n2));
                                }
                                callableStatement.registerOutParameter(n2, n4);
                            }
                            catch (SQLException sQLException) {
                                System.out.println(sQLException.getMessage());
                                sQLException.printStackTrace();
                                throw sQLException;
                            }
                        }
                        if (string3 != "RETURN") continue;
                        try {
                            if (n4 == 1111 && string3.equals("OTHER")) {
                                n4 = 1111;
                                arrayList2.add(new Integer(n2));
                            }
                            bl2 = true;
                            callableStatement.registerOutParameter(n2, n4);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.getMessage());
                            sQLException.printStackTrace();
                            throw sQLException;
                        }
                    }
                }
                if (!bl2) break block20;
                n3 = callableStatement.execute() ? 1 : 0;
                int n5 = -1;
                int n6 = arrayList2.size();
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    ResultSetMetaData resultSetMetaData;
                    ArrayList<ResultSetColumn> arrayList3 = new ArrayList<ResultSetColumn>();
                    ++n5;
                    int n7 = (Integer)object.next();
                    try {
                        ResultSet resultSet = (ResultSet)callableStatement.getObject(n7);
                        resultSetMetaData = resultSet.getMetaData();
                    }
                    catch (SQLException sQLException) {
                        resultSetMetaData = null;
                    }
                    int n8 = 0;
                    if (resultSetMetaData != null) {
                        n8 = resultSetMetaData.getColumnCount();
                    }
                    for (int i = 1; i <= n8; ++i) {
                        ResultSetColumn resultSetColumn = new ResultSetColumn();
                        resultSetColumn.setOrdinalPosition(i);
                        resultSetColumn.setName(resultSetMetaData.getColumnName(i));
                        resultSetColumn.setLabel(resultSetMetaData.getColumnLabel(i));
                        resultSetColumn.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                        resultSetColumn.setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                        if (resultSetMetaData.isNullable(i) == 1) {
                            resultSetColumn.setIsNullable(true);
                        } else {
                            resultSetColumn.setIsNullable(false);
                        }
                        boolean bl5 = arrayList3.add(resultSetColumn);
                    }
                    if (arrayList3.size() <= 0) continue;
                    ResultSetColumns resultSetColumns = new ResultSetColumns();
                    resultSetColumns.setColumns(arrayList3);
                    resultSetColumns.setName("proc_" + n5);
                    arrayList.add(resultSetColumns);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("\nException occurred: " + sQLException.getClass().getName() + ", " + sQLException.getMessage());
                sQLException.printStackTrace();
                string = sQLException.getLocalizedMessage();
                throw sQLException;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("\nException occurred: " + nullPointerException.getClass().getName() + ", " + nullPointerException.getMessage());
                nullPointerException.printStackTrace();
                string = nullPointerException.getLocalizedMessage();
                throw nullPointerException;
            }
            catch (Exception exception) {
                System.out.println("\nException occurred: " + exception.getClass().getName() + ", " + exception.getMessage());
                exception.printStackTrace();
                string = exception.getLocalizedMessage();
            }
        }
        procedure.setResultSetColumns(arrayList);
    }

    public Procedure getQueryResultSet(String string, String string2, String string3, String string4) throws SQLException, NullPointerException {
        String string5 = "";
        Procedure procedure = new Procedure(string3, string, string2, new String("PROCEDURE"));
        ResultSetColumns[] resultSetColumnsArray = null;
        ArrayList<ResultSetColumn> arrayList = new ArrayList<ResultSetColumn>();
        try {
            DatabaseMetaData databaseMetaData = this.dbconn.getMetaData();
            Statement statement = this.dbconn.createStatement();
            String[] stringArray = this.getQueryFields(string4);
            ResultSet resultSet = statement.executeQuery(string4);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string6;
                ResultSetColumn resultSetColumn = new ResultSetColumn();
                resultSetColumn.setOrdinalPosition(i);
                String string7 = resultSetMetaData.getColumnName(i).trim();
                String string8 = resultSetMetaData.getColumnLabel(i).trim();
                if (string7.equalsIgnoreCase("") || string7 == null) {
                    string6 = stringArray[i - 1];
                    resultSetColumn.setName(string6);
                } else {
                    resultSetColumn.setName(string7);
                }
                if (string8.equalsIgnoreCase("") || string8 == null) {
                    string6 = stringArray[i - 1];
                    resultSetColumn.setLabel(string6);
                } else {
                    resultSetColumn.setLabel(string8);
                }
                resultSetColumn.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                resultSetColumn.setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                if (resultSetMetaData.isNullable(i) == 1) {
                    resultSetColumn.setIsNullable(true);
                } else {
                    resultSetColumn.setIsNullable(false);
                }
                boolean bl = arrayList.add(resultSetColumn);
            }
            resultSetColumnsArray = new ResultSetColumns[]{new ResultSetColumns()};
            resultSetColumnsArray[0].setColumns(arrayList);
            resultSetColumnsArray[0].setName(string3 + "_0");
        }
        catch (SQLException sQLException) {
            System.out.println("\nException occurred: " + sQLException.getClass().getName() + ", " + sQLException.getMessage());
            sQLException.printStackTrace();
            string5 = sQLException.getLocalizedMessage();
            throw sQLException;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("\nException occurred: " + nullPointerException.getClass().getName() + ", " + nullPointerException.getMessage());
            nullPointerException.printStackTrace();
            string5 = nullPointerException.getLocalizedMessage();
            throw nullPointerException;
        }
        catch (Exception exception) {
            System.out.println("\nException occurred: " + exception.getClass().getName() + ", " + exception.getMessage());
            exception.printStackTrace();
            string5 = exception.getLocalizedMessage();
        }
        procedure.setResultSetColumns(resultSetColumnsArray);
        return procedure;
    }

    public String getProcedureText(Procedure procedure) {
        String string = "";
        String string2 = "";
        String string3 = procedure.getName();
        String string4 = procedure.getCatalog();
        string2 = string4.equals("") || string4 == null ? "select text from user_source where name = '" + string3 + "'" : "select text from user_source where name = '" + string4 + "'";
        try {
            Statement statement = this.dbconn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string = string + resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("\nException occurred: " + sQLException.getClass().getName() + ", " + sQLException.getMessage());
            sQLException.printStackTrace();
            this.errMsg = sQLException.getLocalizedMessage();
        }
        return string;
    }

    private String[] getQueryFields(String string) {
        String[] stringArray = null;
        String string2 = string.toUpperCase().trim();
        int n = string2.indexOf("FROM");
        String string3 = string.substring(7, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n2 = stringTokenizer.countTokens();
        stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken().trim();
            ++n3;
        }
        return stringArray;
    }

    public DBMetaData(Connection connection, String string) {
        this.dbconn = connection;
        this.sqlText = string;
    }

    public DBMetaData() {
    }

    public String getSQLText() {
        return this.sqlText;
    }

    public Procedure getProcResultSetColumns(String string, String string2, String string3, String string4, Procedure procedure) throws SQLException, NullPointerException {
        this.checkProcMetaData = false;
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        ResultSetColumn resultSetColumn = new ResultSetColumn();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<ResultSetColumns> arrayList2 = new ArrayList<ResultSetColumns>();
        if (string.trim().equalsIgnoreCase("") || string == null) {
            bl3 = false;
        }
        try {
            Object object;
            int n2;
            int n3;
            ResultSet resultSet = this.dbmeta.getProcedureColumns(string, string2, string3, string4);
            while (resultSet.next()) {
                if (resultSet.getShort("COLUMN_TYPE") != 5) continue;
                bl = true;
            }
            resultSet = this.dbmeta.getProcedureColumns(string, string2, string3, string4);
            while (resultSet.next()) {
                ++n;
            }
            if (n == 0) {
                bl2 = false;
            }
            if (bl) {
                // empty if block
            }
            CallableStatement callableStatement = this.dbconn.prepareCall(this.sqlText);
            resultSet = this.dbmeta.getProcedureColumns(string, string2, string3, string4);
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                resultSet.next();
                ++n4;
                String string5 = resultSet.getString("COLUMN_NAME");
                n2 = resultSet.getInt("DATA_TYPE");
                short s = resultSet.getShort("COLUMN_TYPE");
                object = resultSet.getString("TYPE_NAME");
                if (s == 1) {
                    if (n2 == 1111 && ((String)object).equals("PL/SQL TABLE")) {
                        n2 = -14;
                    }
                    if (n2 == 1111 && ((String)object).equals("PL/SQL RECORD")) {
                        n2 = -14;
                    }
                    callableStatement.setNull(n4, n2);
                }
                if (s == 2 || s == 4) {
                    try {
                        if (n2 == 1111 && ((String)object).equals("REF CURSOR")) {
                            n2 = -10;
                            arrayList.add(new Integer(n4));
                        }
                        callableStatement.registerOutParameter(n4, n2);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException.getMessage());
                        sQLException.printStackTrace();
                        this.checkProcMetaData = true;
                    }
                }
                if (s != 5) continue;
                try {
                    if (n2 == 1111 && ((String)object).equals("REF CURSOR")) {
                        n2 = -10;
                        arrayList.add(new Integer(n4));
                    }
                    callableStatement.registerOutParameter(n4, n2);
                    continue;
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.getMessage());
                    sQLException.printStackTrace();
                    this.checkProcMetaData = true;
                }
            }
            n3 = callableStatement.execute() ? 1 : 0;
            int n5 = -1;
            n2 = arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ResultSetMetaData resultSetMetaData;
                object = new ArrayList();
                ++n5;
                int n6 = (Integer)iterator.next();
                try {
                    ResultSet resultSet2 = (ResultSet)callableStatement.getObject(n6);
                    resultSetMetaData = resultSet2.getMetaData();
                }
                catch (SQLException sQLException) {
                    resultSetMetaData = null;
                }
                int n7 = 0;
                if (resultSetMetaData != null) {
                    n7 = resultSetMetaData.getColumnCount();
                }
                for (int i = 1; i <= n7; ++i) {
                    ResultSetColumn resultSetColumn2 = new ResultSetColumn();
                    resultSetColumn2.setOrdinalPosition(i);
                    resultSetColumn2.setName(resultSetMetaData.getColumnName(i));
                    resultSetColumn2.setLabel(resultSetMetaData.getColumnLabel(i));
                    resultSetColumn2.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                    resultSetColumn2.setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                    if (resultSetMetaData.isNullable(i) == 1) {
                        resultSetColumn2.setIsNullable(true);
                    } else {
                        resultSetColumn2.setIsNullable(false);
                    }
                    boolean bl4 = ((ArrayList)object).add(resultSetColumn2);
                }
                if (((ArrayList)object).size() <= 0) continue;
                ResultSetColumns resultSetColumns = new ResultSetColumns();
                resultSetColumns.setColumns((ArrayList)object);
                resultSetColumns.setName(string3 + "_" + n5);
                arrayList2.add(resultSetColumns);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("\nException occurred: " + sQLException.getClass().getName() + ", " + sQLException.getMessage());
            sQLException.printStackTrace();
            this.errMsg = sQLException.getLocalizedMessage();
            this.checkProcMetaData = true;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("\nException occurred: " + nullPointerException.getClass().getName() + ", " + nullPointerException.getMessage());
            nullPointerException.printStackTrace();
            this.errMsg = nullPointerException.getLocalizedMessage();
            this.checkProcMetaData = true;
        }
        catch (Exception exception) {
            System.out.println("\nException occurred: " + exception.getClass().getName() + ", " + exception.getMessage());
            exception.printStackTrace();
            this.errMsg = exception.getLocalizedMessage();
            this.checkProcMetaData = true;
        }
        procedure.setResultSetColumns(arrayList2);
        return procedure;
    }

    public boolean getErrPrepStmtMetaData() {
        return this.checkPrepStmtMetaData;
    }

    public boolean getErrProcMetaData() {
        return this.checkProcMetaData;
    }

    static {
        SQLTOJAVATYPES.put("ARRAY", "java.sql.Array");
        SQLTOJAVATYPES.put("BIGINT", "long");
        SQLTOJAVATYPES.put("BINARY", "byte[]");
        SQLTOJAVATYPES.put("BIT", "boolean");
        SQLTOJAVATYPES.put("BLOB", "java.sql.Blob");
        SQLTOJAVATYPES.put("BOOLEAN", "boolean");
        SQLTOJAVATYPES.put("CHAR", "java.lang.String");
        SQLTOJAVATYPES.put("CLOB", "java.sql.Clob");
        SQLTOJAVATYPES.put("DATALINK", "java.net.URL");
        SQLTOJAVATYPES.put("DATE", "java.sql.Date");
        SQLTOJAVATYPES.put("DECIMAL", "java.math.BigDecimal");
        SQLTOJAVATYPES.put("DISTINCT", "java.lang.String");
        SQLTOJAVATYPES.put("DOUBLE", "double");
        SQLTOJAVATYPES.put("FLOAT", "double");
        SQLTOJAVATYPES.put("INTEGER", "int");
        SQLTOJAVATYPES.put("JAVA_OBJECT", "java.lang.Object");
        SQLTOJAVATYPES.put("LONGVARBINARY", "byte[]");
        SQLTOJAVATYPES.put("LONGVARCHAR", "java.lang.String");
        SQLTOJAVATYPES.put("NULL", "java.lang.String");
        SQLTOJAVATYPES.put("NUMERIC", "java.math.BigDecimal");
        SQLTOJAVATYPES.put("OTHER", "java.lang.String");
        SQLTOJAVATYPES.put("REAL", "float");
        SQLTOJAVATYPES.put("REF", "java.sql.Ref");
        SQLTOJAVATYPES.put("SMALLINT", "short");
        SQLTOJAVATYPES.put("STRUCT", "java.sql.Struct");
        SQLTOJAVATYPES.put("TIME", "java.sql.Time");
        SQLTOJAVATYPES.put("TIMESTAMP", "java.sql.Timestamp");
        SQLTOJAVATYPES.put("TINYINT", "byte");
        SQLTOJAVATYPES.put("VARBINARY", "byte[]");
        SQLTOJAVATYPES.put("VARCHAR", "java.lang.String");
        SQLTOJAVATYPES.put("RESULTSET", "java.sql.ResultSet");
    }
}

