/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.wsdl;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.sql.project.wsdl.FileUtil;
import org.w3c.dom.Document;

public class SQLEngineFileGenerator {
    private Map sqlDefinitionMap = new HashMap();
    private String engineFileName = null;
    private String projectName = null;
    private static Logger logger = Logger.getLogger(SQLEngineFileGenerator.class.getName());

    public SQLEngineFileGenerator(String string, String string2) {
        this.engineFileName = string;
        this.projectName = string2;
    }

    public void addSQLDefinition(String string, DatabaseConnection databaseConnection) {
        this.sqlDefinitionMap.put(string, databaseConnection);
    }

    public void persistEngineFile(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<sqlengine name=\"" + this.projectName + "\">");
        for (Object object : this.sqlDefinitionMap.keySet()) {
            DatabaseConnection databaseConnection = (DatabaseConnection)this.sqlDefinitionMap.get(object);
            stringBuffer.append("<sqldef>\n");
            stringBuffer.append("<sqlfile name=\"" + (String)object + "\"/>" + "\n");
            stringBuffer.append("<connectiondef name=\"" + databaseConnection.getName() + "\"" + "\t");
            stringBuffer.append("driverClass=\"" + databaseConnection.getDriverClass() + "\"" + "\t");
            stringBuffer.append("dbURL=\"" + databaseConnection.getDatabaseURL() + "\"" + "\t");
            stringBuffer.append("databaseName=\"" + databaseConnection.getSchema() + "\"" + "\t");
            stringBuffer.append("user=\"" + databaseConnection.getUser() + "\"" + "\t");
            stringBuffer.append("password=\"" + databaseConnection.getPassword() + "\"" + "\t");
            stringBuffer.append("jndi_name=\"" + string + "\"" + "\t");
            stringBuffer.append("transactionRequired=\"" + string2 + "\"" + "\t");
            stringBuffer.append(">\n</connectiondef>");
            stringBuffer.append("\n</sqldef>");
        }
        stringBuffer.append("\n</sqlengine>");
        try {
            Object object;
            object = new FileOutputStream(this.engineFileName);
            FileUtil.copy(stringBuffer.toString().getBytes("UTF-8"), (OutputStream)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void indentWSDLFile(Writer writer, Document document) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            PrintWriter printWriter = new PrintWriter(writer);
            StreamResult streamResult = new StreamResult(printWriter);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
            }
            catch (Exception exception) {
                // empty catch block
            }
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

